/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.checkers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.papyrus.customization.properties.generation.generators.GeneratorHelper;
import org.eclipse.papyrus.infra.properties.contexts.ContextsPackage;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.DataContextPackage;
import org.eclipse.papyrus.infra.properties.contexts.DataContextRoot;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.util.ContextAnnotations;
import org.eclipse.papyrus.infra.properties.environment.EnvironmentPackage;
import org.eclipse.papyrus.infra.properties.environment.ModelElementFactoryDescriptor;
import org.eclipse.papyrus.infra.properties.environment.Type;
import org.eclipse.papyrus.infra.properties.ui.CompositeWidget;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.constants.PropertiesPluginValidationConstants;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.util.PropertiesCache;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.util.PropertyTypeHelper;

public class PropertiesContextCustomValidator
extends CustomModelChecker.SwitchValidator {
    private static final String OBSOLETE_DATA_CONTEXT_ELEMENTS = "obsoleteDataContextElement";
    private static final String CUSTOM_DATA_CONTEXT_ROOTS = "customDataContextRoots";
    private final Set<String> applicableModelElementFactories = Set.of("org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElementFactory", "org.eclipse.papyrus.uml.properties.modelelement.UMLModelElementFactory", "org.eclipse.papyrus.uml.properties.modelelement.StereotypeModelElementFactory");

    public PropertiesContextCustomValidator(String nsURI) {
        super(nsURI);
    }

    public void validate(DataContextPackage package_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (this.isInCustomDataContextRoot((EObject)package_, context)) {
            return;
        }
        if (package_.getPackage() != null && this.isObsolete((DataContextElement)package_.getPackage(), context)) {
            this.markObsolete((DataContextElement)package_, context);
            return;
        }
        PropertiesCache cache = PropertiesCache.getInstance((Notifier)package_);
        EObject sourcePackage = cache.getSourceElement((EObject)package_);
        if (sourcePackage == null) {
            diagnostics.add(this.createDiagnostic(2, (EObject)package_, this.format(Messages.PropertiesContextCustomValidator_0, context, new Object[]{package_}), IPluginChecker2.problem((int)16715842), new IPluginChecker2.MarkerAttribute[0]));
            this.markObsolete((DataContextElement)package_, context);
        } else if (sourcePackage.eIsProxy()) {
            if (package_ instanceof DataContextRoot) {
                diagnostics.add(this.createDiagnostic(2, (EObject)package_, this.format(Messages.PropertiesContextCustomValidator_12, context, new Object[]{package_}), IPluginChecker2.problem((int)16715853), new IPluginChecker2.MarkerAttribute[0]));
            } else {
                diagnostics.add(this.createDiagnostic(4, (EObject)package_, this.format(Messages.PropertiesContextCustomValidator_1, context, new Object[]{package_}), IPluginChecker2.problem((int)16715842), new IPluginChecker2.MarkerAttribute[0]));
            }
            this.markObsolete((DataContextElement)package_, context);
        } else {
            String sourceName = cache.getName(sourcePackage);
            if (!Objects.equals(sourceName, package_.getName())) {
                diagnostics.add(this.createDiagnostic(4, (EObject)package_, (EStructuralFeature)ContextsPackage.Literals.DATA_CONTEXT_ELEMENT__NAME, this.format(Messages.PropertiesContextCustomValidator_9, context, new Object[]{package_, sourceName, sourcePackage}), IPluginChecker2.problem((int)16715851), new IPluginChecker2.MarkerAttribute[]{PropertiesPluginValidationConstants.valueToSet(sourceName, EcorePackage.Literals.ESTRING)}));
            }
            this.checkForMissingPackages(package_, sourcePackage, diagnostics, context);
            this.checkForMissingClasses(package_, sourcePackage, diagnostics, context);
        }
    }

    protected boolean isInCustomDataContextRoot(EObject object, Map<Object, Object> context) {
        boolean result = false;
        if (object instanceof DataContextRoot) {
            DataContextRoot root = (DataContextRoot)object;
            Map customRoots = (Map)context.computeIfAbsent(CUSTOM_DATA_CONTEXT_ROOTS, __ -> new HashMap());
            result = customRoots.computeIfAbsent(root, dcr -> {
                ModelElementFactoryDescriptor factory = dcr.getModelElementFactory();
                if (factory != null && this.applicableModelElementFactories.contains(factory.getFactoryClass())) {
                    return false;
                }
                return true;
            });
        } else if (object.eContainer() != null) {
            result = this.isInCustomDataContextRoot(object.eContainer(), context);
        }
        return result;
    }

    private void checkForMissingPackages(DataContextPackage package_, EObject sourcePackage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        this.checkForMissingElements(package_, new HashSet<EObject>(PropertiesCache.getInstance((Notifier)package_).getNestedPackages(sourcePackage)), 16715852, Messages.PropertiesContextCustomValidator_13, diagnostics, context);
    }

    private void checkForMissingClasses(DataContextPackage package_, EObject sourcePackage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        this.checkForMissingElements(package_, new HashSet<EObject>(PropertiesCache.getInstance((Notifier)package_).getClasses(sourcePackage)), 16715843, Messages.PropertiesContextCustomValidator_2, diagnostics, context);
    }

    private void checkForMissingElements(DataContextPackage package_, Set<? extends EObject> sourceElements, int problemID, String messagePattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        PropertiesCache cache = PropertiesCache.getInstance((Notifier)package_);
        package_.getElements().stream().map(cache::getSourceElement).forEach(sourceElements::remove);
        if (!sourceElements.isEmpty()) {
            sourceElements.stream().map(sourceElement -> this.createDiagnostic(2, (EObject)package_, this.format(messagePattern, context, new Object[]{package_, sourceElement}), this.missingElementAttributes(package_, problemID, (EObject)sourceElement))).forEach(arg_0 -> ((DiagnosticChain)diagnostics).add(arg_0));
        }
    }

    private Collection<? extends IPluginChecker2.MarkerAttribute> missingElementAttributes(DataContextPackage package_, int problemID, EObject sourceClass) {
        ArrayList result = Lists.newArrayList((Object[])new IPluginChecker2.MarkerAttribute[]{IPluginChecker2.problem((int)problemID), PropertiesPluginValidationConstants.objectToReference(sourceClass)});
        this.addLayoutGenerator(result, (DataContextElement)package_);
        return result;
    }

    private void addLayoutGenerator(Collection<? super IPluginChecker2.MarkerAttribute> marker, DataContextElement element) {
        String layoutGenerator;
        DataContextRoot root = GeneratorHelper.getRoot((DataContextElement)element);
        String string = layoutGenerator = root != null ? ContextAnnotations.getLayoutGeneratorClassName((DataContextRoot)root) : null;
        if (layoutGenerator != null) {
            marker.add((IPluginChecker2.MarkerAttribute)new IPluginChecker2.MarkerAttribute("layout_generator", (Object)layoutGenerator));
        }
    }

    public void validate(DataContextElement element, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (element instanceof DataContextPackage) {
            return;
        }
        if (this.isInCustomDataContextRoot((EObject)element, context)) {
            return;
        }
        if (this.isObsolete((DataContextElement)element.getPackage(), context)) {
            this.markObsolete(element, context);
            return;
        }
        PropertiesCache cache = PropertiesCache.getInstance((Notifier)element);
        EObject sourceClass = cache.getSourceElement((EObject)element);
        if (sourceClass == null) {
            diagnostics.add(this.createDiagnostic(2, (EObject)element, this.format(Messages.PropertiesContextCustomValidator_3, context, new Object[]{element}), IPluginChecker2.problem((int)16715844), new IPluginChecker2.MarkerAttribute[0]));
            this.markObsolete(element, context);
        } else if (sourceClass.eIsProxy()) {
            diagnostics.add(this.createDiagnostic(4, (EObject)element, this.format(Messages.PropertiesContextCustomValidator_4, context, new Object[]{element}), IPluginChecker2.problem((int)16715844), new IPluginChecker2.MarkerAttribute[0]));
            this.markObsolete(element, context);
        } else {
            String sourceName = cache.getName(sourceClass);
            if (!Objects.equals(sourceName, element.getName())) {
                diagnostics.add(this.createDiagnostic(4, (EObject)element, (EStructuralFeature)ContextsPackage.Literals.DATA_CONTEXT_ELEMENT__NAME, this.format(Messages.PropertiesContextCustomValidator_10, context, new Object[]{element, sourceName, sourceClass}), IPluginChecker2.problem((int)16715850), new IPluginChecker2.MarkerAttribute[]{PropertiesPluginValidationConstants.valueToSet(sourceName, EcorePackage.Literals.ESTRING)}));
            }
            this.checkForMissingProperties(element, sourceClass, diagnostics, context);
        }
    }

    private void checkForMissingProperties(DataContextElement element, EObject sourceClass, DiagnosticChain diagnostics, Map<Object, Object> context) {
        PropertiesCache cache = PropertiesCache.getInstance((Notifier)element);
        HashSet<? extends EObject> properties = new HashSet<EObject>(cache.getProperties(sourceClass));
        properties.removeIf(cache::isPropertyRedefinition);
        element.getProperties().stream().map(cache::getSourceElement).forEach(properties::remove);
        if (!properties.isEmpty()) {
            properties.stream().map(sourceProp -> this.createDiagnostic(2, (EObject)element, this.format(Messages.PropertiesContextCustomValidator_5, context, new Object[]{element, sourceProp}), this.missingPropertyAttributes(element, (EObject)sourceProp))).forEach(arg_0 -> ((DiagnosticChain)diagnostics).add(arg_0));
        }
    }

    private Collection<? extends IPluginChecker2.MarkerAttribute> missingPropertyAttributes(DataContextElement element, EObject sourceProperty) {
        ArrayList result = Lists.newArrayList((Object[])new IPluginChecker2.MarkerAttribute[]{IPluginChecker2.problem((int)16715845), PropertiesPluginValidationConstants.objectToReference(sourceProperty)});
        this.addLayoutGenerator(result, element);
        return result;
    }

    private void markObsolete(DataContextElement element, Map<Object, Object> context) {
        if (context != null) {
            Set obsolete = (Set)context.computeIfAbsent(OBSOLETE_DATA_CONTEXT_ELEMENTS, __ -> new HashSet());
            obsolete.add(element);
        }
    }

    private boolean isObsolete(DataContextElement element, Map<Object, Object> context) {
        boolean result = false;
        if (context != null) {
            Set obsolete = (Set)context.get(OBSOLETE_DATA_CONTEXT_ELEMENTS);
            result = obsolete != null && obsolete.contains(element);
        }
        return result;
    }

    public void validate(Property property, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (this.isObsolete(property.getContextElement(), context)) {
            return;
        }
        if (this.isInCustomDataContextRoot((EObject)property, context)) {
            return;
        }
        PropertiesCache cache = PropertiesCache.getInstance((Notifier)property);
        EObject sourceProperty = cache.getSourceElement((EObject)property);
        if (sourceProperty == null) {
            diagnostics.add(this.createDiagnostic(2, (EObject)property, this.format(Messages.PropertiesContextCustomValidator_6, context, new Object[]{property}), IPluginChecker2.problem((int)16715846), new IPluginChecker2.MarkerAttribute[0]));
        } else if (sourceProperty.eIsProxy()) {
            diagnostics.add(this.createDiagnostic(4, (EObject)property, this.format(Messages.PropertiesContextCustomValidator_7, context, new Object[]{property}), IPluginChecker2.problem((int)16715846), new IPluginChecker2.MarkerAttribute[0]));
        } else {
            String sourceName = cache.getName(sourceProperty);
            if (!Objects.equals(sourceName, property.getName())) {
                diagnostics.add(this.createDiagnostic(4, (EObject)property, (EStructuralFeature)ContextsPackage.Literals.PROPERTY__NAME, this.format(Messages.PropertiesContextCustomValidator_11, context, new Object[]{property, sourceName, sourceProperty}), IPluginChecker2.problem((int)16715849), new IPluginChecker2.MarkerAttribute[]{PropertiesPluginValidationConstants.valueToSet(sourceName, EcorePackage.Literals.ESTRING)}));
            }
            if (property.getType() != null) {
                this.validatePropertyType(property, sourceProperty, diagnostics, context);
            }
            this.validatePropertyMultiplicity(property, sourceProperty, diagnostics, context);
        }
    }

    private void validatePropertyType(Property property, EObject sourceProperty, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Type expectedType = PropertyTypeHelper.getInstance(property).getPropertyType(sourceProperty);
        if (expectedType != property.getType()) {
            diagnostics.add(this.createDiagnostic(2, (EObject)property, (EStructuralFeature)ContextsPackage.Literals.PROPERTY__TYPE, this.format(Messages.PropertiesContextCustomValidator_8, context, new Object[]{property, this.value(ContextsPackage.Literals.PROPERTY__TYPE, expectedType), sourceProperty}), IPluginChecker2.problem((int)16715847), new IPluginChecker2.MarkerAttribute[]{PropertiesPluginValidationConstants.valueToSet(expectedType, (EDataType)EnvironmentPackage.Literals.TYPE)}));
        }
    }

    public void validate(Section section, DiagnosticChain diagnostics, Map<Object, Object> context) {
        CompositeWidget widget = section.getWidget();
        if (widget != null && !widget.eIsProxy()) {
            this.validateResource(widget.eResource(), context);
        }
    }

    private void validatePropertyMultiplicity(Property property, EObject sourceProperty, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int expectedMultiplicity = PropertyTypeHelper.getInstance(property).getMultiplicity(sourceProperty);
        if (expectedMultiplicity != property.getMultiplicity()) {
            diagnostics.add(this.createDiagnostic(2, (EObject)property, (EStructuralFeature)ContextsPackage.Literals.PROPERTY__MULTIPLICITY, this.format(Messages.PropertiesContextCustomValidator_14, context, new Object[]{property, this.value(ContextsPackage.Literals.PROPERTY__MULTIPLICITY, expectedMultiplicity), sourceProperty}), IPluginChecker2.problem((int)16715856), new IPluginChecker2.MarkerAttribute[]{PropertiesPluginValidationConstants.valueToSet(expectedMultiplicity, EcorePackage.Literals.EINT)}));
        }
    }
}

