/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.internationalization.utils.utils;

import java.util.Locale;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationUtils;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Stereotype;

public class UMLLabelInternationalization {
    private static UMLLabelInternationalization instance;

    protected UMLLabelInternationalization() {
    }

    public static UMLLabelInternationalization getInstance() {
        if (instance == null) {
            instance = new UMLLabelInternationalization();
        }
        return instance;
    }

    public String getLabel(NamedElement namedElement) {
        return this.getLabel(namedElement, true);
    }

    public String getLabel(NamedElement namedElement, boolean localize) {
        String result = null;
        if (namedElement.eResource() != null) {
            URI resourceURI = namedElement.eResource().getURI();
            ResourceSet resourceSet = namedElement.eResource().getResourceSet();
            if (resourceSet instanceof ModelSet) {
                resourceURI = ((ModelSet)resourceSet).getURIWithoutExtension().appendFileExtension("di");
            }
            if (InternationalizationPreferencesUtils.getInternationalizationPreference((URI)resourceURI)) {
                result = this.getLabelWithoutUML(namedElement, localize);
            }
        }
        String name = null;
        name = namedElement.getName() == null ? "" : namedElement.getName();
        return result != null ? result : name;
    }

    public String getLabelWithoutUML(NamedElement namedElement) {
        return this.getLabelWithoutUML(namedElement, true);
    }

    public String getLabelWithoutUML(NamedElement namedElement, boolean localize) {
        return LabelInternationalizationUtils.getLabelWithoutSubstract((EObject)namedElement, (boolean)localize);
    }

    public void setLabel(NamedElement namedElement, String value, Locale locale) {
        LabelInternationalizationUtils.setLabel((EObject)namedElement, (String)value, (Locale)locale);
    }

    public Command getSetLabelCommand(EditingDomain domain, NamedElement namedElement, String value, Locale locale) {
        return LabelInternationalizationUtils.getSetLabelCommand((EditingDomain)domain, (EObject)namedElement, (String)value, (Locale)locale);
    }

    public String getKeyword(Stereotype stereotype) {
        return this.getKeyword(stereotype, true);
    }

    public String getKeyword(Stereotype stereotype, boolean localize) {
        String result = null;
        if (stereotype.eResource() != null) {
            URI resourceURI = stereotype.eResource().getURI();
            ResourceSet resourceSet = stereotype.eResource().getResourceSet();
            if (resourceSet instanceof ModelSet) {
                resourceURI = ((ModelSet)resourceSet).getURIWithoutExtension().appendFileExtension("di");
            }
            if (InternationalizationPreferencesUtils.getInternationalizationPreference((URI)resourceURI)) {
                result = LabelInternationalizationUtils.getLabelWithoutSubstract((EObject)stereotype, (boolean)localize);
            }
        }
        return result != null ? result : stereotype.getName();
    }

    public String getKeywordWithoutUML(Stereotype stereotype) {
        return this.getKeywordWithoutUML(stereotype, true);
    }

    public String getKeywordWithoutUML(Stereotype stereotype, boolean localize) {
        return LabelInternationalizationUtils.getLabelWithoutSubstract((EObject)stereotype, (boolean)localize);
    }

    public void setKeyword(Stereotype stereotype, String value, Locale locale) {
        LabelInternationalizationUtils.setLabel((EObject)stereotype, (String)value, (Locale)locale);
    }

    public Command getSetKeywordCommand(EditingDomain domain, Stereotype stereotype, String value, Locale locale) {
        return LabelInternationalizationUtils.getSetLabelCommand((EditingDomain)domain, (EObject)stereotype, (String)value, (Locale)locale);
    }

    public String getQualifiedLabel(NamedElement namedElement) {
        StringBuilder result = null;
        String name = this.getLabel(namedElement);
        if (!UML2Util.isEmpty((String)name)) {
            result = new StringBuilder(name);
            for (Namespace namespace : namedElement.allNamespaces()) {
                String namespaceLabel = this.getLabel((NamedElement)namespace);
                if (UML2Util.isEmpty((String)namespaceLabel)) {
                    result = null;
                    break;
                }
                result.insert(0, namespace.separator());
                result.insert(0, namespaceLabel);
            }
        }
        return result != null ? result.toString() : null;
    }
}

