/*
 * generated by Xtext
 */
package org.eclipse.papyrus.uml.textedit.parameter.xtext.serializer;

import java.util.Set;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.uml.textedit.common.xtext.serializer.UmlCommonSemanticSequencer;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.BoundSpecification;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.MultiplicityRule;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.QualifiedName;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.TypeRule;
import org.eclipse.papyrus.uml.textedit.common.xtext.umlCommon.UmlCommonPackage;
import org.eclipse.papyrus.uml.textedit.parameter.xtext.services.UmlParameterGrammarAccess;
import org.eclipse.papyrus.uml.textedit.parameter.xtext.umlParameter.BooleanValue;
import org.eclipse.papyrus.uml.textedit.parameter.xtext.umlParameter.DefaultValueRule;
import org.eclipse.papyrus.uml.textedit.parameter.xtext.umlParameter.DirectionRule;
import org.eclipse.papyrus.uml.textedit.parameter.xtext.umlParameter.EffectRule;
import org.eclipse.papyrus.uml.textedit.parameter.xtext.umlParameter.IntValue;
import org.eclipse.papyrus.uml.textedit.parameter.xtext.umlParameter.ModifierSpecification;
import org.eclipse.papyrus.uml.textedit.parameter.xtext.umlParameter.ModifiersRule;
import org.eclipse.papyrus.uml.textedit.parameter.xtext.umlParameter.NoValue;
import org.eclipse.papyrus.uml.textedit.parameter.xtext.umlParameter.NullValue;
import org.eclipse.papyrus.uml.textedit.parameter.xtext.umlParameter.ParameterRule;
import org.eclipse.papyrus.uml.textedit.parameter.xtext.umlParameter.RealValue;
import org.eclipse.papyrus.uml.textedit.parameter.xtext.umlParameter.StringValue;
import org.eclipse.papyrus.uml.textedit.parameter.xtext.umlParameter.UmlParameterPackage;
import org.eclipse.papyrus.uml.textedit.parameter.xtext.umlParameter.VisibilityRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

import com.google.inject.Inject;

@SuppressWarnings("all")
public class UmlParameterSemanticSequencer extends UmlCommonSemanticSequencer {

	@Inject
	private UmlParameterGrammarAccess grammarAccess;

	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == UmlCommonPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case UmlCommonPackage.BOUND_SPECIFICATION:
				sequence_BoundSpecification(context, (BoundSpecification) semanticObject);
				return;
			case UmlCommonPackage.MULTIPLICITY_RULE:
				sequence_MultiplicityRule(context, (MultiplicityRule) semanticObject);
				return;
			case UmlCommonPackage.QUALIFIED_NAME:
				sequence_QualifiedName(context, (QualifiedName) semanticObject);
				return;
			case UmlCommonPackage.TYPE_RULE:
				sequence_TypeRule(context, (TypeRule) semanticObject);
				return;
			}
		else if (epackage == UmlParameterPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case UmlParameterPackage.BOOLEAN_VALUE:
				sequence_BooleanValue(context, (BooleanValue) semanticObject);
				return;
			case UmlParameterPackage.DEFAULT_VALUE_RULE:
				sequence_DefaultValueRule(context, (DefaultValueRule) semanticObject);
				return;
			case UmlParameterPackage.DIRECTION_RULE:
				sequence_DirectionRule(context, (DirectionRule) semanticObject);
				return;
			case UmlParameterPackage.EFFECT_RULE:
				sequence_EffectRule(context, (EffectRule) semanticObject);
				return;
			case UmlParameterPackage.INT_VALUE:
				sequence_IntValue(context, (IntValue) semanticObject);
				return;
			case UmlParameterPackage.MODIFIER_SPECIFICATION:
				sequence_ModifierSpecification(context, (ModifierSpecification) semanticObject);
				return;
			case UmlParameterPackage.MODIFIERS_RULE:
				sequence_ModifiersRule(context, (ModifiersRule) semanticObject);
				return;
			case UmlParameterPackage.NO_VALUE:
				sequence_NoValue(context, (NoValue) semanticObject);
				return;
			case UmlParameterPackage.NULL_VALUE:
				sequence_NullValue(context, (NullValue) semanticObject);
				return;
			case UmlParameterPackage.PARAMETER_RULE:
				sequence_ParameterRule(context, (ParameterRule) semanticObject);
				return;
			case UmlParameterPackage.REAL_VALUE:
				sequence_RealValue(context, (RealValue) semanticObject);
				return;
			case UmlParameterPackage.STRING_VALUE:
				sequence_StringValue(context, (StringValue) semanticObject);
				return;
			case UmlParameterPackage.VISIBILITY_RULE:
				sequence_VisibilityRule(context, (VisibilityRule) semanticObject);
				return;
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}

	/**
	 * Contexts:
	 * Value returns BooleanValue
	 * BooleanValue returns BooleanValue
	 *
	 * Constraint:
	 * literalBoolean=BooleanLiterals
	 */
	protected void sequence_BooleanValue(ISerializationContext context, BooleanValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, UmlParameterPackage.Literals.BOOLEAN_VALUE__LITERAL_BOOLEAN) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, UmlParameterPackage.Literals.BOOLEAN_VALUE__LITERAL_BOOLEAN));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getBooleanValueAccess().getLiteralBooleanBooleanLiteralsEnumRuleCall_0(), semanticObject.getLiteralBoolean());
		feeder.finish();
	}


	/**
	 * Contexts:
	 * DefaultValueRule returns DefaultValueRule
	 *
	 * Constraint:
	 * default=Value
	 */
	protected void sequence_DefaultValueRule(ISerializationContext context, DefaultValueRule semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, UmlParameterPackage.Literals.DEFAULT_VALUE_RULE__DEFAULT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, UmlParameterPackage.Literals.DEFAULT_VALUE_RULE__DEFAULT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getDefaultValueRuleAccess().getDefaultValueParserRuleCall_1_0(), semanticObject.getDefault());
		feeder.finish();
	}


	/**
	 * Contexts:
	 * DirectionRule returns DirectionRule
	 *
	 * Constraint:
	 * direction=Direction
	 */
	protected void sequence_DirectionRule(ISerializationContext context, DirectionRule semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, UmlParameterPackage.Literals.DIRECTION_RULE__DIRECTION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, UmlParameterPackage.Literals.DIRECTION_RULE__DIRECTION));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getDirectionRuleAccess().getDirectionDirectionEnumRuleCall_0(), semanticObject.getDirection());
		feeder.finish();
	}


	/**
	 * Contexts:
	 * EffectRule returns EffectRule
	 *
	 * Constraint:
	 * effectKind=EffectKind
	 */
	protected void sequence_EffectRule(ISerializationContext context, EffectRule semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, UmlParameterPackage.Literals.EFFECT_RULE__EFFECT_KIND) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, UmlParameterPackage.Literals.EFFECT_RULE__EFFECT_KIND));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getEffectRuleAccess().getEffectKindEffectKindEnumRuleCall_2_0(), semanticObject.getEffectKind());
		feeder.finish();
	}


	/**
	 * Contexts:
	 * Value returns IntValue
	 * IntValue returns IntValue
	 *
	 * Constraint:
	 * literalInteger=INT
	 */
	protected void sequence_IntValue(ISerializationContext context, IntValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, UmlParameterPackage.Literals.INT_VALUE__LITERAL_INTEGER) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, UmlParameterPackage.Literals.INT_VALUE__LITERAL_INTEGER));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getIntValueAccess().getLiteralIntegerINTTerminalRuleCall_0(), semanticObject.getLiteralInteger());
		feeder.finish();
	}


	/**
	 * Contexts:
	 * ModifierSpecification returns ModifierSpecification
	 *
	 * Constraint:
	 * value=ModifierKind
	 */
	protected void sequence_ModifierSpecification(ISerializationContext context, ModifierSpecification semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, UmlParameterPackage.Literals.MODIFIER_SPECIFICATION__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, UmlParameterPackage.Literals.MODIFIER_SPECIFICATION__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getModifierSpecificationAccess().getValueModifierKindEnumRuleCall_0(), semanticObject.getValue());
		feeder.finish();
	}


	/**
	 * Contexts:
	 * ModifiersRule returns ModifiersRule
	 *
	 * Constraint:
	 * (values+=ModifierSpecification values+=ModifierSpecification*)?
	 */
	protected void sequence_ModifiersRule(ISerializationContext context, ModifiersRule semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Contexts:
	 * Value returns NoValue
	 * NoValue returns NoValue
	 *
	 * Constraint:
	 * {NoValue}
	 */
	protected void sequence_NoValue(ISerializationContext context, NoValue semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Contexts:
	 * Value returns NullValue
	 * NullValue returns NullValue
	 *
	 * Constraint:
	 * {NullValue}
	 */
	protected void sequence_NullValue(ISerializationContext context, NullValue semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Contexts:
	 * ParameterRule returns ParameterRule
	 *
	 * Constraint:
	 * (
	 * visibility=VisibilityRule?
	 * direction=DirectionRule?
	 * name=ID
	 * (type=TypeRule | typeUndefined?='<Undefined>')?
	 * multiplicity=MultiplicityRule?
	 * modifiers=ModifiersRule?
	 * effect=EffectRule?
	 * defaultValue=DefaultValueRule?
	 * )
	 */
	protected void sequence_ParameterRule(ISerializationContext context, ParameterRule semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Contexts:
	 * Value returns RealValue
	 * RealValue returns RealValue
	 *
	 * Constraint:
	 * (integer=INT | fraction=INT | (integer=INT fraction=INT))
	 */
	protected void sequence_RealValue(ISerializationContext context, RealValue semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Contexts:
	 * Value returns StringValue
	 * StringValue returns StringValue
	 *
	 * Constraint:
	 * literalString=STRING
	 */
	protected void sequence_StringValue(ISerializationContext context, StringValue semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, UmlParameterPackage.Literals.STRING_VALUE__LITERAL_STRING) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, UmlParameterPackage.Literals.STRING_VALUE__LITERAL_STRING));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getStringValueAccess().getLiteralStringSTRINGTerminalRuleCall_0(), semanticObject.getLiteralString());
		feeder.finish();
	}


	/**
	 * Contexts:
	 * VisibilityRule returns VisibilityRule
	 *
	 * Constraint:
	 * visibility=VisibilityKind
	 */
	protected void sequence_VisibilityRule(ISerializationContext context, VisibilityRule semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, UmlParameterPackage.Literals.VISIBILITY_RULE__VISIBILITY) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, UmlParameterPackage.Literals.VISIBILITY_RULE__VISIBILITY));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getVisibilityRuleAccess().getVisibilityVisibilityKindEnumRuleCall_0(), semanticObject.getVisibility());
		feeder.finish();
	}


}
