/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.bundles.tests;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.feature.Feature;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundleTestsUtils {
    public static final String INCUBATION = "(Incubation)";
    public static final String VENDOR_NAME = "Eclipse Modeling Project";
    public static final String BUNDLE_NAME = "Bundle-Name";
    public static final String BUNDLE_VENDOR = "Bundle-Vendor";
    public static final String BUNDLE_VERSION = "Bundle-Version";
    public static final String PAPYRUS_PREFIX = "org.eclipse.papyrus.";
    public static final String BUNDLE_REQUIREDEXECUTIONENVIRONMENT = "Bundle-RequiredExecutionEnvironment";
    public static final String BUNDLE_IMPORT_PACKAGE = "Import-Package";
    public static final String JAVA_VERSION_5 = "J2SE-1.5";
    public static final String JAVA_VERSION_6 = "JavaSE-1.6";
    public static final String JAVA_VERSION_7 = "JavaSE-1.7";
    public static final String JAVA_VERSION_8 = "JavaSE-1.8";
    public static final String JAVA_VERSION_11 = "JavaSE-11";
    public static final String JAVA_VERSION_REGEX = Stream.of("J2SE-1.5", "JavaSE-1.6", "JavaSE-1.7", "JavaSE-1.8", "JavaSE-11").map(Pattern::quote).collect(Collectors.joining("|"));
    public static final String REQUIRE_BUNDLE = "Require-Bundle";

    private BundleTestsUtils() {
    }

    public static List<Bundle> getPapyrusBundles() {
        ArrayList<Bundle> papyrusBundle = new ArrayList<Bundle>();
        BundleContext context = InternalPlatform.getDefault().getBundleContext();
        Bundle[] bundles = context.getBundles();
        int i = 0;
        while (i < bundles.length) {
            String currentName = bundles[i].getSymbolicName();
            if (currentName.startsWith(PAPYRUS_PREFIX)) {
                papyrusBundle.add(bundles[i]);
            }
            ++i;
        }
        return papyrusBundle;
    }

    public static boolean isJavaProject(Bundle bundle) {
        URL res = bundle.getResource("org/eclipse/papyrus");
        return res != null;
    }

    public static List<Feature> getPapyrusFeature() {
        IFeatureModel[] models2;
        ArrayList<Feature> features = new ArrayList<Feature>();
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IFeatureModel[] iFeatureModelArray = models2 = manager.getModels();
        int n = models2.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel iFeatureModel = iFeatureModelArray[n2];
            IFeature feature = iFeatureModel.getFeature();
            String id = feature.getId();
            if (id.startsWith(PAPYRUS_PREFIX)) {
                features.add((Feature)feature);
            }
            ++n2;
        }
        return features;
    }
}

