/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;

public class PlatformHelper {
    public static <T> T getAdapter(Object object, Class<T> type) {
        T result = null;
        if (object != null) {
            if (type.isInstance(object)) {
                result = type.cast(object);
            } else if (object instanceof IAdaptable) {
                result = PlatformHelper.getIntrinsicAdapter((IAdaptable)object, type);
            }
            if (result == null && (result = (T)PlatformHelper.getExtrinsicAdapter(object, type)) == null && object instanceof Notifier) {
                result = PlatformHelper.getEMFAdapter((Notifier)object, type);
            }
        }
        return result;
    }

    private static <T> T getIntrinsicAdapter(IAdaptable adaptable, Class<T> type) {
        T result = null;
        Object attempt = adaptable.getAdapter(type);
        if (type.isInstance(attempt)) {
            result = type.cast(attempt);
        }
        return result;
    }

    private static <T> T getExtrinsicAdapter(Object object, Class<T> type) {
        T result = null;
        Object attempt = Platform.getAdapterManager().getAdapter(object, type);
        if (type.isInstance(attempt)) {
            result = type.cast(attempt);
        }
        return result;
    }

    private static <T> T getEMFAdapter(Notifier notifier, Class<T> type) {
        return (T)Iterables.find((Iterable)Iterables.filter((Iterable)notifier.eAdapters(), type), (Predicate)Predicates.alwaysTrue(), null);
    }

    public static <T> T getAdapter(Object object, Class<T> type, T defaultAdapter) {
        T adapter;
        T result = defaultAdapter;
        if (object != null && (adapter = PlatformHelper.getAdapter(object, type)) != null) {
            result = adapter;
        }
        return result;
    }

    public static <T> T getAdapter(Object object, Class<T> type, Supplier<T> defaultAdapter) {
        T adapter;
        T result = null;
        if (object != null && (adapter = PlatformHelper.getAdapter(object, type)) != null) {
            result = adapter;
        }
        return result != null ? result : (T)defaultAdapter.get();
    }
}

