/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.checkers;

import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EValidatorRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.AbstractPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelValidationChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.messages.Messages;

public class CustomModelChecker
extends AbstractPluginChecker {
    private final Resource resource;
    private final Map<String, Function<? super String, ? extends EValidator>> validatorFactories = new HashMap<String, Function<? super String, ? extends EValidator>>();
    private final EValidator nullValidator = new NullValidator();
    private Function<? super AdapterFactory, ? extends AdapterFactory> adapterFactoryDecoratorFunction;

    public CustomModelChecker(IFile modelFile, Resource resource, String markerType) {
        super(modelFile.getProject(), modelFile, markerType);
        this.resource = resource;
    }

    public CustomModelChecker withValidator(String packageNSURI, Function<? super String, ? extends EValidator> validatorFactory) {
        this.validatorFactories.put(packageNSURI, validatorFactory);
        return this;
    }

    public <A extends AdapterFactory & IDisposable> CustomModelChecker withAdapterFactoryDecorator(Function<? super AdapterFactory, A> decoratorFunction) {
        this.adapterFactoryDecoratorFunction = decoratorFunction;
        return this;
    }

    @Override
    public void check(DiagnosticChain diagnostics, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.CustomModelChecker_0, (Object)this.getModelFile().getName()), (int)1);
        ComposedAdapterFactory composed = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        AdapterFactory adapterFactory = this.decorateAdapterFactory((AdapterFactory)composed);
        if (!(adapterFactory instanceof IDisposable)) {
            composed.dispose();
            throw new IllegalStateException("adapter factory is not disposable");
        }
        EValidator.SubstitutionLabelProvider labels = ModelValidationChecker.createSubstitutionLabelProvider(adapterFactory);
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        context.put(EValidator.SubstitutionLabelProvider.class, labels);
        try {
            BasicDiagnostic validationResults = new BasicDiagnostic();
            Diagnostician diagnostician = new Diagnostician((EValidator.Registry)new ValidatorRegistry());
            ResourceQueue queue = ResourceQueue.getInstance(context);
            queue.offer(this.resource);
            Resource resource = (Resource)queue.poll();
            while (resource != null) {
                for (EObject next : resource.getContents()) {
                    diagnostician.validate(next, (DiagnosticChain)validationResults, context);
                }
                resource = (Resource)queue.poll();
            }
            if (validationResults.getSeverity() > 0) {
                diagnostics.merge(this.wrap((Diagnostic)validationResults));
            }
        }
        finally {
            ((IDisposable)adapterFactory).dispose();
        }
        subMonitor.worked(1);
        SubMonitor.done((IProgressMonitor)monitor);
    }

    private AdapterFactory decorateAdapterFactory(AdapterFactory adapterFactory) {
        return this.adapterFactoryDecoratorFunction != null ? this.adapterFactoryDecoratorFunction.apply((AdapterFactory)adapterFactory) : adapterFactory;
    }

    private static final class NullValidator
    implements EValidator {
        private NullValidator() {
        }

        public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
            return true;
        }

        public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
            return true;
        }

        public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
            return true;
        }
    }

    private static final class ResourceQueue
    extends ArrayDeque<Resource> {
        private final Set<Resource> processed = new HashSet<Resource>();

        private ResourceQueue() {
        }

        static ResourceQueue getInstance(Map<Object, Object> context) {
            ResourceQueue result = (ResourceQueue)context.get(ResourceQueue.class);
            if (result == null) {
                result = new ResourceQueue();
                context.put(ResourceQueue.class, result);
            }
            return result;
        }

        @Override
        public boolean offerFirst(Resource e) {
            return !this.processed.contains(e) && super.offerFirst(e);
        }

        @Override
        public boolean offerLast(Resource e) {
            return !this.processed.contains(e) && super.offerLast(e);
        }

        @Override
        public void addFirst(Resource e) {
            if (this.processed.add(e)) {
                super.addFirst(e);
            }
        }

        @Override
        public void addLast(Resource e) {
            if (this.processed.add(e)) {
                super.addLast(e);
            }
        }
    }

    public static abstract class SwitchValidator
    implements EValidator {
        private final String nsURI;
        private final String source;
        private final Map<EClass, MethodHandle> validationMethods = new HashMap<EClass, MethodHandle>();
        private CustomModelChecker owner;

        public SwitchValidator(EPackage ePackage) {
            this(ePackage.getNsURI());
        }

        public SwitchValidator(String nsURI) {
            this.nsURI = nsURI;
            this.source = this.getClass().getSimpleName();
        }

        void setOwner(CustomModelChecker owner) {
            this.owner = owner;
        }

        protected String getObjectLabel(EObject object, Map<Object, Object> context) {
            return EObjectValidator.getObjectLabel((EObject)object, context);
        }

        protected String getFeatureLabel(EStructuralFeature feature, Map<Object, Object> context) {
            return EObjectValidator.getFeatureLabel((EStructuralFeature)feature, context);
        }

        protected String getValueLabel(EDataType dataType, Object value, Map<Object, Object> context) {
            return EObjectValidator.getValueLabel((EDataType)dataType, (Object)value, context);
        }

        protected final String format(String pattern, Map<Object, Object> context, Object ... argument) {
            Object[] bindings = Stream.of(argument).map(arg -> this.formatArgument(arg, context)).toArray();
            return NLS.bind((String)pattern, (Object[])bindings);
        }

        protected final Object value(EAttribute attribute, Object value) {
            return this.value(attribute.getEAttributeType(), value);
        }

        protected final Object value(EDataType dataType, Object value) {
            return new Value(dataType, value);
        }

        private Object formatArgument(Object argument, Map<Object, Object> context) {
            Object result = argument;
            if (argument instanceof EStructuralFeature) {
                result = this.getFeatureLabel((EStructuralFeature)argument, context);
            } else if (argument instanceof EObject) {
                result = this.getObjectLabel((EObject)argument, context);
            } else if (argument instanceof Value) {
                Value value = (Value)argument;
                result = this.getValueLabel(value.dataType, value.value, context);
            } else if (argument instanceof Iterable) {
                result = StreamSupport.stream(((Iterable)argument).spliterator(), false).map(el -> this.formatArgument(el, context)).map(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
            } else if (argument instanceof Object[]) {
                result = Stream.of((Object[])argument).map(el -> this.formatArgument(el, context)).map(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
            }
            return result;
        }

        protected Diagnostic createDiagnostic(int severity, EObject eObject, EStructuralFeature feature, int code, String message) {
            List<Object> data = this.diagnosticData(eObject, feature);
            return new BasicDiagnostic(severity, this.source, code, message, data.toArray());
        }

        protected Diagnostic createDiagnostic(int severity, EObject eObject, int code, String message) {
            List<Object> data = this.diagnosticData(eObject, null);
            return new BasicDiagnostic(severity, this.source, code, message, data.toArray());
        }

        protected Diagnostic createDiagnostic(int severity, EObject eObject, EStructuralFeature feature, String message) {
            return this.createDiagnostic(severity, eObject, feature, 0, message);
        }

        protected Diagnostic createDiagnostic(int severity, EObject eObject, String message) {
            return this.createDiagnostic(severity, eObject, 0, message);
        }

        private List<Object> diagnosticData(EObject eObject, EStructuralFeature feature) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(eObject);
            if (feature != null) {
                result.add(feature);
            }
            if (this.owner != null) {
                result.add(this.owner.getProject());
                result.add(this.owner.getModelFile());
                result.add(IPluginChecker2.markerType(this.owner.getMarkerType()));
            }
            return result;
        }

        protected Diagnostic createDiagnostic(int severity, EObject eObject, String message, IPluginChecker2.MarkerAttribute attr1, IPluginChecker2.MarkerAttribute ... moreAttrs) {
            return this.createDiagnostic(severity, eObject, null, 0, message, attr1, moreAttrs);
        }

        protected Diagnostic createDiagnostic(int severity, EObject eObject, EStructuralFeature feature, String message, IPluginChecker2.MarkerAttribute attr1, IPluginChecker2.MarkerAttribute ... moreAttrs) {
            return this.createDiagnostic(severity, eObject, feature, 0, message, attr1, moreAttrs);
        }

        protected Diagnostic createDiagnostic(int severity, EObject eObject, EStructuralFeature feature, int code, String message, IPluginChecker2.MarkerAttribute attr1, IPluginChecker2.MarkerAttribute ... moreAttrs) {
            return this.createDiagnostic(severity, eObject, feature, code, message, Lists.asList((Object)attr1, (Object[])moreAttrs));
        }

        protected Diagnostic createDiagnostic(int severity, EObject eObject, String message, Collection<? extends IPluginChecker2.MarkerAttribute> moreAttrs) {
            return this.createDiagnostic(severity, eObject, null, 0, message, moreAttrs);
        }

        protected Diagnostic createDiagnostic(int severity, EObject eObject, EStructuralFeature feature, String message, Collection<? extends IPluginChecker2.MarkerAttribute> moreAttrs) {
            return this.createDiagnostic(severity, eObject, feature, 0, message, moreAttrs);
        }

        protected Diagnostic createDiagnostic(int severity, EObject eObject, EStructuralFeature feature, int code, String message, Collection<? extends IPluginChecker2.MarkerAttribute> moreAttrs) {
            List<Object> data = this.diagnosticData(eObject, feature);
            data.addAll(moreAttrs);
            return new BasicDiagnostic(severity, this.source, code, message, data.toArray());
        }

        protected void validateResource(Resource auxiliaryResource, Map<Object, Object> context) {
            if (auxiliaryResource != null && auxiliaryResource.isLoaded()) {
                ResourceQueue.getInstance(context).offer(auxiliaryResource);
            }
        }

        protected boolean isValidatorFor(EPackage ePackage) {
            return this.nsURI.equals(ePackage.getNsURI());
        }

        public final boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
            return this.validate(eObject.eClass(), eObject, diagnostics, context);
        }

        public final boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
            EPackage ePackage = eClass.getEPackage();
            if (this.isValidatorFor(ePackage)) {
                this.doValidate(eClass, eObject, diagnostics, context);
                EList allSuperTypes = eClass.getEAllSuperTypes();
                if (!allSuperTypes.isEmpty()) {
                    for (EClass superClass : allSuperTypes) {
                        this.doValidate(superClass, eObject, diagnostics, context);
                    }
                }
                if (!this.isValidatorFor((EPackage)EcorePackage.eINSTANCE) && !allSuperTypes.contains((Object)EcorePackage.Literals.EOBJECT)) {
                    this.doValidate(EcorePackage.Literals.EOBJECT, eObject, diagnostics, context);
                }
            }
            return true;
        }

        public final boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
            return true;
        }

        private void doValidate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
            MethodHandle validationMethod = this.getValidationMethod(eClass);
            try {
                validationMethod.invoke(eObject, diagnostics, context);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                Activator.log.error("Uncaught exception in validation method.", e);
            }
        }

        private MethodHandle getValidationMethod(EClass eClass) {
            MethodHandle result = this.validationMethods.get(eClass);
            if (result == null) {
                result = this.lookupValidationMethod(eClass);
                this.validationMethods.put(eClass, result);
            }
            return result;
        }

        private MethodHandle lookupValidationMethod(EClass eClass) {
            MethodHandle result;
            MethodType methodType = this.validationMethodType(eClass);
            try {
                String methodName = eClass == EcorePackage.Literals.EOBJECT ? "validateDefault" : "validate";
                result = MethodHandles.lookup().findVirtual(this.getClass(), methodName, methodType).bindTo(this);
            }
            catch (Exception e) {
                result = MethodHandles.empty(methodType);
            }
            return result;
        }

        private MethodType validationMethodType(EClass eClass) {
            Class<EObject> instanceClass = eClass.getInstanceClass();
            if (instanceClass == null) {
                instanceClass = EObject.class;
            }
            return MethodType.methodType(Void.TYPE, instanceClass, DiagnosticChain.class, Map.class);
        }
    }

    private final class ValidatorRegistry
    extends EValidatorRegistryImpl {
        private final Function<String, EValidator> nullFactory = __ -> CustomModelChecker.this.nullValidator;

        private ValidatorRegistry() {
        }

        protected Object delegatedGet(Object key) {
            EValidator result = CustomModelChecker.this.nullValidator;
            if (key instanceof EPackage) {
                EPackage ePackage = (EPackage)key;
                String nsURI = ePackage.getNsURI();
                result = CustomModelChecker.this.validatorFactories.getOrDefault(nsURI, this.nullFactory).apply(nsURI);
                if (result instanceof SwitchValidator) {
                    ((SwitchValidator)result).setOwner(CustomModelChecker.this);
                }
                this.put(ePackage, result);
            }
            return result;
        }
    }

    private static final class Value {
        final EDataType dataType;
        final Object value;

        Value(EDataType dataType, Object value) {
            this.dataType = dataType;
            this.value = value;
        }
    }
}

