/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.architectureview.providers;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.papyrus.architectureview.Activator;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedADElement;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDomain;
import org.eclipse.swt.graphics.Image;

public class ArchiectureViewLabelProvider
implements ITableLabelProvider {
    private Map<MergedArchitectureDomain, Integer> diagnosticByArchitecture = new WeakHashMap<MergedArchitectureDomain, Integer>();
    private ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void dispose() {
        this.adapterFactory.dispose();
        this.adapterFactory = null;
        this.diagnosticByArchitecture.clear();
        this.diagnosticByArchitecture = null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof MergedArchitectureDomain) {
            MergedArchitectureDomain architectureDomain = (MergedArchitectureDomain)element;
            ADElement adElement = (ADElement)architectureDomain.getAdapter(ADElement.class);
            switch (columnIndex) {
                case 0: {
                    return architectureDomain != null ? architectureDomain.getName() : "Unknown name";
                }
                case 1: {
                    return architectureDomain != null ? architectureDomain.getId() : "Unknown identifier";
                }
                case 2: {
                    return Boolean.toString(architectureDomain.isMerged());
                }
                case 3: {
                    return adElement.eResource().getURI().lastSegment();
                }
                case 4: {
                    URI uri = adElement.eResource().getURI();
                    return uri.isPlatform() ? uri.segment(1) : uri.toString();
                }
                case 5: {
                    if (architectureDomain != null && this.diagnosticByArchitecture.get(architectureDomain) == null) {
                        this.diagnosticByArchitecture.put(architectureDomain, Diagnostician.INSTANCE.validate((EObject)adElement).getSeverity());
                    }
                    return String.valueOf(this.diagnosticByArchitecture.get(architectureDomain) == 0);
                }
            }
        } else if (element instanceof MergedADElement) {
            if (columnIndex == 0) {
                return ((MergedADElement)element).getName();
            }
            return "";
        }
        return "cannot display it: " + String.valueOf(element);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        IItemLabelProvider itemProvider;
        if (!(element instanceof MergedADElement)) {
            return null;
        }
        MergedADElement merged = (MergedADElement)element;
        ADElement adElement = (ADElement)merged.getAdapter(ADElement.class);
        if (columnIndex == 0 && (itemProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)merged, IItemLabelProvider.class)) != null) {
            return ExtendedImageRegistry.getInstance().getImage(itemProvider.getImage((Object)merged));
        }
        if (2 == columnIndex && element instanceof MergedArchitectureDomain) {
            return merged.isMerged() ? Activator.CHECKED_IMAGE : Activator.UNCHECKED_IMAGE;
        }
        if (5 == columnIndex && element instanceof MergedArchitectureDomain) {
            if (this.diagnosticByArchitecture.get(element) == null) {
                this.diagnosticByArchitecture.put((MergedArchitectureDomain)element, Diagnostician.INSTANCE.validate((EObject)adElement).getSeverity());
            }
            return this.diagnosticByArchitecture.get(element) == 0 ? Activator.VALID_IMAGE : Activator.INVALID_IMAGE;
        }
        return null;
    }
}

