/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.AutomaticNotationEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.sequence.command.CreateCoordinateCommand;
import org.eclipse.papyrus.uml.diagram.sequence.command.CreateGrillingStructureCommand;
import org.eclipse.papyrus.uml.diagram.sequence.keyboardlistener.KeyToSetMoveLinesListener;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.ComputeOwnerHelper;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.ContentDiagramListener;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.GridCommandStackListener;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.GrillingEditpart;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.IGrillingEditpolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.NoGrillElementFound;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.UMLPackage;

public class GridManagementEditPolicy
extends GraphicalEditPolicyEx
implements AutomaticNotationEditPolicy,
NotificationListener,
IGrillingEditpolicy {
    public static final String GRID_CONNECTION = "Grid Connection";
    protected GrillingEditpart gridCompartment = null;
    public static String GRID_MANAGEMENT = "GRID_MANAGEMENT";
    public static String COLUMN = "COLUMN_";
    public static String ROW = "ROW_";
    public int threshold = 5;
    public int margin = 50;
    public boolean respectMargin = true;
    public boolean moveAllLinesAtSamePosition = false;
    public ArrayList<DecorationNode> rows = new ArrayList();
    public ArrayList<DecorationNode> columns = new ArrayList();
    public boolean CREATION_X_FREE = true;
    public int X_SPACING = 100;
    private ContentDiagramListener contentDiagramListener;
    private CommandStackListener commandStackListener;
    public boolean strictRespectMargin = true;
    public Comparator<DecorationNode> RowComparator = new Comparator<DecorationNode>(){

        @Override
        public int compare(DecorationNode o1, DecorationNode o2) {
            LayoutConstraint layoutConstrainto1 = o1.getLayoutConstraint();
            LayoutConstraint layoutConstrainto2 = o2.getLayoutConstraint();
            if (layoutConstrainto1 != null && layoutConstrainto2 != null) {
                return Integer.valueOf(((Location)layoutConstrainto1).getY()).compareTo(((Location)layoutConstrainto2).getY());
            }
            return 0;
        }
    };
    public Comparator<DecorationNode> ColumnComparator = new Comparator<DecorationNode>(){

        @Override
        public int compare(DecorationNode o1, DecorationNode o2) {
            LayoutConstraint layoutConstrainto1 = o1.getLayoutConstraint();
            LayoutConstraint layoutConstrainto2 = o2.getLayoutConstraint();
            if (layoutConstrainto1 != null && layoutConstrainto2 != null) {
                return Integer.valueOf(((Location)layoutConstrainto1).getX()).compareTo(((Location)layoutConstrainto2).getX());
            }
            return 0;
        }
    };

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public boolean isMoveAllLinesAtSamePosition() {
        return this.moveAllLinesAtSamePosition;
    }

    public void setMoveAllLinesAtSamePosition(boolean moveAllLinesAtSamePosition) {
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, ">> set moveAllLinesAtSamePosition=" + moveAllLinesAtSamePosition);
        this.moveAllLinesAtSamePosition = moveAllLinesAtSamePosition;
    }

    public boolean isRespectMargin() {
        return this.respectMargin;
    }

    public void setRespectMargin(boolean respectMargin) {
        this.respectMargin = respectMargin;
    }

    public void activate() {
        super.activate();
        this.getDiagramEventBroker().addNotificationListener((EObject)this.getHost().getModel(), (NotificationListener)this);
        this.contentDiagramListener = new ContentDiagramListener(this);
        this.commandStackListener = new GridCommandStackListener(this);
        ((EObject)this.getHost().getModel()).eResource().eAdapters().add((Object)this.contentDiagramListener);
        this.getDiagramEditPart(this.getHost()).getEditingDomain().getCommandStack().addCommandStackListener(this.commandStackListener);
        PlatformUI.getWorkbench().getDisplay().addFilter(1, (Listener)new KeyToSetMoveLinesListener(this, 131072, false));
        PlatformUI.getWorkbench().getDisplay().addFilter(2, (Listener)new KeyToSetMoveLinesListener(this, 131072, true));
        this.refreshGrillingStructure();
    }

    private void refreshGrillingStructure() {
        EditPart host = this.getHost();
        int i = 0;
        while (this.gridCompartment == null && i < host.getChildren().size()) {
            if (host.getChildren().get(i) instanceof GrillingEditpart) {
                this.gridCompartment = (GrillingEditpart)((Object)host.getChildren().get(i));
            }
            ++i;
        }
        if (this.gridCompartment == null) {
            CreateGrillingStructureCommand createGrillingStructureCommand = new CreateGrillingStructureCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), (View)this.getHost().getModel());
            this.execute((Command)createGrillingStructureCommand);
        }
        while (this.gridCompartment == null && i < host.getChildren().size()) {
            if (host.getChildren().get(i) instanceof GrillingEditpart) {
                this.gridCompartment = (GrillingEditpart)((Object)host.getChildren().get(i));
            }
            ++i;
        }
        this.updateRowsAndColumns();
        this.updateCoveredAndOwnerAfterUpdate();
    }

    public void updateRowsAndColumns() {
        this.rows.clear();
        this.columns.clear();
        if (this.gridCompartment != null) {
            int j = 0;
            while (j < this.gridCompartment.getNotationView().getChildren().size()) {
                if (this.gridCompartment.getNotationView().getChildren().get(j) instanceof DecorationNode) {
                    DecorationNode decorationNode = (DecorationNode)this.gridCompartment.getNotationView().getChildren().get(j);
                    if (decorationNode.getType().startsWith(ROW)) {
                        this.rows.add(decorationNode);
                    }
                    if (decorationNode.getType().startsWith(COLUMN)) {
                        this.columns.add(decorationNode);
                    }
                }
                ++j;
            }
        }
        Collections.sort(this.rows, this.RowComparator);
        Collections.sort(this.columns, this.ColumnComparator);
    }

    public void updateCoveredAndOwnerAfterUpdate() {
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "____UPDATE COVERED_____");
        this.updateCoveredBy();
        ComputeOwnerHelper computeOwner = new ComputeOwnerHelper();
        computeOwner.updateOwnedByInteractionOperand((EditingDomain)((IGraphicalEditPart)this.getHost()).getEditingDomain(), this.rows, this.columns, (Interaction)((IGraphicalEditPart)this.getHost()).resolveSemanticElement(), this);
    }

    protected void updateCoveredBy() {
        HashSet<Lifeline> lifelineList = new HashSet<Lifeline>();
        for (DecorationNode column : this.columns) {
            if (!(column.getElement() instanceof Lifeline)) continue;
            lifelineList.add((Lifeline)column.getElement());
        }
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "--> there is " + lifelineList.size() + " lifelines");
        for (Lifeline lifeline : lifelineList) {
            ArrayList<Object> covered = new ArrayList<Object>();
            for (DecorationNode row : this.rows) {
                if (!(row.getElement() instanceof InteractionFragment) || row.getElement() instanceof InteractionOperand) continue;
                InteractionFragment interactionFragment = (InteractionFragment)row.getElement();
                if (!lifeline.getCoveredBys().contains((Object)interactionFragment) || covered.contains(interactionFragment)) continue;
                covered.add(interactionFragment);
                if (!(interactionFragment instanceof ExecutionOccurrenceSpecification) || covered.contains(((ExecutionOccurrenceSpecification)interactionFragment).getExecution())) continue;
                covered.add(((ExecutionOccurrenceSpecification)interactionFragment).getExecution());
            }
            if (covered.size() == lifeline.getCoveredBys().size()) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "the list is equals" + covered.size() + ", we reorder");
                this.execute((Command)new SetCommand((EditingDomain)((IGraphicalEditPart)this.getHost()).getEditingDomain(), (EObject)lifeline, (EStructuralFeature)UMLPackage.eINSTANCE.getLifeline_CoveredBy(), covered));
            } else if (covered.size() < lifeline.getCoveredBys().size()) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "More event detected! +" + (covered.size() - lifeline.getCoveredBys().size()) + "--> modify covered");
                covered.addAll((Collection<Object>)lifeline.getCoveredBys());
                this.execute((Command)new SetCommand((EditingDomain)((IGraphicalEditPart)this.getHost()).getEditingDomain(), (EObject)lifeline, (EStructuralFeature)UMLPackage.eINSTANCE.getLifeline_CoveredBy(), covered));
            } else if (covered.size() > lifeline.getCoveredBys().size()) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "problem! normaly event must be added by element types -" + (covered.size() - lifeline.getCoveredBys().size()));
            }
            ArrayList<InteractionOperand> coveredbyInteractionOperand = new ArrayList<InteractionOperand>();
            covered = new ArrayList();
            for (DecorationNode column : this.columns) {
                if (column.getElement() instanceof InteractionOperand) {
                    if (!coveredbyInteractionOperand.contains(column.getElement())) {
                        coveredbyInteractionOperand.add((InteractionOperand)column.getElement());
                    } else {
                        coveredbyInteractionOperand.remove((InteractionOperand)column.getElement());
                    }
                }
                if (!column.getElement().equals(lifeline)) continue;
                covered.addAll(coveredbyInteractionOperand);
            }
            if (covered.size() <= 0) continue;
            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "Add Interraction operand");
            covered.addAll((Collection<Object>)lifeline.getCoveredBys());
            this.execute((Command)new SetCommand((EditingDomain)((IGraphicalEditPart)this.getHost()).getEditingDomain(), (EObject)lifeline, (EStructuralFeature)UMLPackage.eINSTANCE.getLifeline_CoveredBy(), covered));
        }
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public void deactivate() {
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.getHost().getModel(), (NotificationListener)this);
        super.deactivate();
    }

    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 1 && notification.getNotifier() instanceof Location) {
            this.updateRowsAndColumns();
            if (((EObject)notification.getNotifier()).eContainer() instanceof DecorationNode && this.rows.contains(((EObject)notification.getNotifier()).eContainer()) && notification.getFeature().equals(NotationPackage.eINSTANCE.getLocation_Y())) {
                DecorationNode movedRow = (DecorationNode)((EObject)notification.getNotifier()).eContainer();
                if (movedRow.getElement() instanceof InteractionOperand) {
                    return;
                }
                if (this.moveAllLinesAtSamePosition) {
                    ArrayList<DecorationNode> rowlist = this.getRowAtPosition(notification.getOldIntValue());
                    ((EObject)this.getHost().getModel()).eResource().eAdapters().remove((Object)this.contentDiagramListener);
                    if (!(movedRow.getElement() instanceof Lifeline) && this.rows.size() > rowlist.size()) {
                        this.updateYpositionForRow((DecorationNode)((EObject)notification.getNotifier()).eContainer(), notification.getOldIntValue());
                    }
                    for (DecorationNode axis : rowlist) {
                        if (axis.getElement() instanceof Lifeline || axis.getElement() instanceof InteractionOperand) continue;
                        this.execute((ICommand)new SetBoundsCommand(this.getDiagramEditPart(this.getHost()).getEditingDomain(), "update Line", (IAdaptable)new EObjectAdapter((EObject)axis), new Point(0, notification.getNewIntValue())));
                    }
                }
                ((EObject)this.getHost().getModel()).eResource().eAdapters().add((Object)this.contentDiagramListener);
            }
            this.updateCoveredAndOwnerAfterUpdate();
        }
    }

    public DecorationNode createColumnTolisten(int x, Element semantic) throws NoGrillElementFound {
        this.execute((Command)new CreateCoordinateCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), (BasicCompartment)this.gridCompartment.getNotationView(), String.valueOf(COLUMN) + this.columns.size(), semantic, x));
        this.refreshGrillingStructure();
        return this.getLastCreatedAxis();
    }

    public DecorationNode createRowTolisten(int y, Element semantic) throws NoGrillElementFound {
        this.execute((Command)new CreateCoordinateCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), (BasicCompartment)this.gridCompartment.getNotationView(), String.valueOf(ROW) + this.rows.size(), semantic, y));
        DecorationNode row = this.getLastCreatedAxis();
        this.refreshGrillingStructure();
        return row;
    }

    public DecorationNode getLastCreatedAxis() throws NoGrillElementFound {
        BasicCompartment grid = (BasicCompartment)this.gridCompartment.getNotationView();
        if (grid.getChildren().size() == 0) {
            throw new NoGrillElementFound();
        }
        return (DecorationNode)grid.getChildren().get(grid.getChildren().size() - 1);
    }

    public ArrayList<DecorationNode> getRowAtPosition(int y) {
        ArrayList<DecorationNode> sameLines = new ArrayList<DecorationNode>();
        for (DecorationNode currentRow : this.rows) {
            int Yposition = this.getPositionY(currentRow);
            if (Yposition - this.threshold > y || y > Yposition + this.threshold) continue;
            sameLines.add(currentRow);
        }
        return sameLines;
    }

    public int getPositionY(DecorationNode decorationNode) {
        LayoutConstraint constraint = decorationNode.getLayoutConstraint();
        if (constraint instanceof Location) {
            return ((Location)constraint).getY();
        }
        return 0;
    }

    protected void updateYpositionForRow(DecorationNode movedRow, int oldPosition) {
        int margin;
        LayoutConstraint newconstraint = movedRow.getLayoutConstraint();
        DecorationNode nextRow = this.getDistanceWithNextRowBeforeMoving(movedRow, oldPosition);
        if (nextRow == null) {
            return;
        }
        LayoutConstraint nextConstraint = nextRow.getLayoutConstraint();
        int nextDistance = ((Location)nextConstraint).getY() - ((Location)newconstraint).getY();
        if (nextDistance < (margin = this.getGridSpacing())) {
            ArrayList<DecorationNode> rowsCopy = new ArrayList<DecorationNode>();
            rowsCopy.addAll(this.rows);
            int i = rowsCopy.indexOf(nextRow);
            while (i < rowsCopy.size()) {
                LayoutConstraint aConstraint;
                if (!((DecorationNode)rowsCopy.get(i)).equals(movedRow) && (aConstraint = ((DecorationNode)rowsCopy.get(i)).getLayoutConstraint()) instanceof Location && !(((DecorationNode)rowsCopy.get(i)).getElement() instanceof InteractionOperand)) {
                    this.execute((Command)new SetCommand((EditingDomain)((IGraphicalEditPart)this.getHost()).getEditingDomain(), (EObject)aConstraint, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)(((Location)aConstraint).getY() + margin)));
                }
                ++i;
            }
        }
    }

    protected DecorationNode getDistanceWithNextRowBeforeMoving(DecorationNode currentRow, int oldPosition) {
        Object[] arrayRow = this.rows.toArray();
        List<Object> orderedRows = Arrays.asList(arrayRow);
        DecorationNode nextRow = null;
        for (DecorationNode aRow : this.rows) {
            int Yposition = this.getPositionY(aRow);
            if (oldPosition >= Yposition || aRow.equals(currentRow)) continue;
            nextRow = aRow;
            return nextRow;
        }
        return nextRow;
    }

    protected int getGridSpacing() {
        RootEditPart drep;
        if (DiagramEditPartsUtil.isSnapToGridActive((EditPart)this.getHost()) && (drep = this.getHost().getRoot()) instanceof DiagramRootEditPart) {
            return (int)((DiagramRootEditPart)drep).getGridSpacing();
        }
        return this.margin;
    }

    public static Point getLocation(DecorationNode current) throws NoGrillElementFound {
        LayoutConstraint currentConstraint = current.getLayoutConstraint();
        if (currentConstraint instanceof Location) {
            return new Point(((Location)currentConstraint).getX(), ((Location)currentConstraint).getY());
        }
        throw new NoGrillElementFound();
    }

    public static List<EObject> getRef(DecorationNode current) {
        EAnnotation eAnnotation = current.getEAnnotation(GRID_CONNECTION);
        if (eAnnotation == null) {
            return null;
        }
        if (eAnnotation.getReferences().size() != 0) {
            return eAnnotation.getReferences();
        }
        return null;
    }
}

