/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.AbstractFilteredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.HierarchicToFlatContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IFlattenableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class FlattenableRestrictedFilteredContentProvider
extends AbstractFilteredContentProvider
implements IStaticContentProvider,
IRestrictedContentProvider,
IFlattenableContentProvider {
    private boolean isFlat = false;
    private ReferenceSelector selector;
    protected IRestrictedContentProvider provider;
    protected HierarchicToFlatContentProvider flatProvider;
    private ToolItem flatButton;
    protected static final String DIALOG_SETTINGS_KEY = FlattenableRestrictedFilteredContentProvider.class.getName();
    protected static final String FLAT_SETTINGS_KEY = "flat";
    protected static final String ICONS_FLAT_VIEW = "/icons/flatView.gif";
    protected static final String ICONS_TREE_VIEW = "/icons/treeView.gif";

    public FlattenableRestrictedFilteredContentProvider(IRestrictedContentProvider provider, ReferenceSelector selector) {
        this.provider = provider;
        this.flatProvider = new HierarchicToFlatContentProvider(provider);
        this.selector = selector;
    }

    @Override
    public void createAfter(Composite parent) {
        super.createAfter(parent);
        Composite checkboxSection = new Composite(parent, 0);
        checkboxSection.setLayout((Layout)new FillLayout(512));
        final Button onlyCurrentContainersCheckbox = new Button(checkboxSection, 32);
        onlyCurrentContainersCheckbox.setText(Messages.FlattenableRestrictedFilteredContentProvider_AllPossibleContentsMessage);
        onlyCurrentContainersCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FlattenableRestrictedFilteredContentProvider.this.setRestriction(!onlyCurrentContainersCheckbox.getSelection());
                FlattenableRestrictedFilteredContentProvider.this.viewer.refresh();
                FlattenableRestrictedFilteredContentProvider.this.selector.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Override
    public void createViewerToolbar(Composite parent) {
        this.createFlatSwitchButton(parent);
        if (this.provider instanceof IGraphicalContentProvider) {
            ((IGraphicalContentProvider)((Object)this.provider)).createViewerToolbar(parent);
        }
    }

    protected void createFlatSwitchButton(Composite parent) {
        ToolBar Toolbar = new ToolBar(parent, 0);
        this.flatButton = new ToolItem(Toolbar, 32);
        this.refreshFlatButton();
        this.flatButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlattenableRestrictedFilteredContentProvider.this.setFlat(!FlattenableRestrictedFilteredContentProvider.this.isFlat);
                FlattenableRestrictedFilteredContentProvider.this.getDialogSettings().put(FlattenableRestrictedFilteredContentProvider.FLAT_SETTINGS_KEY, FlattenableRestrictedFilteredContentProvider.this.isFlat);
                FlattenableRestrictedFilteredContentProvider.this.refreshFlatButton();
                FlattenableRestrictedFilteredContentProvider.this.viewer.refresh();
                FlattenableRestrictedFilteredContentProvider.this.selector.refresh();
            }
        });
    }

    protected void refreshFlatButton() {
        this.flatButton.setImage(Activator.getDefault().getImage(this.isFlat ? ICONS_TREE_VIEW : ICONS_FLAT_VIEW));
        this.flatButton.setToolTipText(this.isFlat ? Messages.FlattenableFilteredContentProvider_flatButtonAsFlatTooltip : Messages.FlattenableFilteredContentProvider_flatButtonAsTreeTooltip);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        return settings;
    }

    public Object[] getElements(Object inputElement) {
        if (this.isFlat) {
            return this.flatProvider.getElements(inputElement);
        }
        return this.provider.getElements(inputElement);
    }

    @Override
    public void dispose() {
        this.flatProvider.dispose();
        this.provider.dispose();
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.flatProvider.inputChanged(viewer, oldInput, newInput);
        this.provider.inputChanged(viewer, oldInput, newInput);
    }

    @Override
    public boolean isValidValue(Object element) {
        return this.provider.isValidValue(element);
    }

    public Object[] getChildren(Object parentElement) {
        if (this.isFlat) {
            return new Object[0];
        }
        return this.provider.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        if (this.isFlat) {
            return null;
        }
        return this.provider.getParent(element);
    }

    public boolean hasChildren(Object element) {
        if (this.isFlat) {
            return false;
        }
        return this.provider.hasChildren(element);
    }

    @Override
    public void setRestriction(boolean isRestricted) {
        this.provider.setRestriction(isRestricted);
    }

    @Override
    public void setFlat(boolean flat) {
        this.isFlat = flat;
    }

    @Override
    public Object[] getElements() {
        return null;
    }

    @Override
    public void setIgnoreInheritedElements(boolean ignoreInheritedElements) {
        this.provider.setIgnoreInheritedElements(ignoreInheritedElements);
    }

    @Override
    public boolean isIgnoringInheritedElements() {
        return this.provider.isIgnoringInheritedElements();
    }

    @Override
    public boolean isRestricted() {
        return this.provider.isRestricted();
    }

    @Override
    public boolean isFlat() {
        return this.isFlat;
    }
}

