/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.MoveElementsCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.sequence.expressions.UMLOCLFactory;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLBaseItemSemanticEditPolicy
extends SemanticEditPolicy {
    public static final String VISUAL_ID_KEY = "visual_id";
    public static final String GRAPHICAL_RECONNECTED_EDGE = "graphical_edge";
    private final IElementType myElementType;

    protected UMLBaseItemSemanticEditPolicy(IElementType elementType) {
        this.myElementType = elementType;
    }

    public Command getCommand(Request request) {
        Object view;
        if (request instanceof ReconnectRequest && (view = ((ReconnectRequest)request).getConnectionEditPart().getModel()) instanceof View) {
            String id = UMLVisualIDRegistry.getVisualID((View)view);
            request.getExtendedData().put(VISUAL_ID_KEY, id);
            request.getExtendedData().put(GRAPHICAL_RECONNECTED_EDGE, view);
        }
        return super.getCommand(request);
    }

    protected String getVisualID(IEditCommandRequest request) {
        return (String)request.getParameter(VISUAL_ID_KEY);
    }

    protected Command getSemanticCommand(IEditCommandRequest request) {
        IEditCommandRequest completedRequest = this.completeRequest(request);
        Command semanticCommand = this.getSemanticCommandSwitch(completedRequest);
        semanticCommand = this.getEditHelperCommand(completedRequest, semanticCommand);
        if (completedRequest instanceof DestroyRequest) {
            DestroyRequest destroyRequest = (DestroyRequest)completedRequest;
            return this.shouldProceed(destroyRequest) ? this.addDeleteViewCommand(semanticCommand, destroyRequest) : null;
        }
        return semanticCommand;
    }

    protected Command addDeleteViewCommand(Command mainCommand, DestroyRequest completedRequest) {
        Command deleteViewCommand = this.getGEFWrapper((ICommand)new DeleteCommand(this.getEditingDomain(), (View)this.getHost().getModel()));
        return mainCommand == null ? deleteViewCommand : mainCommand.chain(deleteViewCommand);
    }

    private Command getEditHelperCommand(IEditCommandRequest request, Command editPolicyCommand) {
        if (editPolicyCommand != null) {
            CommandProxy command = editPolicyCommand instanceof ICommandProxy ? ((ICommandProxy)editPolicyCommand).getICommand() : new CommandProxy(editPolicyCommand);
            request.setParameter("edit policy command", (Object)command);
        }
        IElementType requestContextElementType = this.getContextElementType(request);
        request.setParameter("context element type", (Object)requestContextElementType);
        ICommand command = requestContextElementType.getEditCommand(request);
        request.setParameter("edit policy command", null);
        request.setParameter("context element type", null);
        if (command != null) {
            if (!(command instanceof CompositeTransactionalCommand)) {
                command = new CompositeTransactionalCommand(this.getEditingDomain(), command.getLabel()).compose((IUndoableOperation)command);
            }
            return new ICommandProxy(command);
        }
        return editPolicyCommand;
    }

    protected IElementType getContextElementType(IEditCommandRequest request) {
        IElementType requestContextElementType = UMLElementTypes.getElementType(this.getVisualID(request));
        return requestContextElementType != null ? requestContextElementType : this.myElementType;
    }

    protected Command getSemanticCommandSwitch(IEditCommandRequest req) {
        if (req instanceof CreateRelationshipRequest) {
            return this.getCreateRelationshipCommand((CreateRelationshipRequest)req);
        }
        if (req instanceof CreateElementRequest) {
            return this.getCreateCommand((CreateElementRequest)req);
        }
        if (req instanceof ConfigureRequest) {
            return this.getConfigureCommand((ConfigureRequest)req);
        }
        if (req instanceof DestroyElementRequest) {
            return this.getDestroyElementCommand((DestroyElementRequest)req);
        }
        if (req instanceof DestroyReferenceRequest) {
            return this.getDestroyReferenceCommand((DestroyReferenceRequest)req);
        }
        if (req instanceof DuplicateElementsRequest) {
            return this.getDuplicateCommand((DuplicateElementsRequest)req);
        }
        if (req instanceof GetEditContextRequest) {
            return this.getEditContextCommand((GetEditContextRequest)req);
        }
        if (req instanceof MoveRequest) {
            return this.getMoveCommand((MoveRequest)req);
        }
        if (req instanceof ReorientReferenceRelationshipRequest) {
            return this.getReorientReferenceRelationshipCommand((ReorientReferenceRelationshipRequest)req);
        }
        if (req instanceof ReorientRelationshipRequest) {
            return this.getReorientRelationshipCommand((ReorientRelationshipRequest)req);
        }
        if (req instanceof SetRequest) {
            return this.getSetCommand((SetRequest)req);
        }
        return null;
    }

    protected Command getConfigureCommand(ConfigureRequest req) {
        return null;
    }

    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        return null;
    }

    protected Command getCreateCommand(CreateElementRequest req) {
        ICommand command;
        IElementEditService commandProvider;
        IElementType requestElementType = req.getElementType();
        if (requestElementType instanceof IElementType && (commandProvider = ElementEditServiceUtils.getCommandProvider((EObject)req.getContainer())) != null && (command = commandProvider.getEditCommand((IEditCommandRequest)req)) != null && command.canExecute()) {
            return new ICommandProxy(command);
        }
        return null;
    }

    protected Command getSetCommand(SetRequest req) {
        return null;
    }

    protected Command getEditContextCommand(GetEditContextRequest req) {
        return null;
    }

    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        return null;
    }

    protected Command getDestroyReferenceCommand(DestroyReferenceRequest req) {
        return null;
    }

    protected Command getDuplicateCommand(DuplicateElementsRequest req) {
        return null;
    }

    protected Command getMoveCommand(MoveRequest req) {
        EObject targetCEObject = req.getTargetContainer();
        if (targetCEObject != null) {
            ICommand moveCommand;
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)targetCEObject);
            if (provider != null && (moveCommand = provider.getEditCommand((IEditCommandRequest)req)) != null) {
                return new ICommandProxy(moveCommand);
            }
            return UnexecutableCommand.INSTANCE;
        }
        return this.getGEFWrapper((ICommand)new MoveElementsCommand(req));
    }

    protected Command getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected final Command getGEFWrapper(ICommand cmd) {
        return cmd == null ? UnexecutableCommand.INSTANCE : new ICommandProxy(cmd);
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected void addDestroyShortcutsCommand(ICompositeCommand cmd, View view) {
        assert (view.getEAnnotation("Shortcut") == null);
        for (View nextView : view.getDiagram().getChildren()) {
            if (nextView.getEAnnotation("Shortcut") == null || !nextView.isSetElement() || nextView.getElement() != view.getElement()) continue;
            cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), nextView));
        }
    }

    public static LinkConstraints getLinkConstraints() {
        LinkConstraints cached = UMLDiagramEditorPlugin.getInstance().getLinkConstraints();
        if (cached == null) {
            cached = new LinkConstraints();
            UMLDiagramEditorPlugin.getInstance().setLinkConstraints(cached);
        }
        return cached;
    }

    public static class LinkConstraints {
        public boolean canCreateMessage_SynchEdge(Interaction container, Element source, Element target) {
            return this.canExistMessage_SynchEdge(container, null, source, target);
        }

        public boolean canCreateMessage_AsynchEdge(Interaction container, Element source, Element target) {
            return this.canExistMessage_AsynchEdge(container, null, source, target);
        }

        public boolean canCreateMessage_ReplyEdge(Interaction container, Element source, Element target) {
            return this.canExistMessage_ReplyEdge(container, null, source, target);
        }

        public boolean canCreateMessage_CreateEdge(Interaction container, Element source, Element target) {
            return this.canExistMessage_CreateEdge(container, null, source, target);
        }

        public boolean canCreateMessage_DeleteEdge(Interaction container, Element source, Element target) {
            return this.canExistMessage_DeleteEdge(container, null, source, target);
        }

        public boolean canCreateMessage_LostEdge(Interaction container, Element source, Element target) {
            return this.canExistMessage_LostEdge(container, null, source, target);
        }

        public boolean canCreateMessage_FoundEdge(Interaction container, Element source, Element target) {
            return this.canExistMessage_FoundEdge(container, null, source, target);
        }

        public boolean canCreateComment_AnnotatedElementEdge(Comment source, Element target) {
            if (source != null && source.getAnnotatedElements().contains((Object)target)) {
                return false;
            }
            return this.canExistComment_AnnotatedElementEdge(source, target);
        }

        public boolean canCreateConstraint_ConstrainedElementEdge(Constraint source, Element target) {
            if (source != null && source.getConstrainedElements().contains((Object)target)) {
                return false;
            }
            return this.canExistConstraint_ConstrainedElementEdge(source, target);
        }

        public boolean canCreateGeneralOrdering_Edge(InteractionFragment container, OccurrenceSpecification source, OccurrenceSpecification target) {
            return this.canExistGeneralOrdering_Edge(container, null, source, target);
        }

        public boolean canCreateConstraint_ContextEdge(Constraint source, Namespace target) {
            if (source != null && source.getContext() != null) {
                return false;
            }
            if (target != null && target.getOwnedRules().contains((Object)target)) {
                return false;
            }
            return this.canExistConstraint_ContextEdge(source, target);
        }

        public boolean canExistMessage_SynchEdge(Interaction container, Message linkInstance, Element source, Element target) {
            Map<String, EClass> env;
            block7: {
                block6: {
                    block5: {
                        try {
                            if (source != null) break block5;
                            return true;
                        }
                        catch (Exception e) {
                            UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                            return false;
                        }
                    }
                    env = Collections.singletonMap("oppositeEnd", UMLPackage.eINSTANCE.getElement());
                    Object sourceVal = UMLOCLFactory.getExpression(2, (EClassifier)UMLPackage.eINSTANCE.getElement(), env).evaluate(source, Collections.singletonMap("oppositeEnd", target));
                    if (sourceVal instanceof Boolean && ((Boolean)sourceVal).booleanValue()) break block6;
                    return false;
                }
                if (target != null) break block7;
                return true;
            }
            env = Collections.singletonMap("oppositeEnd", UMLPackage.eINSTANCE.getElement());
            Object targetVal = UMLOCLFactory.getExpression(3, (EClassifier)UMLPackage.eINSTANCE.getElement(), env).evaluate(target, Collections.singletonMap("oppositeEnd", source));
            return targetVal instanceof Boolean && (Boolean)targetVal != false;
        }

        public boolean canExistMessage_AsynchEdge(Interaction container, Message linkInstance, Element source, Element target) {
            Map<String, EClass> env;
            block7: {
                block6: {
                    block5: {
                        try {
                            if (source != null) break block5;
                            return true;
                        }
                        catch (Exception e) {
                            UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                            return false;
                        }
                    }
                    env = Collections.singletonMap("oppositeEnd", UMLPackage.eINSTANCE.getElement());
                    Object sourceVal = UMLOCLFactory.getExpression(22, (EClassifier)UMLPackage.eINSTANCE.getElement(), env).evaluate(source, Collections.singletonMap("oppositeEnd", target));
                    if (sourceVal instanceof Boolean && ((Boolean)sourceVal).booleanValue()) break block6;
                    return false;
                }
                if (target != null) break block7;
                return true;
            }
            env = Collections.singletonMap("oppositeEnd", UMLPackage.eINSTANCE.getElement());
            Object targetVal = UMLOCLFactory.getExpression(6, (EClassifier)UMLPackage.eINSTANCE.getElement(), env).evaluate(target, Collections.singletonMap("oppositeEnd", source));
            return targetVal instanceof Boolean && (Boolean)targetVal != false;
        }

        public boolean canExistMessage_ReplyEdge(Interaction container, Message linkInstance, Element source, Element target) {
            Map<String, EClass> env;
            block7: {
                block6: {
                    block5: {
                        try {
                            if (source != null) break block5;
                            return true;
                        }
                        catch (Exception e) {
                            UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                            return false;
                        }
                    }
                    env = Collections.singletonMap("oppositeEnd", UMLPackage.eINSTANCE.getElement());
                    Object sourceVal = UMLOCLFactory.getExpression(8, (EClassifier)UMLPackage.eINSTANCE.getElement(), env).evaluate(source, Collections.singletonMap("oppositeEnd", target));
                    if (sourceVal instanceof Boolean && ((Boolean)sourceVal).booleanValue()) break block6;
                    return false;
                }
                if (target != null) break block7;
                return true;
            }
            env = Collections.singletonMap("oppositeEnd", UMLPackage.eINSTANCE.getElement());
            Object targetVal = UMLOCLFactory.getExpression(22, (EClassifier)UMLPackage.eINSTANCE.getElement(), env).evaluate(target, Collections.singletonMap("oppositeEnd", source));
            return targetVal instanceof Boolean && (Boolean)targetVal != false;
        }

        public boolean canExistMessage_CreateEdge(Interaction container, Message linkInstance, Element source, Element target) {
            Map<String, EClass> env;
            block7: {
                block6: {
                    block5: {
                        try {
                            if (source != null) break block5;
                            return true;
                        }
                        catch (Exception e) {
                            UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                            return false;
                        }
                    }
                    env = Collections.singletonMap("oppositeEnd", UMLPackage.eINSTANCE.getElement());
                    Object sourceVal = UMLOCLFactory.getExpression(11, (EClassifier)UMLPackage.eINSTANCE.getElement(), env).evaluate(source, Collections.singletonMap("oppositeEnd", target));
                    if (sourceVal instanceof Boolean && ((Boolean)sourceVal).booleanValue()) break block6;
                    return false;
                }
                if (target != null) break block7;
                return true;
            }
            env = Collections.singletonMap("oppositeEnd", UMLPackage.eINSTANCE.getElement());
            Object targetVal = UMLOCLFactory.getExpression(12, (EClassifier)UMLPackage.eINSTANCE.getElement(), env).evaluate(target, Collections.singletonMap("oppositeEnd", source));
            return targetVal instanceof Boolean && (Boolean)targetVal != false;
        }

        public boolean canExistMessage_DeleteEdge(Interaction container, Message linkInstance, Element source, Element target) {
            Map<String, EClass> env;
            block7: {
                block6: {
                    block5: {
                        try {
                            if (source != null) break block5;
                            return true;
                        }
                        catch (Exception e) {
                            UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                            return false;
                        }
                    }
                    env = Collections.singletonMap("oppositeEnd", UMLPackage.eINSTANCE.getElement());
                    Object sourceVal = UMLOCLFactory.getExpression(14, (EClassifier)UMLPackage.eINSTANCE.getElement(), env).evaluate(source, Collections.singletonMap("oppositeEnd", target));
                    if (sourceVal instanceof Boolean && ((Boolean)sourceVal).booleanValue()) break block6;
                    return false;
                }
                if (target != null) break block7;
                return true;
            }
            env = Collections.singletonMap("oppositeEnd", UMLPackage.eINSTANCE.getElement());
            Object targetVal = UMLOCLFactory.getExpression(15, (EClassifier)UMLPackage.eINSTANCE.getElement(), env).evaluate(target, Collections.singletonMap("oppositeEnd", source));
            return targetVal instanceof Boolean && (Boolean)targetVal != false;
        }

        public boolean canExistMessage_LostEdge(Interaction container, Message linkInstance, Element source, Element target) {
            Map<String, EClass> env;
            block7: {
                block6: {
                    block5: {
                        try {
                            if (source != null) break block5;
                            return true;
                        }
                        catch (Exception e) {
                            UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                            return false;
                        }
                    }
                    env = Collections.singletonMap("oppositeEnd", UMLPackage.eINSTANCE.getElement());
                    Object sourceVal = UMLOCLFactory.getExpression(22, (EClassifier)UMLPackage.eINSTANCE.getElement(), env).evaluate(source, Collections.singletonMap("oppositeEnd", target));
                    if (sourceVal instanceof Boolean && ((Boolean)sourceVal).booleanValue()) break block6;
                    return false;
                }
                if (target != null) break block7;
                return true;
            }
            env = Collections.singletonMap("oppositeEnd", UMLPackage.eINSTANCE.getElement());
            Object targetVal = UMLOCLFactory.getExpression(18, (EClassifier)UMLPackage.eINSTANCE.getElement(), env).evaluate(target, Collections.singletonMap("oppositeEnd", source));
            return targetVal instanceof Boolean && (Boolean)targetVal != false;
        }

        public boolean canExistMessage_FoundEdge(Interaction container, Message linkInstance, Element source, Element target) {
            Map<String, EClass> env;
            block7: {
                block6: {
                    block5: {
                        try {
                            if (source != null) break block5;
                            return true;
                        }
                        catch (Exception e) {
                            UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                            return false;
                        }
                    }
                    env = Collections.singletonMap("oppositeEnd", UMLPackage.eINSTANCE.getElement());
                    Object sourceVal = UMLOCLFactory.getExpression(20, (EClassifier)UMLPackage.eINSTANCE.getElement(), env).evaluate(source, Collections.singletonMap("oppositeEnd", target));
                    if (sourceVal instanceof Boolean && ((Boolean)sourceVal).booleanValue()) break block6;
                    return false;
                }
                if (target != null) break block7;
                return true;
            }
            env = Collections.singletonMap("oppositeEnd", UMLPackage.eINSTANCE.getElement());
            Object targetVal = UMLOCLFactory.getExpression(22, (EClassifier)UMLPackage.eINSTANCE.getElement(), env).evaluate(target, Collections.singletonMap("oppositeEnd", source));
            return targetVal instanceof Boolean && (Boolean)targetVal != false;
        }

        public boolean canExistComment_AnnotatedElementEdge(Comment source, Element target) {
            return true;
        }

        public boolean canExistConstraint_ConstrainedElementEdge(Constraint source, Element target) {
            return true;
        }

        public boolean canExistGeneralOrdering_Edge(InteractionFragment container, GeneralOrdering linkInstance, OccurrenceSpecification source, OccurrenceSpecification target) {
            return true;
        }

        public boolean canExistConstraint_ContextEdge(Constraint source, Namespace target) {
            return true;
        }
    }
}

