/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.papyrus.uml.diagram.common.editparts.RoundedCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SenderRequestUtils;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SequenceReferenceEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UpdateWeakReferenceEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.util.CoordinateReferentialUtils;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;

public class UpdateWeakReferenceForMessageSpecEditPolicy
extends UpdateWeakReferenceEditPolicy {
    public static final String UDPATE_WEAK_REFERENCE_FOR_MESSAGE = "UpdateWeakReferenceForMessageSpecEditPolicy";

    public Command getCommand(Request request) {
        if (request instanceof ReconnectRequest && !SenderRequestUtils.isASender(request, this.getHost())) {
            Point anchorPositionOnScreen;
            ReconnectRequest reconnectRequest = (ReconnectRequest)request;
            ConnectionEditPart hostConnectionEditPart = reconnectRequest.getConnectionEditPart();
            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+ MOVE ANCHORS of " + hostConnectionEditPart.getClass().getName());
            Point locationOnDiagram = CoordinateReferentialUtils.transformPointFromScreenToDiagramReferential(reconnectRequest.getLocation(), (GraphicalViewer)this.getHost().getViewer());
            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+-- LocationOnDiagram " + locationOnDiagram);
            Point moveDelta = new Point(0, 0);
            PolylineConnectionEx polyline = (PolylineConnectionEx)hostConnectionEditPart.getFigure();
            if ("Reconnection target".equals(reconnectRequest.getType())) {
                anchorPositionOnScreen = polyline.getSourceAnchor().getReferencePoint();
                moveDelta.y = reconnectRequest.getLocation().y - anchorPositionOnScreen.y;
            } else {
                anchorPositionOnScreen = polyline.getSourceAnchor().getReferencePoint();
                moveDelta.y = reconnectRequest.getLocation().y - anchorPositionOnScreen.y;
            }
            if (moveDelta.y > 0 && this.mustMove && hostConnectionEditPart.getEditPolicy((Object)"SEQUENCE_REFERENCE") != null) {
                SequenceReferenceEditPolicy references = (SequenceReferenceEditPolicy)hostConnectionEditPart.getEditPolicy((Object)"SEQUENCE_REFERENCE");
                if (!SenderRequestUtils.isASender(request, this.getHost())) {
                    CompoundCommand compoundCommand = new CompoundCommand();
                    for (EditPart editPart : references.getWeakReferences().keySet()) {
                        if (SenderRequestUtils.isASender(request, editPart)) continue;
                        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+--> try to Move " + editPart);
                        ArrayList<EditPart> senderList = SenderRequestUtils.getSenders(request);
                        if (editPart instanceof ConnectionEditPart) {
                            ConnectionEditPart connectionEditPart = (ConnectionEditPart)editPart;
                            UpdateWeakReferenceForMessageSpecEditPolicy.moveSourceConnectionEditPart((EditPart)hostConnectionEditPart, moveDelta, compoundCommand, connectionEditPart, senderList);
                            UpdateWeakReferenceForMessageSpecEditPolicy.moveTargetConnectionEditPart((EditPart)hostConnectionEditPart, moveDelta, compoundCommand, connectionEditPart, senderList);
                        }
                        if (!(editPart instanceof RoundedCompartmentEditPart)) continue;
                        UpdateWeakReferenceForMessageSpecEditPolicy.moveRoundedEditPart((EditPart)hostConnectionEditPart, moveDelta, compoundCommand, editPart, senderList);
                    }
                    if (compoundCommand.size() == 0) {
                        return super.getCommand(request);
                    }
                    return compoundCommand;
                }
            }
        }
        return super.getCommand(request);
    }
}

