/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.providers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.CreateEditPoliciesOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.IEditPolicyProvider;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.AnnotatedConnectionHandleEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.AnnotatedLinkEndEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.AnnotatedLinkStartEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SequenceConnectionHandleEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.TooltipUtil;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Observation;

public class CustomEditPolicyProvider
implements IEditPolicyProvider {
    public void addProviderChangeListener(IProviderChangeListener listener) {
    }

    public void createEditPolicies(EditPart editPart) {
        Object model;
        EditPolicy editPolicy = editPart.getEditPolicy((Object)"ConnectionHandlesPolicy");
        if (editPolicy != null) {
            editPart.removeEditPolicy((Object)"ConnectionHandlesPolicy");
            editPart.installEditPolicy((Object)"ConnectionHandlesPolicy", (EditPolicy)new SequenceConnectionHandleEditPolicy());
        }
        this.installHighlightPolicy(editPart);
        SequenceUtil.installObservationLinkPolicy(editPart);
        if (editPart instanceof IGraphicalEditPart && (model = editPart.getModel()) instanceof View) {
            View view = (View)model;
            EObject element = ViewUtil.resolveSemanticElement((View)((View)model));
            if (element instanceof Element && editPart instanceof INodeEditPart) {
                this.installEditPolicy(editPart, (EditPolicy)new AnnotatedLinkEndEditPolicy(), "Annotated Link End Edit Policy");
            }
            if (editPart instanceof INodeEditPart && (element instanceof Constraint || element instanceof Observation || element instanceof Comment)) {
                this.installEditPolicy(editPart, (EditPolicy)new AnnotatedLinkStartEditPolicy(), "Annotated Link Start Edit Policy");
                editPart.removeEditPolicy((Object)"ConnectionHandlesPolicy");
                editPart.installEditPolicy((Object)"ConnectionHandlesPolicy", (EditPolicy)new AnnotatedConnectionHandleEditPolicy());
            }
            if (view.isSetElement()) {
                boolean cfr_ignored_0 = view.getElement() instanceof InteractionFragment;
            }
        }
        TooltipUtil.manageTooltipEditPolicy(editPart);
    }

    private void installEditPolicy(EditPart editPart, EditPolicy editPolicy, String role) {
        if (editPart == null || editPolicy == null) {
            return;
        }
        EditPolicy myEditPolicy = editPart.getEditPolicy((Object)role);
        if (myEditPolicy == null) {
            editPart.installEditPolicy((Object)role, editPolicy);
        }
    }

    private void installHighlightPolicy(EditPart editPart) {
    }

    public boolean provides(IOperation operation) {
        CreateEditPoliciesOperation epOperation = (CreateEditPoliciesOperation)operation;
        if (!(epOperation.getEditPart() instanceof GraphicalEditPart) && !(epOperation.getEditPart() instanceof ConnectionEditPart)) {
            return false;
        }
        EditPart gep = epOperation.getEditPart();
        String diagramType = ((View)gep.getModel()).getDiagram().getType();
        return "PapyrusUMLSequenceDiagram".equals(diagramType);
    }

    public void removeProviderChangeListener(IProviderChangeListener listener) {
    }
}

