/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.impl.ConnectorImpl;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomDurationConstraintEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ObservationLinkEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.TimeObservationLabelEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.OLDLifelineXYLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SenderRequestUtils;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineEditPartUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.IntervalConstraint;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeObservation;

public class OccurrenceSpecificationMoveHelper {
    public static Command getMoveOccurrenceSpecificationsCommand(OccurrenceSpecification movedOccurrenceSpecification1, OccurrenceSpecification movedOccurrenceSpecification2, int yLocation1, int yLocation2, LifelineEditPart lifelinePart, List<EditPart> notToMoveEditParts, Request request) {
        CompoundCommand globalCmd = new CompoundCommand();
        Command command = OccurrenceSpecificationMoveHelper.getMoveExecutionSpecificationCommand(movedOccurrenceSpecification1, movedOccurrenceSpecification2, yLocation1, yLocation2, lifelinePart, notToMoveEditParts);
        if (command != null) {
            globalCmd.add(command);
        }
        if (movedOccurrenceSpecification1 instanceof MessageOccurrenceSpecification && (command = OccurrenceSpecificationMoveHelper.getReconnectMessageCommand(movedOccurrenceSpecification1, yLocation1, lifelinePart, notToMoveEditParts, request)) != null) {
            globalCmd.add(command);
        }
        if (movedOccurrenceSpecification2 instanceof MessageOccurrenceSpecification && (command = OccurrenceSpecificationMoveHelper.getReconnectMessageCommand(movedOccurrenceSpecification2, yLocation2, lifelinePart, notToMoveEditParts, request)) != null) {
            globalCmd.add(command);
        }
        if ((command = OccurrenceSpecificationMoveHelper.getMoveTimeElementsCommand(movedOccurrenceSpecification1, movedOccurrenceSpecification2, yLocation1, yLocation2, lifelinePart, notToMoveEditParts)) != null) {
            globalCmd.add(command);
        }
        if ((command = OccurrenceSpecificationMoveHelper.getReconnectGeneralOrderingCommand(movedOccurrenceSpecification1, yLocation1, lifelinePart, notToMoveEditParts)) != null) {
            globalCmd.add(command);
        }
        if (movedOccurrenceSpecification2 != null && (command = OccurrenceSpecificationMoveHelper.getReconnectGeneralOrderingCommand(movedOccurrenceSpecification2, yLocation2, lifelinePart, notToMoveEditParts)) != null) {
            globalCmd.add(command);
        }
        if (globalCmd.isEmpty()) {
            return null;
        }
        return globalCmd;
    }

    private static Command getReconnectGeneralOrderingCommand(OccurrenceSpecification movedOccurrenceSpecification, int yLocation, LifelineEditPart lifelinePart, List<EditPart> notToMoveEditParts) {
        ReconnectRequest reconnectRequest;
        Command reconnect;
        View view;
        EditPart part;
        Collection settings;
        CompoundCommand command = new CompoundCommand();
        Point referencePoint = OccurrenceSpecificationMoveHelper.getReferencePoint(lifelinePart, movedOccurrenceSpecification, yLocation);
        GraphicalEditPart childToReconnectTo = SequenceUtil.findPartToReconnectTo(lifelinePart, referencePoint);
        if (!notToMoveEditParts.isEmpty() && childToReconnectTo != lifelinePart) {
            Point oldLoc = SequenceUtil.findLocationOfEvent(lifelinePart, (InteractionFragment)movedOccurrenceSpecification);
            if (oldLoc == null) {
                return null;
            }
            referencePoint.y = oldLoc.y;
        }
        for (GeneralOrdering go : movedOccurrenceSpecification.getToAfters()) {
            settings = CacheAdapter.getInstance().getNonNavigableInverseReferences((EObject)go);
            for (EStructuralFeature.Setting ref : settings) {
                if (!NotationPackage.eINSTANCE.getView_Element().equals(ref.getEStructuralFeature()) || !((part = DiagramEditPartsUtil.getEditPartFromView((View)(view = (View)ref.getEObject()), (EditPart)lifelinePart)) instanceof ConnectionEditPart) || notToMoveEditParts.contains(part) || !(reconnect = childToReconnectTo.getCommand((Request)(reconnectRequest = OccurrenceSpecificationMoveHelper.makeReconnectRequest((ConnectionEditPart)part, true, referencePoint, (EditPart)childToReconnectTo)))).canExecute()) continue;
                command.add(reconnect);
            }
        }
        for (GeneralOrdering go : movedOccurrenceSpecification.getToBefores()) {
            settings = CacheAdapter.getInstance().getNonNavigableInverseReferences((EObject)go);
            for (EStructuralFeature.Setting ref : settings) {
                if (!NotationPackage.eINSTANCE.getView_Element().equals(ref.getEStructuralFeature()) || !((part = DiagramEditPartsUtil.getEditPartFromView((View)(view = (View)ref.getEObject()), (EditPart)lifelinePart)) instanceof ConnectionEditPart) || notToMoveEditParts.contains(part) || !(reconnect = childToReconnectTo.getCommand((Request)(reconnectRequest = OccurrenceSpecificationMoveHelper.makeReconnectRequest((ConnectionEditPart)part, false, referencePoint, (EditPart)childToReconnectTo)))).canExecute()) continue;
                command.add(reconnect);
            }
        }
        if (command.isEmpty()) {
            return null;
        }
        return command;
    }

    private static Command getReconnectMessageCommand(OccurrenceSpecification movedOccurrenceSpecification, int yLocation, LifelineEditPart lifelinePart, List<EditPart> notToMoveEditParts, Request request) {
        CompoundCommand command = new CompoundCommand();
        if (movedOccurrenceSpecification instanceof MessageOccurrenceSpecification) {
            Command updateIFrag;
            Command reconnect;
            ArrayList<EditPart> senderList;
            ReconnectRequest reconnectRequest;
            View view;
            EditPart part;
            Collection settings;
            Point referencePoint = OccurrenceSpecificationMoveHelper.getReferencePoint(lifelinePart, movedOccurrenceSpecification, yLocation);
            GraphicalEditPart childToReconnectTo = SequenceUtil.findPartToReconnectTo(lifelinePart, referencePoint);
            Message message = ((MessageOccurrenceSpecification)movedOccurrenceSpecification).getMessage();
            if (message != null && movedOccurrenceSpecification.equals(message.getSendEvent())) {
                settings = CacheAdapter.getInstance().getNonNavigableInverseReferences((EObject)message);
                for (EStructuralFeature.Setting ref : settings) {
                    if (!NotationPackage.eINSTANCE.getView_Element().equals(ref.getEStructuralFeature()) || !((part = DiagramEditPartsUtil.getEditPartFromView((View)(view = (View)ref.getEObject()), (EditPart)lifelinePart)) instanceof ConnectionEditPart) || notToMoveEditParts.contains(part)) continue;
                    reconnectRequest = OccurrenceSpecificationMoveHelper.makeReconnectRequest((ConnectionEditPart)part, true, referencePoint, (EditPart)childToReconnectTo);
                    senderList = SenderRequestUtils.getSenders(request);
                    SenderRequestUtils.addRequestSenders((Request)reconnectRequest, senderList);
                    reconnect = childToReconnectTo.getCommand((Request)reconnectRequest);
                    command.add(reconnect);
                    updateIFrag = SequenceUtil.createUpdateEnclosingInteractionCommand((MessageOccurrenceSpecification)movedOccurrenceSpecification, referencePoint, (GraphicalEditPart)lifelinePart);
                    if (updateIFrag == null || !updateIFrag.canExecute()) continue;
                    command.add(updateIFrag);
                }
            }
            if (message != null && movedOccurrenceSpecification.equals(message.getReceiveEvent())) {
                settings = CacheAdapter.getInstance().getNonNavigableInverseReferences((EObject)message);
                for (EStructuralFeature.Setting ref : settings) {
                    if (!NotationPackage.eINSTANCE.getView_Element().equals(ref.getEStructuralFeature()) || !((part = DiagramEditPartsUtil.getEditPartFromView((View)(view = (View)ref.getEObject()), (EditPart)lifelinePart)) instanceof ConnectionEditPart) || notToMoveEditParts.contains(part)) continue;
                    reconnectRequest = OccurrenceSpecificationMoveHelper.makeReconnectRequest((ConnectionEditPart)part, false, referencePoint, (EditPart)childToReconnectTo);
                    senderList = SenderRequestUtils.getSenders(request);
                    SenderRequestUtils.addRequestSenders((Request)reconnectRequest, senderList);
                    reconnect = childToReconnectTo.getCommand((Request)reconnectRequest);
                    command.add(reconnect);
                    updateIFrag = SequenceUtil.createUpdateEnclosingInteractionCommand((MessageOccurrenceSpecification)movedOccurrenceSpecification, referencePoint, (GraphicalEditPart)lifelinePart);
                    if (updateIFrag == null || !updateIFrag.canExecute()) continue;
                    command.add(updateIFrag);
                }
            }
        }
        if (command.isEmpty()) {
            return null;
        }
        return command;
    }

    private static Command getMoveTimeElementsCommand(OccurrenceSpecification movedOccurrenceSpecification1, OccurrenceSpecification movedOccurrenceSpecification2, int yLocation1, int yLocation2, LifelineEditPart lifelinePart, List<EditPart> notToMoveEditParts) {
        CompoundCommand globalCmd = new CompoundCommand();
        IFigure lifelineFigure = lifelinePart.getFigure();
        for (Object lifelineChild : lifelinePart.getChildren()) {
            IBorderItemEditPart timePart;
            Command cmd;
            if (!(lifelineChild instanceof IBorderItemEditPart) || notToMoveEditParts.contains(lifelineChild) || (cmd = OccurrenceSpecificationMoveHelper.getMoveSingleTimeRelatedElementCommand(timePart = (IBorderItemEditPart)lifelineChild, movedOccurrenceSpecification1, movedOccurrenceSpecification2, yLocation1, yLocation2, lifelinePart)) == null) continue;
            globalCmd.add(cmd);
        }
        for (Object targetConnection : lifelinePart.getTargetConnections()) {
            Command cmd;
            if (!(targetConnection instanceof ObservationLinkEditPart) || (cmd = OccurrenceSpecificationMoveHelper.getMoveSingleTimeRelatedElementCommand((ObservationLinkEditPart)((Object)targetConnection), movedOccurrenceSpecification1, movedOccurrenceSpecification2, yLocation1, yLocation2, lifelinePart)) == null) continue;
            globalCmd.add(cmd);
        }
        if (!globalCmd.isEmpty() && lifelineFigure instanceof BorderedNodeFigure) {
            Command relayout = OccurrenceSpecificationMoveHelper.getReLayoutCmd((BorderedNodeFigure)lifelineFigure, false);
            Command relayoutUndo = OccurrenceSpecificationMoveHelper.getReLayoutCmd((BorderedNodeFigure)lifelineFigure, true);
            if (relayout != null && relayoutUndo != null) {
                CompoundCommand commandWithRelayout = new CompoundCommand();
                commandWithRelayout.add(relayoutUndo);
                commandWithRelayout.add((Command)globalCmd);
                commandWithRelayout.add(relayout);
                return commandWithRelayout;
            }
        }
        if (globalCmd.isEmpty()) {
            return null;
        }
        return globalCmd;
    }

    private static Command getMoveSingleTimeRelatedElementCommand(final ObservationLinkEditPart targetConnection, final OccurrenceSpecification movedOccurrenceSpecification1, final OccurrenceSpecification movedOccurrenceSpecification2, final int yLocation1, final int yLocation2, final LifelineEditPart lifelinePart) {
        AbstractTransactionalCommand updateTargetAnchorCommand = new AbstractTransactionalCommand(targetConnection.getEditingDomain(), "update target anchor", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Point referencePoint1 = OccurrenceSpecificationMoveHelper.getReferencePoint(lifelinePart, movedOccurrenceSpecification1, yLocation1);
                Point referencePoint2 = OccurrenceSpecificationMoveHelper.getReferencePoint(lifelinePart, movedOccurrenceSpecification2, yLocation2);
                int position1 = 0;
                int position2 = 0;
                TimeObservationLabelEditPart tolEP = (TimeObservationLabelEditPart)targetConnection.getSource();
                if (tolEP == null) {
                    return CommandResult.newCancelledCommandResult();
                }
                if (movedOccurrenceSpecification1 != null) {
                    position1 = SequenceUtil.positionWhereEventIsLinkedToPart(movedOccurrenceSpecification1, tolEP);
                }
                if (movedOccurrenceSpecification2 != null) {
                    position2 = SequenceUtil.positionWhereEventIsLinkedToPart(movedOccurrenceSpecification2, tolEP);
                }
                ConnectionAnchor targetAnchor = null;
                if (position1 == 2) {
                    targetAnchor = LifelineEditPartUtil.getNodeFigure(lifelinePart).getSourceConnectionAnchorAt(referencePoint1);
                } else if (position2 == 2) {
                    targetAnchor = LifelineEditPartUtil.getNodeFigure(lifelinePart).getSourceConnectionAnchorAt(referencePoint2);
                }
                if (targetAnchor != null) {
                    String newTargetTerminal = lifelinePart.mapConnectionAnchorToTerminal(targetAnchor);
                    ConnectorImpl c = (ConnectorImpl)targetConnection.getModel();
                    if (newTargetTerminal != null) {
                        if (newTargetTerminal.length() == 0) {
                            c.setTargetAnchor(null);
                        } else {
                            IdentityAnchor a = (IdentityAnchor)c.getTargetAnchor();
                            if (a == null) {
                                a = NotationFactory.eINSTANCE.createIdentityAnchor();
                            }
                            a.setId(newTargetTerminal);
                            c.setTargetAnchor((Anchor)a);
                        }
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        };
        ICommandProxy resize = new ICommandProxy((ICommand)updateTargetAnchorCommand);
        return resize;
    }

    private static Command getMoveSingleTimeRelatedElementCommand(IBorderItemEditPart timePart, OccurrenceSpecification movedOccurrenceSpecification1, OccurrenceSpecification movedOccurrenceSpecification2, int yLocation1, int yLocation2, LifelineEditPart lifelinePart) {
        Point referencePoint1;
        IFigure lifelineFigure = lifelinePart.getFigure();
        int position1 = 0;
        int position2 = 0;
        if (movedOccurrenceSpecification1 != null) {
            position1 = SequenceUtil.positionWhereEventIsLinkedToPart(movedOccurrenceSpecification1, timePart);
        }
        if (movedOccurrenceSpecification2 != null) {
            position2 = SequenceUtil.positionWhereEventIsLinkedToPart(movedOccurrenceSpecification2, timePart);
        }
        Rectangle newBounds = null;
        if (position1 != 0 && position2 != 0) {
            referencePoint1 = OccurrenceSpecificationMoveHelper.getReferencePoint(lifelinePart, movedOccurrenceSpecification1, yLocation1);
            Point referencePoint2 = OccurrenceSpecificationMoveHelper.getReferencePoint(lifelinePart, movedOccurrenceSpecification2, yLocation2);
            OccurrenceSpecificationMoveHelper.makeRelativeToLifeline(referencePoint1, lifelinePart, false);
            OccurrenceSpecificationMoveHelper.makeRelativeToLifeline(referencePoint2, lifelinePart, false);
            int oldY = timePart.getFigure().getBounds().getLocation().y - lifelineFigure.getBounds().getLocation().y;
            int oldHeight = timePart.getFigure().getSize().height;
            if (position1 == 2 || position2 == 2) {
                newBounds = new Rectangle(referencePoint1.x, referencePoint1.y - oldHeight / 2, -1, oldHeight);
            } else {
                int top = oldY;
                int bottom = oldY + oldHeight;
                if (position1 == 8) {
                    top = referencePoint1.y;
                } else if (position1 == 32) {
                    bottom = referencePoint1.y;
                }
                if (position2 == 8) {
                    top = referencePoint2.y;
                } else if (position2 == 32) {
                    bottom = referencePoint2.y;
                }
                int viewX = (Integer)ViewUtil.getPropertyValue((View)((View)timePart.getModel()), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (EClass)NotationPackage.eINSTANCE.getLocation_X().getEContainingClass());
                newBounds = new Rectangle(viewX, Math.min(top, bottom), -1, Math.abs(bottom - top));
            }
        } else if (position1 != 0) {
            referencePoint1 = OccurrenceSpecificationMoveHelper.getReferencePoint(lifelinePart, movedOccurrenceSpecification1, yLocation1);
            OccurrenceSpecificationMoveHelper.makeRelativeToLifeline(referencePoint1, lifelinePart, false);
            int oldY = timePart.getFigure().getBounds().getLocation().y - lifelineFigure.getBounds().getLocation().y;
            int oldHeight = timePart.getFigure().getSize().height;
            if (position1 == 2) {
                newBounds = new Rectangle(referencePoint1.x, referencePoint1.y - oldHeight / 2, -1, oldHeight);
            } else {
                int top = oldY;
                int bottom = oldY + oldHeight;
                if (position1 == 8) {
                    top = referencePoint1.y;
                } else if (position1 == 32) {
                    bottom = referencePoint1.y;
                }
                newBounds = new Rectangle(referencePoint1.x, Math.min(top, bottom), -1, Math.abs(bottom - top));
            }
        } else if (position2 != 0) {
            Point referencePoint2 = OccurrenceSpecificationMoveHelper.getReferencePoint(lifelinePart, movedOccurrenceSpecification2, yLocation2);
            OccurrenceSpecificationMoveHelper.makeRelativeToLifeline(referencePoint2, lifelinePart, false);
            int oldY = timePart.getFigure().getBounds().getLocation().y - lifelineFigure.getBounds().getLocation().y;
            int oldHeight = timePart.getFigure().getSize().height;
            if (position2 == 2) {
                newBounds = new Rectangle(referencePoint2.x, referencePoint2.y - oldHeight / 2, -1, oldHeight);
            } else {
                int top = oldY;
                int bottom = oldY + oldHeight;
                if (position2 == 8) {
                    top = referencePoint2.y;
                } else if (position2 == 32) {
                    bottom = referencePoint2.y;
                }
                newBounds = new Rectangle(referencePoint2.x, Math.min(top, bottom), -1, Math.abs(bottom - top));
            }
        }
        if (newBounds != null) {
            TransactionalEditingDomain editingDomain = timePart.getEditingDomain();
            if (timePart instanceof CustomDurationConstraintEditPart) {
                CustomDurationConstraintEditPart dcep = (CustomDurationConstraintEditPart)timePart;
                newBounds = dcep.updateMoveBounds(newBounds);
            }
            ICommandProxy resize = new ICommandProxy((ICommand)new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)((View)timePart.getModel())), newBounds));
            return resize;
        }
        return null;
    }

    private static void makeRelativeToLifeline(Point absolutePoint, LifelineEditPart lifelinePart, boolean relativeToContentPane) {
        IFigure figure = relativeToContentPane ? lifelinePart.getContentPane() : lifelinePart.getFigure();
        figure.translateToRelative((Translatable)absolutePoint);
        absolutePoint.translate(figure.getBounds().getLocation().getNegated());
    }

    private static Command getMoveExecutionSpecificationCommand(OccurrenceSpecification movedOccurrenceSpecification1, OccurrenceSpecification movedOccurrenceSpecification2, int yLocation1, int yLocation2, LifelineEditPart lifelinePart, List<EditPart> notToMoveEditParts) {
        Command cmd;
        CompoundCommand globalCmd = new CompoundCommand();
        EditPart node1 = null;
        if (movedOccurrenceSpecification1 != null) {
            node1 = SequenceUtil.getLinkedEditPart((EditPart)lifelinePart, movedOccurrenceSpecification1);
        }
        EditPart node2 = null;
        if (movedOccurrenceSpecification2 != null) {
            node2 = SequenceUtil.getLinkedEditPart((EditPart)lifelinePart, movedOccurrenceSpecification2);
        }
        if (node1 instanceof GraphicalEditPart && !notToMoveEditParts.contains(node1) && (cmd = OccurrenceSpecificationMoveHelper.getMoveSingleExecutionSpecificationCommand((GraphicalEditPart)node1, movedOccurrenceSpecification1, movedOccurrenceSpecification2, yLocation1, yLocation2, lifelinePart)) != null) {
            globalCmd.add(cmd);
        }
        if (node2 != node1 && node2 instanceof GraphicalEditPart && !notToMoveEditParts.contains(node2) && (cmd = OccurrenceSpecificationMoveHelper.getMoveSingleExecutionSpecificationCommand((GraphicalEditPart)node2, movedOccurrenceSpecification2, null, yLocation2, -1, lifelinePart)) != null) {
            globalCmd.add(cmd);
        }
        if (globalCmd.isEmpty()) {
            return null;
        }
        return globalCmd;
    }

    private static Command getMoveSingleExecutionSpecificationCommand(GraphicalEditPart executionSpecificationPart, OccurrenceSpecification movedOccurrenceSpecification1, OccurrenceSpecification movedOccurrenceSpecification2, int yLocation1, int yLocation2, LifelineEditPart lifelinePart) {
        EObject execution = executionSpecificationPart.resolveSemanticElement();
        if (execution instanceof ExecutionSpecification) {
            int position1 = 0;
            int position2 = 0;
            OccurrenceSpecification start = ((ExecutionSpecification)execution).getStart();
            OccurrenceSpecification finish = ((ExecutionSpecification)execution).getFinish();
            if (start != null && start.equals(movedOccurrenceSpecification1)) {
                position1 = 8;
            } else if (finish != null && finish.equals(movedOccurrenceSpecification1)) {
                position1 = 32;
            }
            if (start != null && start.equals(movedOccurrenceSpecification2)) {
                position2 = 8;
            } else if (finish != null && finish.equals(movedOccurrenceSpecification2)) {
                position2 = 32;
            }
            Rectangle newBounds = null;
            int heighDelta = 0;
            if (position1 != 0 && position2 != 0) {
                Point referencePoint1 = OccurrenceSpecificationMoveHelper.getReferencePoint(lifelinePart, movedOccurrenceSpecification1, yLocation1);
                Point referencePoint2 = OccurrenceSpecificationMoveHelper.getReferencePoint(lifelinePart, movedOccurrenceSpecification2, yLocation2);
                OccurrenceSpecificationMoveHelper.makeRelativeToLifeline(referencePoint1, lifelinePart, true);
                OccurrenceSpecificationMoveHelper.makeRelativeToLifeline(referencePoint2, lifelinePart, true);
                Rectangle esBounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)executionSpecificationPart);
                Point esLoc = esBounds.getLocation();
                OccurrenceSpecificationMoveHelper.makeRelativeToLifeline(esLoc, lifelinePart, true);
                esBounds.setLocation(esLoc);
                int oldX = esBounds.x;
                int oldY = esBounds.y;
                int oldWidth = esBounds.width;
                int oldHeight = esBounds.height;
                int top = oldY;
                int bottom = oldY + oldHeight;
                if (position1 == 8) {
                    top = referencePoint1.y;
                } else if (position1 == 32) {
                    bottom = referencePoint1.y;
                }
                if (position2 == 8) {
                    top = referencePoint2.y;
                } else if (position2 == 32) {
                    bottom = referencePoint2.y;
                }
                newBounds = new Rectangle(oldX, Math.min(top, bottom), oldWidth, Math.abs(bottom - top));
            } else if (position1 != 0) {
                Point referencePoint1 = OccurrenceSpecificationMoveHelper.getReferencePoint(lifelinePart, movedOccurrenceSpecification1, yLocation1);
                OccurrenceSpecificationMoveHelper.makeRelativeToLifeline(referencePoint1, lifelinePart, true);
                Rectangle esBounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)executionSpecificationPart);
                Point esLoc = esBounds.getLocation();
                OccurrenceSpecificationMoveHelper.makeRelativeToLifeline(esLoc, lifelinePart, true);
                esBounds.setLocation(esLoc);
                int oldX = esBounds.x;
                int oldY = esBounds.y;
                int oldWidth = esBounds.width;
                int oldHeight = esBounds.height;
                int top = oldY;
                int bottom = oldY + oldHeight;
                if (position1 == 8) {
                    top = referencePoint1.y;
                } else if (position1 == 32) {
                    bottom = referencePoint1.y;
                }
                newBounds = new Rectangle(oldX, Math.min(top, bottom), oldWidth, Math.abs(bottom - top));
            } else if (position2 != 0) {
                Point referencePoint2 = OccurrenceSpecificationMoveHelper.getReferencePoint(lifelinePart, movedOccurrenceSpecification2, yLocation2);
                OccurrenceSpecificationMoveHelper.makeRelativeToLifeline(referencePoint2, lifelinePart, true);
                Rectangle esBounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)executionSpecificationPart);
                Point esLoc = esBounds.getLocation();
                OccurrenceSpecificationMoveHelper.makeRelativeToLifeline(esLoc, lifelinePart, true);
                esBounds.setLocation(esLoc);
                int oldX = esBounds.x;
                int oldY = esBounds.y;
                int oldWidth = esBounds.width;
                int oldHeight = esBounds.height;
                int top = oldY;
                int bottom = oldY + oldHeight;
                if (position2 == 8) {
                    top = referencePoint2.y;
                } else if (position2 == 32) {
                    bottom = referencePoint2.y;
                }
                newBounds = new Rectangle(oldX, Math.min(top, bottom), oldWidth, Math.abs(bottom - top));
            }
            if (newBounds != null) {
                newBounds.height -= heighDelta;
                return OccurrenceSpecificationMoveHelper.getChangeBoundsCommand((AbstractExecutionSpecificationEditPart)executionSpecificationPart, newBounds);
            }
        }
        return null;
    }

    private static Command getChangeBoundsCommand(AbstractExecutionSpecificationEditPart editPart, Rectangle newBounds) {
        Rectangle oldBounds = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)editPart);
        Point location = oldBounds.getLocation();
        OccurrenceSpecificationMoveHelper.makeRelativeToLifeline(location, (LifelineEditPart)editPart.getParent(), true);
        oldBounds.setLocation(location);
        Point moveDelta = new Point(newBounds.x - oldBounds.x, newBounds.y - oldBounds.y);
        ChangeBoundsRequest req = new ChangeBoundsRequest();
        req.setMoveDelta(moveDelta);
        req.setEditParts((EditPart)editPart);
        req.getExtendedData().put("Do not move these edit parts", true);
        return OLDLifelineXYLayoutEditPolicy.getResizeOrMoveChildrenCommand((LifelineEditPart)editPart.getParent(), req, true, false, true);
    }

    private static Point getReferencePoint(LifelineEditPart lifelinePart, OccurrenceSpecification movedOccurrenceSpecification, int yLocation) {
        Point referencePoint = SequenceUtil.findLocationOfEvent(lifelinePart, (InteractionFragment)movedOccurrenceSpecification);
        if (referencePoint == null) {
            referencePoint = lifelinePart.getFigure().getBounds().getCenter().getCopy();
        }
        referencePoint.y = yLocation;
        return referencePoint;
    }

    public static Command completeReconnectConnectionCommand(Command command, ReconnectRequest request, INodeEditPart connectableNode) {
        Command cmd;
        OccurrenceSpecification event2;
        Command cmd2;
        if (OccurrenceSpecificationMoveHelper.chainEffectIsDisabled((Request)request)) {
            return command;
        }
        CompoundCommand globalCmd = new CompoundCommand();
        globalCmd.add(command);
        ArrayList<EditPart> notToMoveEditParts = new ArrayList<EditPart>(1);
        notToMoveEditParts.add((EditPart)request.getConnectionEditPart());
        LifelineEditPart lifelinePart = SequenceUtil.getParentLifelinePart((EditPart)connectableNode);
        MessageEnd event = OccurrenceSpecificationMoveHelper.getMessageEndFromReconnectMessage(request);
        if (event instanceof OccurrenceSpecification && (cmd2 = OccurrenceSpecificationMoveHelper.getMoveOccurrenceSpecificationsCommand((OccurrenceSpecification)event, null, request.getLocation().y, -1, lifelinePart, notToMoveEditParts, (Request)request)) != null) {
            globalCmd.add(cmd2);
        }
        if ((event2 = OccurrenceSpecificationMoveHelper.getOccurrenceSpecificationFromReconnectGeneralOrdering(request)) instanceof OccurrenceSpecification && (cmd = OccurrenceSpecificationMoveHelper.getMoveOccurrenceSpecificationsCommand(event2, null, request.getLocation().y, -1, lifelinePart, notToMoveEditParts, (Request)request)) != null) {
            globalCmd.add(cmd);
        }
        return globalCmd;
    }

    private static boolean chainEffectIsDisabled(Request request) {
        Object doNotToMoveEditParts = request.getExtendedData().get("Do not move these edit parts");
        return Boolean.TRUE.equals(doNotToMoveEditParts);
    }

    public static CompoundCommand completeMoveExecutionSpecificationCommand(CompoundCommand compoundCmd, ShapeNodeEditPart executionSpecificationEP, Rectangle newBounds, ChangeBoundsRequest request) {
        if (OccurrenceSpecificationMoveHelper.chainEffectIsDisabled((Request)request)) {
            return compoundCmd;
        }
        EObject execSpec = executionSpecificationEP.resolveSemanticElement();
        if (execSpec instanceof ExecutionSpecification) {
            Command cmd;
            EditPart message;
            LifelineEditPart lifelinePart = SequenceUtil.getParentLifelinePart((EditPart)executionSpecificationEP);
            newBounds = newBounds.getCopy();
            IFigure parentFig = executionSpecificationEP.getFigure().getParent();
            parentFig.translateToAbsolute((Translatable)newBounds);
            newBounds.translate(parentFig.getBounds().getLocation());
            OccurrenceSpecification start = ((ExecutionSpecification)execSpec).getStart();
            int startY = newBounds.getTop().y;
            OccurrenceSpecification finish = ((ExecutionSpecification)execSpec).getFinish();
            int finishY = newBounds.getBottom().y;
            ArrayList<EditPart> notToMoveEditParts = new ArrayList<EditPart>(1);
            notToMoveEditParts.add((EditPart)executionSpecificationEP);
            if (start instanceof MessageOccurrenceSpecification && (message = SequenceUtil.getLinkedEditPart((EditPart)lifelinePart, start)) != null) {
                notToMoveEditParts.add(message);
            }
            if (finish instanceof MessageOccurrenceSpecification && (message = SequenceUtil.getLinkedEditPart((EditPart)lifelinePart, finish)) != null) {
                notToMoveEditParts.add(message);
            }
            if ((cmd = OccurrenceSpecificationMoveHelper.getMoveOccurrenceSpecificationsCommand(start, finish, startY, finishY, lifelinePart, notToMoveEditParts, (Request)request)) != null) {
                compoundCmd.add(cmd);
            }
        }
        return compoundCmd;
    }

    public static void prepareTimeRelatedElementMoveRequest(ChangeBoundsRequest request, IBorderItemEditPart movedTimePart) {
        if (!OccurrenceSpecificationMoveHelper.canTimeElementPartBeYMoved(movedTimePart)) {
            request.getMoveDelta().y = 0;
        } else {
            Point moveDelta = request.getMoveDelta();
            if (Math.abs(moveDelta.x) > Math.abs(moveDelta.y)) {
                moveDelta.y = 0;
            } else {
                moveDelta.x = 0;
            }
        }
    }

    public static Command completeMoveTimeRelatedElementCommand(Command moveCommand, ChangeBoundsRequest request, EditPart hostEditPart, IFigure hostFigure) {
        if (OccurrenceSpecificationMoveHelper.chainEffectIsDisabled((Request)request)) {
            return moveCommand;
        }
        Rectangle bounds = request.getTransformedRectangle(hostFigure.getBounds());
        hostFigure.getParent().translateToAbsolute((Translatable)bounds);
        LifelineEditPart lifelinePart = SequenceUtil.getParentLifelinePart(hostEditPart);
        if (lifelinePart != null && hostEditPart instanceof IBorderItemEditPart) {
            List<EditPart> notToMoveEditParts;
            Command cmd;
            Element elem;
            Iterator it;
            IBorderItemEditPart timeElementEditPart = (IBorderItemEditPart)hostEditPart;
            EObject timeElement = timeElementEditPart.resolveSemanticElement();
            OccurrenceSpecification occSpec1 = null;
            int yLocation1 = -1;
            OccurrenceSpecification occSpec2 = null;
            int yLocation2 = -1;
            if (timeElement instanceof TimeConstraint) {
                it = ((TimeConstraint)timeElement).getConstrainedElements().iterator();
                while (it.hasNext() && occSpec1 == null) {
                    int position1;
                    elem = (Element)it.next();
                    if (!(elem instanceof OccurrenceSpecification) || (position1 = OccurrenceSpecificationMoveHelper.whereEventIsLinked((OccurrenceSpecification)elem, (EditPart)timeElementEditPart)) == 0) continue;
                    occSpec1 = (OccurrenceSpecification)elem;
                    yLocation1 = OccurrenceSpecificationMoveHelper.getLocation((Rectangle)bounds, (int)position1).y;
                }
            } else if (timeElement instanceof TimeObservation) {
                int position1;
                NamedElement event = ((TimeObservation)timeElement).getEvent();
                if (event instanceof OccurrenceSpecification && (position1 = OccurrenceSpecificationMoveHelper.whereEventIsLinked((OccurrenceSpecification)event, (EditPart)timeElementEditPart)) != 0) {
                    occSpec1 = (OccurrenceSpecification)event;
                    yLocation1 = OccurrenceSpecificationMoveHelper.getLocation((Rectangle)bounds, (int)position1).y;
                }
            } else if (timeElement instanceof DurationConstraint) {
                it = ((DurationConstraint)timeElement).getConstrainedElements().iterator();
                while (it.hasNext() && (occSpec1 == null || occSpec2 == null)) {
                    int position1;
                    elem = (Element)it.next();
                    if (elem instanceof OccurrenceSpecification && occSpec1 != null) {
                        int position2 = OccurrenceSpecificationMoveHelper.whereEventIsLinked((OccurrenceSpecification)elem, (EditPart)timeElementEditPart);
                        if (position2 == 0) continue;
                        occSpec2 = (OccurrenceSpecification)elem;
                        yLocation2 = OccurrenceSpecificationMoveHelper.getLocation((Rectangle)bounds, (int)position2).y;
                        continue;
                    }
                    if (!(elem instanceof OccurrenceSpecification) || (position1 = OccurrenceSpecificationMoveHelper.whereEventIsLinked((OccurrenceSpecification)elem, (EditPart)timeElementEditPart)) == 0) continue;
                    occSpec1 = (OccurrenceSpecification)elem;
                    yLocation1 = OccurrenceSpecificationMoveHelper.getLocation((Rectangle)bounds, (int)position1).y;
                }
            }
            if (occSpec1 != null && (cmd = OccurrenceSpecificationMoveHelper.getMoveOccurrenceSpecificationsCommand(occSpec1, occSpec2, yLocation1, yLocation2, lifelinePart, notToMoveEditParts = Collections.singletonList(hostEditPart), (Request)request)) != null) {
                return moveCommand.chain(cmd);
            }
        }
        return null;
    }

    private static ReconnectRequest makeReconnectRequest(ConnectionEditPart connection, boolean isSource, Point location, EditPart partToReconnectTo) {
        String type;
        EditPart targetEP = partToReconnectTo;
        if (isSource) {
            type = "Reconnection source";
            if (targetEP == null) {
                targetEP = connection.getSource();
            }
        } else {
            type = "Reconnection target";
            if (targetEP == null) {
                targetEP = connection.getTarget();
            }
        }
        ReconnectRequest reconnReq = new ReconnectRequest();
        reconnReq.setConnectionEditPart((org.eclipse.gef.ConnectionEditPart)connection);
        reconnReq.setLocation(location);
        reconnReq.setTargetEditPart(targetEP);
        reconnReq.setType((Object)type);
        reconnReq.getExtendedData().put("Do not move these edit parts", true);
        return reconnReq;
    }

    private static Point getLocation(Rectangle bounds, int position) {
        if (position == 8) {
            return bounds.getTop();
        }
        if (position == 2) {
            return bounds.getCenter();
        }
        if (position == 32) {
            return bounds.getBottom();
        }
        return null;
    }

    private static int whereEventIsLinked(OccurrenceSpecification event, EditPart hostEditPart) {
        if (hostEditPart instanceof IBorderItemEditPart) {
            return SequenceUtil.positionWhereEventIsLinkedToPart(event, (IBorderItemEditPart)hostEditPart);
        }
        return 0;
    }

    private static OccurrenceSpecification getOccurrenceSpecificationFromReconnectGeneralOrdering(ReconnectRequest request) {
        EObject generalOrdering;
        if (request.getConnectionEditPart() instanceof ConnectionEditPart && (generalOrdering = ((ConnectionEditPart)request.getConnectionEditPart()).resolveSemanticElement()) instanceof GeneralOrdering) {
            if ("Reconnection source".equals(request.getType())) {
                return ((GeneralOrdering)generalOrdering).getBefore();
            }
            if ("Reconnection target".equals(request.getType())) {
                return ((GeneralOrdering)generalOrdering).getAfter();
            }
        }
        return null;
    }

    private static MessageEnd getMessageEndFromReconnectMessage(ReconnectRequest request) {
        EObject message;
        if (request.getConnectionEditPart() instanceof ConnectionEditPart && (message = ((ConnectionEditPart)request.getConnectionEditPart()).resolveSemanticElement()) instanceof Message) {
            if ("Reconnection source".equals(request.getType())) {
                return ((Message)message).getSendEvent();
            }
            if ("Reconnection target".equals(request.getType())) {
                return ((Message)message).getReceiveEvent();
            }
        }
        return null;
    }

    public static boolean canTimeElementPartBeYMoved(IBorderItemEditPart timeElementPart) {
        EObject timeElement = timeElementPart.resolveSemanticElement();
        EList occurrences = Collections.emptyList();
        if (timeElement instanceof TimeObservation) {
            NamedElement occurence = ((TimeObservation)timeElement).getEvent();
            occurrences = Collections.singletonList(occurence);
        } else if (timeElement instanceof TimeConstraint || timeElement instanceof DurationConstraint) {
            occurrences = ((IntervalConstraint)timeElement).getConstrainedElements();
        }
        for (Element occurrence : occurrences) {
            if (!(occurrence instanceof DestructionOccurrenceSpecification)) continue;
            return false;
        }
        return true;
    }

    private static Command getReLayoutCmd(BorderedNodeFigure node, boolean onUndo) {
        final IFigure container = node.getBorderItemContainer();
        if (onUndo) {
            return new Command(){

                public void undo() {
                    container.getLayoutManager().layout(container);
                }
            };
        }
        return new Command(){

            public void execute() {
                container.getLayoutManager().layout(container);
            }
        };
    }
}

