/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.utils;

import com.ibm.icu.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.swt.widgets.Display;

public class UnitsConverterUtils {
    private UnitsConverterUtils() {
    }

    public static final String convertUnits(int fromUnits, int toUnits, String valueStr) {
        if (fromUnits == toUnits) {
            return valueStr;
        }
        NumberFormat numberFormatter = NumberFormat.getInstance();
        Double value = new Double(0.125);
        try {
            value = UnitsConverterUtils.forceDouble(numberFormatter.parse(valueStr));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        double pixelValue = 0.0;
        Display display = Display.getDefault();
        switch (fromUnits) {
            case 0: {
                pixelValue = value * (double)display.getDPI().x;
                break;
            }
            case 1: {
                pixelValue = value * (double)display.getDPI().x / 2.54;
                break;
            }
            case 2: {
                pixelValue = value.intValue();
                break;
            }
        }
        double returnValue = 0.0;
        switch (toUnits) {
            case 0: {
                returnValue = pixelValue / (double)display.getDPI().x;
                break;
            }
            case 1: {
                returnValue = pixelValue * 2.54 / (double)display.getDPI().x;
                break;
            }
            case 2: {
                returnValue = pixelValue;
                break;
            }
        }
        return numberFormatter.format(returnValue);
    }

    private static final Double forceDouble(Number number) {
        if (!(number instanceof Double)) {
            return new Double(number.doubleValue());
        }
        return (Double)number;
    }
}

