/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.common.utils;

import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.internationalization.common.Activator;
import org.eclipse.papyrus.infra.internationalization.common.utils.LocaleNameResolver;

public class InternationalizationPreferencesUtils {
    public static boolean isInternationalizationNeedToBeLoaded() {
        boolean result = false;
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        if (preferenceStore != null && preferenceStore.contains("loadInternationalization")) {
            result = preferenceStore.getBoolean("loadInternationalization");
        }
        return result;
    }

    public static boolean isInternationalizationExternalFilesNeedToBeLoaded() {
        boolean result = false;
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        if (preferenceStore != null && preferenceStore.contains("loadInternationalizationofExternalFiles")) {
            result = preferenceStore.getBoolean("loadInternationalizationofExternalFiles");
        }
        return result;
    }

    public static IPreferenceStore getPreferenceStore(EObject eObject) {
        URI resourceURI = eObject.eResource().getURI();
        ResourceSet resourceSet = eObject.eResource().getResourceSet();
        if (resourceSet instanceof ModelSet && ((ModelSet)resourceSet).getURIWithoutExtension() != null) {
            resourceURI = ((ModelSet)resourceSet).getURIWithoutExtension().appendFileExtension("di");
        }
        return InternationalizationPreferencesUtils.getPreferenceStore(resourceURI);
    }

    public static IPreferenceStore getPreferenceStore(Resource resource) {
        IPreferenceStore result = null;
        if (resource != null) {
            result = InternationalizationPreferencesUtils.getPreferenceStore(resource.getURI());
        }
        return result;
    }

    public static IPreferenceStore getPreferenceStore(URI uri) {
        IFile resourceFile;
        String filePathString;
        IPreferenceStore result = null;
        if (uri != null && (filePathString = CommonPlugin.resolve((URI)uri).toFileString()) != null && (resourceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(filePathString))) != null) {
            IProject currentProject = resourceFile.getProject();
            String papyrusProjectName = uri.trimFileExtension().lastSegment();
            if (currentProject != null && !papyrusProjectName.isEmpty()) {
                result = Activator.getDefault().getInternationalizationPreferenceStore(currentProject, papyrusProjectName);
            }
        }
        return result;
    }

    public static void setInternationalizationPreference(EObject eObject, boolean value) {
        URI resourceURI = eObject.eResource().getURI();
        ResourceSet resourceSet = eObject.eResource().getResourceSet();
        if (resourceSet instanceof ModelSet && ((ModelSet)resourceSet).getURIWithoutExtension() != null) {
            resourceURI = ((ModelSet)resourceSet).getURIWithoutExtension().appendFileExtension("di");
        }
        InternationalizationPreferencesUtils.setInternationalizationPreference(resourceURI, value);
    }

    public static void setInternationalizationPreference(Resource resource, boolean value) {
        InternationalizationPreferencesUtils.setInternationalizationPreference(resource.getURI(), value);
    }

    public static void setInternationalizationPreference(URI resourceURI, boolean value) {
        IPreferenceStore preferenceStore = InternationalizationPreferencesUtils.getPreferenceStore(resourceURI);
        if (preferenceStore != null) {
            preferenceStore.setValue("useInternationalization", value);
        }
    }

    public static boolean getInternationalizationPreference(EObject eObject) {
        boolean result = false;
        if (eObject != null && eObject.eResource() != null) {
            URI resourceURI = eObject.eResource().getURI();
            ResourceSet resourceSet = eObject.eResource().getResourceSet();
            if (resourceSet instanceof ModelSet && ((ModelSet)resourceSet).getURIWithoutExtension() != null) {
                resourceURI = ((ModelSet)resourceSet).getURIWithoutExtension().appendFileExtension("di");
            }
            result = InternationalizationPreferencesUtils.getInternationalizationPreference(resourceURI);
        }
        return result;
    }

    public static boolean getInternationalizationPreference(Resource resource) {
        return InternationalizationPreferencesUtils.getInternationalizationPreference(resource.getURI());
    }

    public static boolean getInternationalizationPreference(URI resourceURI) {
        boolean result = false;
        IPreferenceStore preferenceStore = InternationalizationPreferencesUtils.getPreferenceStore(resourceURI);
        if (preferenceStore != null && preferenceStore.contains("useInternationalization")) {
            result = preferenceStore.getBoolean("useInternationalization");
        }
        return result;
    }

    private static String getLanguagePreference(URI uri) {
        String result = null;
        IPreferenceStore preferenceStore = InternationalizationPreferencesUtils.getPreferenceStore(uri);
        if (preferenceStore != null && preferenceStore.contains("language")) {
            result = preferenceStore.getString("language");
        }
        return result;
    }

    public static Locale getLocalePreference(EObject eObject) {
        Locale result = null;
        if (eObject != null && eObject.eResource() != null) {
            URI resourceURI = eObject.eResource().getURI();
            ResourceSet resourceSet = eObject.eResource().getResourceSet();
            if (resourceSet instanceof ModelSet && ((ModelSet)resourceSet).getURIWithoutExtension() != null) {
                resourceURI = ((ModelSet)resourceSet).getURIWithoutExtension().appendFileExtension("di");
            }
            result = InternationalizationPreferencesUtils.getLocalePreference(resourceURI);
        }
        return result;
    }

    public static Locale getLocalePreference(URI uri) {
        String localePreference = InternationalizationPreferencesUtils.getLanguagePreference(uri);
        Locale result = null;
        result = localePreference != null ? LocaleNameResolver.getLocaleFromString(localePreference) : Locale.getDefault();
        return result;
    }

    public static void setLanguagePreference(EObject eObject, String language) {
        URI resourceURI = eObject.eResource().getURI();
        ResourceSet resourceSet = eObject.eResource().getResourceSet();
        if (resourceSet instanceof ModelSet && ((ModelSet)resourceSet).getURIWithoutExtension() != null) {
            resourceURI = ((ModelSet)resourceSet).getURIWithoutExtension().appendFileExtension("di");
        }
        InternationalizationPreferencesUtils.setLanguagePreference(resourceURI, language);
    }

    public static void setLanguagePreference(Resource resource, String language) {
        InternationalizationPreferencesUtils.setLanguagePreference(resource.getURI(), language);
    }

    public static void setLanguagePreference(URI resourceURI, String language) {
        IPreferenceStore preferenceStore = InternationalizationPreferencesUtils.getPreferenceStore(resourceURI);
        if (preferenceStore != null) {
            preferenceStore.setValue("language", language);
        }
    }
}

