/*****************************************************************************
 * Copyright s(c) 2017 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   CEA LIST - Initial API and implementation
 *   Mickaël ADAM (ALL4TEC) mickael.adam@all4tec.net - Bug 526191
 *****************************************************************************/

package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.papyrus.uml.diagram.common.editparts.RoundedCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;

/**
 * this editpolicy is to manage the movement of Execution specification and update move of messages
 * It is like a graphical node
 * 
 * @since 4.0
 *
 */
public class UpdateWeakReferenceForExecSpecEditPolicy extends UpdateWeakReferenceEditPolicy {
	public static final String UDPATE_WEAK_REFERENCE_FOR_EXECSPEC = "UpdateWeakReferenceForExecSpecEditPolicy"; //$NON-NLS-1$

	/**
	 * @see org.eclipse.gef.editpolicies.AbstractEditPolicy#getCommand(org.eclipse.gef.Request)
	 *
	 * @param request
	 * @return
	 * 
	 * 
	 * 		<img src="../../../../../../../../../icons/sequenceScheme.png" width="250" />
	 *         <UL>
	 *         <LI>when move E --> move B on the coordinate Y of E and move A on the coordinate Y of E
	 *         <LI>when Move F (execution specification) (resize)--> move C on the coordinate of C of F and move D on the coordinate of Y of F
	 *         <LI>Move E and F (execution specification) move the execution--> move B on the coordinate of Y of E and move A on the coordinate of Y of E and move C on the coordinate of C of F and move D on the coordinate of Y of F
	 *         <UL>
	 *
	 */
	@Override
	public Command getCommand(Request request) {
		if (request instanceof ChangeBoundsRequest && (!org.eclipse.gmf.runtime.diagram.ui.requests.RequestConstants.REQ_AUTOSIZE.equals(request.getType()))) {
			Point nextLocation = ((ChangeBoundsRequest) request).getLocation();
			UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+ MOVE at " + nextLocation + " of " + getHost());//$NON-NLS-1$ //$NON-NLS-2$
			Rectangle locationAndSize = new PrecisionRectangle(getHostFigure().getBounds());
			Point moveDelta = new Point(0, 0);
			if (RequestConstants.REQ_MOVE.equals(request.getType())) {
				moveDelta = ((ChangeBoundsRequest) request).getMoveDelta();
			} else if (RequestConstants.REQ_RESIZE.equals(request.getType())) {
				moveDelta = new Point(0, ((ChangeBoundsRequest) request).getSizeDelta().height + ((ChangeBoundsRequest) request).getMoveDelta().y);
			}
			if (moveDelta.y != 0 && mustMove) {
				if (getHost() instanceof AbstractExecutionSpecificationEditPart) {
					getHostFigure().translateToAbsolute(locationAndSize);
					locationAndSize = ((ChangeBoundsRequest) request).getTransformedRectangle(locationAndSize);
				}
				if (getHost().getEditPolicy(SequenceReferenceEditPolicy.SEQUENCE_REFERENCE) != null) {
					SequenceReferenceEditPolicy references = (SequenceReferenceEditPolicy) getHost().getEditPolicy(SequenceReferenceEditPolicy.SEQUENCE_REFERENCE);
					if (!SenderRequestUtils.isASender(request, getHost())) {
						CompoundCommand compoundCommand = new CompoundCommand();

						// Gets weak references
						HashMap<EditPart, String> weakReferences = new HashMap<EditPart, String>();
						if ((moveDelta.y > 0 && mustMoveBelowAtMovingDown) || (moveDelta.y < 0 && mustMoveBelowAtMovingUp)) {
							weakReferences.putAll(references.getWeakReferences());
						}

						for (Iterator<EditPart> iterator = weakReferences.keySet().iterator(); iterator.hasNext();) {
							EditPart editPart = (EditPart) iterator.next();
							if (!SenderRequestUtils.isASender(request, editPart)) {
								UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+--> try to Move of " + moveDelta.y + " " + editPart);//$NON-NLS-1$
								ArrayList<EditPart> senderList = SenderRequestUtils.getSenders(request);

								if (editPart instanceof ConnectionEditPart) {
									ConnectionEditPart connectionEditPart = (ConnectionEditPart) editPart;
									// create the request
									UpdateWeakReferenceEditPolicy.moveSourceConnectionEditPart(getHost(), moveDelta, compoundCommand, connectionEditPart, senderList);
									UpdateWeakReferenceEditPolicy.moveTargetConnectionEditPart(getHost(), moveDelta, compoundCommand, connectionEditPart, senderList);

								}
								if (editPart instanceof RoundedCompartmentEditPart) {
									UpdateWeakReferenceEditPolicy.moveRoundedEditPart(getHost(), moveDelta, compoundCommand, editPart, senderList);
								}
							}
						}
						if (compoundCommand.size() == 0) {
							// to avoid pb of non-executable command
							return super.getCommand(request);
						}

						return compoundCommand;
					}
				}
			}
		}
		return super.getCommand(request);
	}
}
