/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.architecture;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.papyrus.infra.architecture.Activator;
import org.eclipse.papyrus.infra.services.edit.context.TypeContext;
import org.osgi.service.prefs.BackingStoreException;

public class ArchitectureDomainPreferences
implements Cloneable {
    public static final String ADDED_MODELS = "addedModels";
    public static final String EXCLUDED_CONTEXTS = "excludedContexts";
    public static final String DEFAULT_CONTEXT = "defaultContext";
    private final IScopeContext[] scopes = new IScopeContext[]{InstanceScope.INSTANCE, ConfigurationScope.INSTANCE, DefaultScope.INSTANCE};
    private List<String> addedModels;
    private Set<String> excludedContexts;
    private String defaultContext;
    private String defaultDefaultContext = TypeContext.getDefaultContextId();

    private static IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.infra.architecture");
    }

    public void read() {
        IPreferencesService preferences = Platform.getPreferencesService();
        this.addedModels = Arrays.asList(preferences.getString("org.eclipse.papyrus.infra.architecture", ADDED_MODELS, "", this.scopes).split(" "));
        this.excludedContexts = new HashSet<String>(Arrays.asList(preferences.getString("org.eclipse.papyrus.infra.architecture", EXCLUDED_CONTEXTS, "", this.scopes).split(",")));
        this.defaultContext = preferences.getString("org.eclipse.papyrus.infra.architecture", DEFAULT_CONTEXT, this.defaultDefaultContext, this.scopes);
    }

    public void write() {
        ArchitectureDomainPreferences.getPreferences().put(ADDED_MODELS, "");
        ArchitectureDomainPreferences.getPreferences().put(ADDED_MODELS, String.join((CharSequence)" ", this.addedModels));
        ArchitectureDomainPreferences.getPreferences().put(EXCLUDED_CONTEXTS, String.join((CharSequence)",", this.excludedContexts));
        if (this.defaultContext != null) {
            ArchitectureDomainPreferences.getPreferences().put(DEFAULT_CONTEXT, this.defaultContext);
        } else {
            ArchitectureDomainPreferences.getPreferences().remove(DEFAULT_CONTEXT);
        }
        try {
            ArchitectureDomainPreferences.getPreferences().flush();
        }
        catch (BackingStoreException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void reset() {
        this.addedModels.clear();
        this.excludedContexts.clear();
        this.defaultContext = this.defaultDefaultContext;
    }

    public void addListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        ArchitectureDomainPreferences.getPreferences().addPreferenceChangeListener(listener);
    }

    public List<String> getAddedModelURIs() {
        return this.addedModels;
    }

    public Set<String> getExcludedContextIds() {
        return this.excludedContexts;
    }

    public String getDefaultContextId() {
        return this.defaultContext;
    }

    public void setDefaultContextId(String defaultContext) {
        this.defaultContext = defaultContext;
    }

    public ArchitectureDomainPreferences clone() {
        ArchitectureDomainPreferences clone = new ArchitectureDomainPreferences();
        clone.addedModels = new ArrayList<String>(this.getAddedModelURIs());
        clone.excludedContexts = new HashSet<String>(this.getExcludedContextIds());
        clone.setDefaultContextId(this.getDefaultContextId());
        return clone;
    }
}

