/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.onefile.internal.ui.model.adapters;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.onefile.model.PapyrusModelHelper;
import org.eclipse.papyrus.infra.onefile.ui.utils.OneFileUIUtils;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.ILinkHelper;

public class PapyrusLinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput anInput) {
        ArrayList<Object> select = new ArrayList<Object>();
        if (anInput instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)anInput;
            IPapyrusFile papy = PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile(input.getFile());
            select.add(papy);
            IFile res = papy.getMainFile();
            while (res.getParent() != null) {
                select.add(0, res.getParent());
                res = res.getParent();
            }
            return new StructuredSelection((Object)papy);
        }
        return null;
    }

    public void activateEditor(IWorkbenchPage page, IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Object element = selection.getFirstElement();
        IEditorPart part = OneFileUIUtils.isOpenInEditor(element);
        if (part != null) {
            page.bringToTop((IWorkbenchPart)part);
        }
    }
}

