/*****************************************************************************
 * Copyright (c) 2017 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Yupanqui MUNOZ JULHO (CEA LIST) yupanqui.munozjulho@cea.fr - Bug 514518
 *   
 *****************************************************************************/

package org.eclipse.papyrus.uml.diagram.clazz.custom.edit.part;

import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.clazz.custom.policies.ClassDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.InterfaceEditPart;

/**
 * The custom edit policy for the interface edit part.
 *  @since 3.0
 */
public class CustomInterfaceEditPart extends InterfaceEditPart {

	/**
	 * Constructor.
	 *
	 * @param view
	 */
	public CustomInterfaceEditPart(View view) {
		super(view);
	}
	
	/**
	 * @see org.eclipse.papyrus.uml.diagram.clazz.edit.parts.InterfaceEditPart#createDefaultEditPolicies()
	 *
	 */
	@Override
	protected void createDefaultEditPolicies() {
		super.createDefaultEditPolicies();
		installEditPolicy(EditPolicyRoles.DRAG_DROP_ROLE, new ClassDiagramDragDropEditPolicy());
	}

}
