/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.LinkMappingHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class SequenceLinkMappingHelper
implements ILinkMappingHelper {
    public static SequenceLinkMappingHelper getInstance() {
        return SingletonHolder.instance;
    }

    private SequenceLinkMappingHelper() {
    }

    public Collection<?> getSource(Element link) {
        return LinkMappingHelper.getSource((Element)link, (LinkMappingHelper.CommonSourceUMLSwitch)new LinkMappingHelper.CommonSourceUMLSwitch(){

            public Collection<?> caseMessage(Message object) {
                if (object.getSendEvent() != null) {
                    MessageEnd messageEnd = object.getSendEvent();
                    if (messageEnd instanceof MessageOccurrenceSpecification) {
                        return ((MessageOccurrenceSpecification)messageEnd).getCovereds();
                    }
                    if (messageEnd instanceof Gate) {
                        ArrayList<MessageEnd> sources = new ArrayList<MessageEnd>();
                        sources.add(messageEnd);
                        return sources;
                    }
                } else {
                    return Collections.singletonList(object.getInteraction());
                }
                return Collections.emptyList();
            }

            public Collection<?> caseGeneralOrdering(GeneralOrdering object) {
                if (object.getBefore() != null) {
                    OccurrenceSpecification before = object.getBefore();
                    return before.getCovereds();
                }
                return Collections.emptyList();
            }
        });
    }

    public Collection<?> getTarget(Element link) {
        return LinkMappingHelper.getTarget((Element)link, (LinkMappingHelper.CommonTargetUMLSwitch)new LinkMappingHelper.CommonTargetUMLSwitch(){

            public Collection<?> caseMessage(Message object) {
                if (object.getReceiveEvent() != null) {
                    MessageEnd messageEnd = object.getReceiveEvent();
                    if (messageEnd instanceof MessageOccurrenceSpecification) {
                        return ((MessageOccurrenceSpecification)messageEnd).getCovereds();
                    }
                    if (messageEnd instanceof Gate) {
                        ArrayList<MessageEnd> sources = new ArrayList<MessageEnd>();
                        sources.add(messageEnd);
                        return sources;
                    }
                } else {
                    return Collections.singletonList(object.getInteraction());
                }
                return Collections.emptyList();
            }

            public Collection<?> caseGeneralOrdering(GeneralOrdering object) {
                if (object.getAfter() != null) {
                    OccurrenceSpecification after = object.getAfter();
                    return after.getCovereds();
                }
                return Collections.emptyList();
            }
        });
    }

    /* synthetic */ SequenceLinkMappingHelper(SequenceLinkMappingHelper sequenceLinkMappingHelper) {
        this();
    }

    private static class SingletonHolder {
        private static final SequenceLinkMappingHelper instance = new SequenceLinkMappingHelper(null);

        private SingletonHolder() {
        }
    }
}

