/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.papyrus.infra.nattable.handler.AbstractTableHandler;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;

public class RowDestroyAxisHandler
extends AbstractTableHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IAxisManager axisManager = this.getRowAxisManager();
        NatEventData eventData = this.getNatEventData();
        if (axisManager != null && eventData != null) {
            axisManager.destroyAxis(this.getFullSelectedRowsIndex(eventData));
        }
        return null;
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        IAxisManager axisManager = this.getRowAxisManager();
        boolean enabled = false;
        NatEventData eventData = this.getNatEventData();
        if (this.isEnabled() && axisManager != null && eventData != null) {
            List<Integer> rows = this.getFullSelectedRowsIndex(eventData);
            enabled = axisManager.canDestroyAxis(rows);
        }
        this.setBaseEnabled(enabled);
    }
}

