/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.axis;

import ca.odell.glazedlists.EventList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.RowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowShowCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.layer.PapyrusGridLayer;
import org.eclipse.papyrus.infra.nattable.layerstack.RowHeaderHierarchicalLayerStack;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.axis.ITreeItemAxisComparator;
import org.eclipse.papyrus.infra.nattable.manager.axis.ITreeItemAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.ITreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.tree.ITreeItemAxisHelper;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.EventListHelper;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public abstract class AbstractTreeAxisManagerForEventList
extends AbstractAxisManagerForEventList
implements ITreeItemAxisManagerForEventList {
    protected Map<Object, Set<ITreeItemAxis>> managedElements = new HashMap<Object, Set<ITreeItemAxis>>();
    protected Set<ITreeItemAxis> alreadyExpanded = new HashSet<ITreeItemAxis>();
    protected List<TreeFillingConfiguration> currentFillingConfiguration;
    protected ITreeItemAxisComparator comparator;

    @Override
    public void init(INattableModelManager manager, AxisManagerRepresentation rep, AbstractAxisProvider provider) {
        super.init(manager, rep, provider);
        this.currentFillingConfiguration = FillingConfigurationUtils.getTreeFillingConfiguration(this.getTable(), this.representedAxisManager);
        this.comparator = new ITreeItemAxisComparator(this.tableManager, this);
    }

    @Override
    protected void addListeners() {
    }

    @Override
    public final Command getDestroyAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToDestroy) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)this.getRepresentedContentProvider());
        ArrayList<Object> objectsToRemove = new ArrayList<Object>(objectToDestroy.size());
        CompositeCommand compositeCommand = new CompositeCommand("Destroy IAxis Command");
        for (IAxis current : this.getRepresentedContentProvider().getAxis()) {
            if (current.getManager() != this.representedAxisManager || !objectToDestroy.contains(current) && !objectToDestroy.contains(current.getElement())) continue;
            DestroyElementRequest request = new DestroyElementRequest(domain, (EObject)current, false);
            compositeCommand.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
            compositeCommand.add((IUndoableOperation)new EMFtoGMFCommandWrapper(this.getRemoveAxisCommand((ITreeItemAxis)current)));
            if (current instanceof IAxis) {
                objectsToRemove.add(current.getElement());
                continue;
            }
            objectsToRemove.add(current);
        }
        AbstractAxisManager.RemoveCommandWrapper returnedCommand = null;
        if (!compositeCommand.isEmpty()) {
            returnedCommand = new AbstractAxisManager.RemoveCommandWrapper((AbstractAxisManager)this, (Command)new GMFtoEMFCommandWrapper((ICommand)compositeCommand), objectsToRemove);
        }
        return returnedCommand;
    }

    protected ITreeItemAxis addObject(ITreeItemAxis parentAxis, Object objectToAdd) {
        final ITreeItemAxis newAxis = this.createITreeItemAxis(parentAxis, objectToAdd);
        if (objectToAdd instanceof TreeFillingConfiguration) {
            TreeFillingConfiguration conf = (TreeFillingConfiguration)objectToAdd;
            if (this.alreadyExpanded.contains(parentAxis) && StyleUtils.isHiddenDepth(this.getTableManager(), conf.getDepth())) {
                try {
                    if (this.getTableEditingDomain() != null) {
                        GMFUnsafe.write((TransactionalEditingDomain)this.getTableEditingDomain(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                newAxis.setExpanded(true);
                            }
                        });
                    } else {
                        newAxis.setExpanded(true);
                    }
                }
                catch (InterruptedException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (RollbackException e) {
                    Activator.log.error((Throwable)e);
                }
                this.alreadyExpanded.add(newAxis);
            }
        }
        ITreeItemAxisHelper.linkITreeItemAxisToSemanticElement(this.managedElements, newAxis);
        EventListHelper.addToEventList((EventList<Object>)this.eventList, newAxis);
        return newAxis;
    }

    private TreeLayer getTreeLayer() {
        PapyrusGridLayer gridLayer;
        ILayer rowLayer;
        NatTable natTable = (NatTable)this.getTableManager().getAdapter(NatTable.class);
        ILayer layer = natTable.getLayer();
        if (layer instanceof PapyrusGridLayer && (rowLayer = (gridLayer = (PapyrusGridLayer)layer).getRowHeaderLayer()) instanceof RowHeaderHierarchicalLayerStack) {
            return ((RowHeaderHierarchicalLayerStack)rowLayer).getTreeLayer();
        }
        throw new UnknownError("TreeLayer has not been found");
    }

    @Override
    public boolean canBeUsedAsColumnManager() {
        return false;
    }

    @Override
    public boolean canCreateAxisElement(String elementId) {
        return true;
    }

    @Override
    public boolean canDestroyAxis(Integer axisPosition) {
        IAxis axis = (IAxis)this.getTableManager().getRowElementsList().get(axisPosition);
        if (axis instanceof ITreeItemAxis && !(((ITreeItemAxis)axis).getElement() instanceof TreeFillingConfiguration)) {
            return ((ITreeItemAxis)axis).getParent() == null;
        }
        return false;
    }

    @Override
    public boolean canDropAxisElement(Collection<Object> objectsToAdd) {
        return !FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.tableManager.getTable(), this.representedAxisManager, 0) && super.canDropAxisElement(objectsToAdd);
    }

    @Override
    public int compare(ISortModel sortModel, int depth, ITreeItemAxis axis1, ITreeItemAxis axis2) {
        return this.comparator.compare(axis1, axis2);
    }

    protected abstract ITreeItemAxis createITreeItemAxis(ITreeItemAxis var1, Object var2);

    @Override
    public void dispose() {
        super.dispose();
        this.managedElements.clear();
        this.alreadyExpanded.clear();
    }

    protected void featureValueHasChanged(Notification notification) {
    }

    protected void fillChildrenForSemanticElement(ITreeItemAxis axis) {
        if (axis == null || axis.getChildren().size() == 0) {
            Object context;
            int nextDepth = -1;
            if (axis == null) {
                nextDepth = 0;
                context = this.getTableContext();
            } else {
                nextDepth = this.getSemanticDepth(axis) + 1;
                context = axis.getElement();
                Assert.isTrue((!(context instanceof TreeFillingConfiguration) ? 1 : 0) != 0);
            }
            List<TreeFillingConfiguration> confs = FillingConfigurationUtils.getTreeFillingConfigurationForDepth(this.getTable(), this.representedAxisManager, nextDepth);
            for (TreeFillingConfiguration current : confs) {
                Collection<?> values = this.getFilteredValueAsCollection(current, context, nextDepth);
                if (values.size() == 0) continue;
                ITreeItemAxis newAxis = this.addObject(axis, current);
                if (nextDepth != 0) continue;
                for (Object curr : values) {
                    this.addObject(newAxis, curr);
                }
            }
        }
    }

    protected void fillChildrenForTreeFillingConfiguration(ITreeItemAxis axis) {
        Object tmp = axis.getElement();
        Assert.isTrue((boolean)(tmp instanceof TreeFillingConfiguration));
        TreeFillingConfiguration conf = (TreeFillingConfiguration)tmp;
        ITreeItemAxis parent = axis.getParent();
        int nextDepth = conf.getDepth();
        Object context = null;
        context = parent != null ? parent.getElement() : this.getTableContext();
        Collection<?> values = this.getFilteredValueAsCollection(conf, context, nextDepth);
        for (Object value : values) {
            this.addObject(axis, value);
        }
    }

    public void fillListWithGrandSon(ITreeItemAxis element) {
        Object context = element.getElement();
        if (context instanceof TreeFillingConfiguration) {
            for (ITreeItemAxis child : element.getChildren()) {
                this.fillChildrenForSemanticElement(child);
            }
            return;
        }
        for (ITreeItemAxis child : element.getChildren()) {
            this.fillChildrenForTreeFillingConfiguration(child);
        }
    }

    @Override
    public void fillListWithRoots() {
        if (!FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.tableManager.getTable(), this.representedAxisManager, 0)) {
            for (IAxis current : this.getRepresentedContentProvider().getAxis()) {
                if (!(current instanceof ITreeItemAxis)) continue;
                Assert.isTrue((!(current.getElement() instanceof TreeFillingConfiguration) ? 1 : 0) != 0);
                ITreeItemAxisHelper.linkITreeItemAxisToSemanticElement(this.managedElements, (ITreeItemAxis)current);
                this.fillChildrenForSemanticElement((ITreeItemAxis)current);
            }
            return;
        }
        this.fillChildrenForSemanticElement(null);
    }

    @Deprecated
    protected final Collection<?> getCellValueAsCollection(Object iaxis, Object rowElement) {
        return CellManagerFactory.INSTANCE.getCrossValueAsCollection(iaxis, rowElement, this.tableManager);
    }

    protected int getDepth(ITreeItemAxis axis) {
        NattableModelManager manager = this.getTableManager();
        if (manager instanceof ITreeNattableModelManager) {
            return ((ITreeNattableModelManager)((Object)manager)).getTreeItemDepth(axis);
        }
        return 0;
    }

    protected final Collection<?> getFilteredValueAsCollection(TreeFillingConfiguration conf, Object rowElement, int depth) {
        Collection<?> values = CellManagerFactory.INSTANCE.getCrossValueAsCollection(conf.getAxisUsedAsAxisProvider(), rowElement, this.getTableManager());
        ArrayList returnedValues = new ArrayList();
        Object parent = AxisUtils.getRepresentedElement(rowElement);
        for (Object current : values) {
            if (!this.isAllowedContents(current, parent, conf, depth)) continue;
            returnedValues.add(current);
        }
        return returnedValues;
    }

    public final int getSemanticDepth(ITreeItemAxis axis) {
        NattableModelManager manager = this.getTableManager();
        if (manager instanceof ITreeNattableModelManager) {
            return ((ITreeNattableModelManager)((Object)manager)).getSemanticDepth(axis);
        }
        return 0;
    }

    protected Table getTable() {
        return this.tableManager.getTable();
    }

    @Override
    protected void initializeManagedObjectList() {
    }

    @Override
    @Deprecated
    public boolean isAllowedContents(Object object) {
        return super.isAllowedContents(object);
    }

    @Override
    public boolean isAlreadyManaged(Object object) {
        if (this.managedElements.containsKey(object)) {
            for (ITreeItemAxis current : this.managedElements.get(object)) {
                if (current.eContainer() == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public boolean isSlave() {
        return false;
    }

    protected final void removeObject(ITreeItemAxis axis) {
        Command cmd;
        if (axis != null && (cmd = this.getRemoveAxisCommand(axis)) != null && cmd.canExecute()) {
            try {
                GMFUnsafe.write((TransactionalEditingDomain)this.getTableEditingDomain(), (Command)cmd);
            }
            catch (InterruptedException e) {
                Activator.log.error((Throwable)e);
            }
            catch (RollbackException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    private final Command getRemoveAxisCommand(final ITreeItemAxis axis) {
        CompoundCommand cc = new CompoundCommand();
        if (axis != null) {
            ArrayList children = new ArrayList(axis.getChildren());
            for (ITreeItemAxis current : children) {
                cc.append(this.getRemoveAxisCommand(current));
            }
            final ITreeItemAxis parentAxis = axis.getParent();
            AbstractCommand ac = new AbstractCommand(){
                private Command removeParentCommand = null;

                public void redo() {
                    this.execute();
                }

                public void undo() {
                    TransactionalEditingDomain tableEditingDomain;
                    if (this.removeParentCommand != null) {
                        this.removeParentCommand.undo();
                    }
                    if ((tableEditingDomain = AbstractTreeAxisManagerForEventList.this.getTableEditingDomain()) != null) {
                        try {
                            GMFUnsafe.write((TransactionalEditingDomain)tableEditingDomain, (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    axis.setParent(parentAxis);
                                }
                            });
                        }
                        catch (InterruptedException e) {
                            Activator.log.error((Throwable)e);
                        }
                        catch (RollbackException e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                    ITreeItemAxisHelper.linkITreeItemAxisToSemanticElement(AbstractTreeAxisManagerForEventList.this.managedElements, axis);
                    if (axis.isExpanded()) {
                        AbstractTreeAxisManagerForEventList.this.alreadyExpanded.add(axis);
                    }
                    EventListHelper.addToEventList((EventList<Object>)AbstractTreeAxisManagerForEventList.this.eventList, axis);
                }

                public void execute() {
                    Object representedElement;
                    EventListHelper.removeFromEventList((EventList<Object>)AbstractTreeAxisManagerForEventList.this.eventList, axis);
                    AbstractTreeAxisManagerForEventList.this.alreadyExpanded.remove(axis);
                    ITreeItemAxisHelper.unlinkITreeItemAxisToSemanticElement(AbstractTreeAxisManagerForEventList.this.managedElements, axis);
                    TransactionalEditingDomain tableEditingDomain = AbstractTreeAxisManagerForEventList.this.getTableEditingDomain();
                    if (tableEditingDomain != null) {
                        ITreeItemAxisHelper.destroyITreeItemAxis(tableEditingDomain, axis);
                    }
                    if (parentAxis != null && (representedElement = parentAxis.getElement()) instanceof TreeFillingConfiguration && parentAxis.getChildren().size() == 0) {
                        this.removeParentCommand = AbstractTreeAxisManagerForEventList.this.getRemoveAxisCommand(parentAxis);
                        if (this.removeParentCommand != null && this.removeParentCommand.canExecute()) {
                            this.removeParentCommand.execute();
                        }
                    }
                }

                protected boolean prepare() {
                    return true;
                }
            };
            if (ac.canExecute()) {
                cc.append((Command)ac);
            }
        }
        return cc;
    }

    @Override
    public void setExpanded(ITreeItemAxis element, List<ITreeItemAxis> path, boolean expanded) {
        if (!expanded) {
            return;
        }
        if (!this.alreadyExpanded.contains(element)) {
            this.fillListWithGrandSon(element);
            this.alreadyExpanded.add(element);
        }
    }

    protected void updateManagedList(List<Object> toAdd, List<Object> toRemove) {
    }

    @Override
    protected boolean ignoreEvent(Notification notification) {
        boolean res = super.ignoreEvent(notification);
        if (res) {
            return res;
        }
        Object feature = notification.getFeature();
        if (feature instanceof EStructuralFeature) {
            if (feature == NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis()) {
                return false;
            }
            EObject parent = ((EStructuralFeature)feature).eContainer();
            while (parent.eContainer() != null) {
                parent = parent.eContainer();
            }
            return parent == NattablePackage.eINSTANCE;
        }
        return false;
    }

    @Override
    public void fillListWithChildren(ITreeItemAxis parentAxis) {
        Object element = parentAxis.getElement();
        if (element instanceof TreeFillingConfiguration) {
            this.fillChildrenForTreeFillingConfiguration(parentAxis);
            return;
        }
        this.fillChildrenForSemanticElement(parentAxis);
    }

    @Override
    protected void manageSetNotification(Notification notification) {
        this.manageAddNotification(notification);
        this.manageRemoveNotification(notification);
    }

    @Override
    protected void manageUnsetNotification(Notification notification) {
        this.manageRemoveNotification(notification);
        this.manageAddNotification(notification);
    }

    protected boolean isProvidedByTreeFillingConfiguration(Object toTest, TreeFillingConfiguration conf, Object semanticParent) {
        Collection<?> values = this.getFilteredValueAsCollection(conf, semanticParent, conf.getDepth());
        return values.contains(toTest);
    }

    public static final ITreeItemAxis getITreeItemAxisRepresentingObject(Collection<ITreeItemAxis> possibleRepresentation, Object object) {
        for (ITreeItemAxis axis : possibleRepresentation) {
            if (axis.getElement() != object) continue;
            return axis;
        }
        return null;
    }

    protected void manageAddITreeItemAxisForSemanticElement(ITreeItemAxis axis) {
        Assert.isTrue((!(axis.getElement() instanceof TreeFillingConfiguration) ? 1 : 0) != 0);
        ITreeItemAxisHelper.linkITreeItemAxisToSemanticElement(this.managedElements, axis);
        this.fillListWithChildren(axis);
    }

    @Override
    protected void manageAddNotification(Notification notification) {
        Object notifier = notification.getNotifier();
        Object newValue = notification.getNewValue();
        Object feature = notification.getFeature();
        if (feature == NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis() && newValue instanceof ITreeItemAxis && ((ITreeItemAxis)newValue).getElement() instanceof EObject) {
            this.manageAddITreeItemAxisForSemanticElement((ITreeItemAxis)newValue);
            return;
        }
        if (notifier == this.getTableContext() && FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.getTable(), 0)) {
            for (TreeFillingConfiguration current : FillingConfigurationUtils.getTreeFillingConfigurationForDepth(this.getTable(), this.representedAxisManager, 0)) {
                if (!this.isProvidedByTreeFillingConfiguration(newValue, current, notifier)) continue;
                Set<ITreeItemAxis> parentRepresentation = this.managedElements.get(current);
                Assert.isTrue((parentRepresentation == null || parentRepresentation.size() == 1 ? 1 : 0) != 0);
                ITreeItemAxis parentConf = null;
                parentConf = parentRepresentation == null ? this.addObject(null, current) : parentRepresentation.iterator().next();
                if (this.managedElements.containsKey(newValue)) continue;
                this.addObject(parentConf, newValue);
            }
            return;
        }
        if (this.managedElements.containsKey(notifier) && !this.managedElements.containsKey(newValue)) {
            Set<ITreeItemAxis> itemAxisRepresentations = this.managedElements.get(notifier);
            for (ITreeItemAxis curr : itemAxisRepresentations) {
                if (curr.getParent() != null && !this.alreadyExpanded.contains(curr.getParent())) continue;
                int nextDepth = this.getSemanticDepth(curr) + 1;
                if (!FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.getTable(), this.representedAxisManager, nextDepth)) continue;
                for (TreeFillingConfiguration conf : FillingConfigurationUtils.getTreeFillingConfigurationForDepth(this.getTable(), this.representedAxisManager, nextDepth)) {
                    if (!this.isProvidedByTreeFillingConfiguration(newValue, conf, notifier)) continue;
                    ITreeItemAxis confRep = AbstractTreeAxisManagerForEventList.getITreeItemAxisRepresentingObject((Collection<ITreeItemAxis>)curr.getChildren(), conf);
                    if (confRep == null) {
                        confRep = this.addObject(curr, conf);
                    }
                    if (!this.alreadyExpanded.contains(curr)) continue;
                    this.addObject(confRep, newValue);
                }
            }
        }
    }

    @Override
    protected void manageAddManyNotification(Notification notification) {
        Object tmpValues = notification.getNewValue();
        if (!(tmpValues instanceof Collection)) {
            return;
        }
        Collection values = (Collection)tmpValues;
        Object notifier = notification.getNotifier();
        Object feature = notification.getFeature();
        if (feature == NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis()) {
            for (Object value : values) {
                if (!(value instanceof ITreeItemAxis) || ((ITreeItemAxis)value).getElement() instanceof ITreeItemAxis) continue;
                this.manageAddITreeItemAxisForSemanticElement((ITreeItemAxis)value);
            }
            return;
        }
        if (notifier == this.getTableContext() && FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.getTable(), 0)) {
            for (TreeFillingConfiguration current : FillingConfigurationUtils.getTreeFillingConfigurationForDepth(this.getTable(), this.representedAxisManager, 0)) {
                Collection<?> rows = this.getFilteredValueAsCollection(current, notifier, 0);
                values.retainAll(rows);
                if (values.size() <= 0) continue;
                Set<ITreeItemAxis> parentRepresentation = this.managedElements.get(current);
                Assert.isTrue((parentRepresentation == null || parentRepresentation.size() == 1 ? 1 : 0) != 0);
                ITreeItemAxis confRep = parentRepresentation == null ? this.addObject(null, current) : parentRepresentation.iterator().next();
                for (Object currVal : values) {
                    this.addObject(confRep, currVal);
                }
            }
            return;
        }
        if (!this.managedElements.containsKey(notifier)) {
            return;
        }
        Set<ITreeItemAxis> itemAxisRepresentations = this.managedElements.get(notifier);
        for (ITreeItemAxis curr : itemAxisRepresentations) {
            if (curr.getParent() != null && !this.alreadyExpanded.contains(curr.getParent())) continue;
            int nextDepth = this.getSemanticDepth(curr) + 1;
            for (Object newValue : values) {
                if (!FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.getTable(), this.representedAxisManager, nextDepth)) continue;
                for (TreeFillingConfiguration conf : FillingConfigurationUtils.getTreeFillingConfigurationForDepth(this.getTable(), this.representedAxisManager, nextDepth)) {
                    if (!this.isProvidedByTreeFillingConfiguration(newValue, conf, notifier)) continue;
                    ITreeItemAxis confRep = AbstractTreeAxisManagerForEventList.getITreeItemAxisRepresentingObject((Collection<ITreeItemAxis>)curr.getChildren(), conf);
                    if (confRep == null) {
                        confRep = this.addObject(curr, conf);
                    }
                    if (!this.alreadyExpanded.contains(curr)) continue;
                    this.addObject(confRep, newValue);
                }
            }
        }
    }

    @Override
    protected void manageMoveNotification(Notification notification) {
    }

    protected void manageRemoveITreeItemAxisForSemanticElement(ITreeItemAxis axis) {
        Assert.isTrue((!(axis.getElement() instanceof TreeFillingConfiguration) ? 1 : 0) != 0);
        this.removeObject(axis);
    }

    @Override
    protected void manageRemoveNotification(Notification notification) {
        Object oldValue = notification.getOldValue();
        if (oldValue instanceof ITreeItemAxis && !(((IAxis)oldValue).getElement() instanceof TreeFillingConfiguration)) {
            this.removeObject((ITreeItemAxis)oldValue);
            return;
        }
        this.manageRemoveSemanticElement(oldValue);
    }

    protected void manageRemoveSemanticElement(Object object) {
        Assert.isTrue((!(object instanceof ITreeItemAxis) ? 1 : 0) != 0);
        Assert.isTrue((!(object instanceof TreeFillingConfiguration) ? 1 : 0) != 0);
        CompoundCommand cc = new CompoundCommand();
        if (this.managedElements.containsKey(object)) {
            ArrayList itemAxisRepresentations = new ArrayList(this.managedElements.get(object));
            for (ITreeItemAxis current : itemAxisRepresentations) {
                ITreeItemAxis parent = current.getParent();
                if (parent == null) continue;
                TreeFillingConfiguration conf = (TreeFillingConfiguration)parent.getElement();
                ITreeItemAxis greatParent = parent.getParent();
                Object context = greatParent == null ? this.getTableContext() : greatParent.getElement();
                Collection<?> values = this.getCellValueAsCollection(conf.getAxisUsedAsAxisProvider(), context);
                if (values.contains(object)) continue;
                cc.append(this.getRemoveAxisCommand(current));
            }
        }
        try {
            GMFUnsafe.write((TransactionalEditingDomain)this.getTableEditingDomain(), (Command)cc);
        }
        catch (InterruptedException e) {
            Activator.log.error((Throwable)e);
        }
        catch (RollbackException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    protected void manageRemoveManyNotification(Notification notification) {
        Object tmpOldValues = notification.getOldValue();
        if (!(tmpOldValues instanceof Collection)) {
            return;
        }
        Collection oldValues = (Collection)tmpOldValues;
        Object feature = notification.getFeature();
        if (feature == NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis()) {
            for (Object value : oldValues) {
                if (!(value instanceof ITreeItemAxis) || ((ITreeItemAxis)value).getElement() instanceof ITreeItemAxis) continue;
                this.manageRemoveITreeItemAxisForSemanticElement((ITreeItemAxis)value);
            }
            return;
        }
        for (Object val : oldValues) {
            this.manageRemoveSemanticElement(val);
        }
    }

    @Override
    public boolean canDestroyAxisElement(Integer axisIndex) {
        return false;
    }

    @Override
    public Command getDestroyAxisElementCommand(TransactionalEditingDomain domain, Integer axisPosition) {
        return null;
    }

    protected void updateChildren(ITreeItemAxis semanticElementRepresentation) {
        Assert.isTrue((semanticElementRepresentation == null || !(semanticElementRepresentation.getElement() instanceof TreeFillingConfiguration) ? 1 : 0) != 0);
        ITreeItemAxis current = semanticElementRepresentation;
        if (current == null || current.getParent() != null && this.alreadyExpanded.contains(current.getParent())) {
            Object context;
            int nextDepth;
            if (semanticElementRepresentation == null) {
                nextDepth = 0;
                context = this.getTableContext();
            } else {
                nextDepth = this.getSemanticDepth(semanticElementRepresentation) + 1;
                context = semanticElementRepresentation.getElement();
            }
            List<TreeFillingConfiguration> confs = FillingConfigurationUtils.getTreeFillingConfigurationForDepth(this.getTable(), this.representedAxisManager, nextDepth);
            for (TreeFillingConfiguration conf : confs) {
                ITreeItemAxis confRep = null;
                if (current != null) {
                    confRep = AbstractTreeAxisManagerForEventList.getITreeItemAxisRepresentingObject((Collection<ITreeItemAxis>)current.getChildren(), conf);
                } else if (nextDepth == 0 && this.managedElements.containsKey(conf)) {
                    confRep = this.managedElements.get(conf).iterator().next();
                }
                Collection<?> values = this.getFilteredValueAsCollection(conf, context, nextDepth);
                HashSet<Object> knownElements = new HashSet<Object>();
                ArrayList<ITreeItemAxis> toRemove = new ArrayList<ITreeItemAxis>();
                if (confRep != null) {
                    ArrayList children = new ArrayList(confRep.getChildren());
                    for (ITreeItemAxis child : children) {
                        Object tmp = child.getElement();
                        if (!values.contains(tmp)) {
                            toRemove.add(child);
                        }
                        knownElements.add(child.getElement());
                    }
                    if (this.alreadyExpanded.contains(current)) {
                        for (Object val : values) {
                            if (knownElements.contains(val)) continue;
                            this.addObject(confRep, val);
                        }
                    }
                    for (ITreeItemAxis axis : toRemove) {
                        this.removeObject(axis);
                    }
                    continue;
                }
                if (values.isEmpty()) continue;
                confRep = this.addObject(current, conf);
                if (!this.alreadyExpanded.contains(current) && current != null) continue;
                for (Object val : values) {
                    this.addObject(confRep, val);
                }
            }
        }
    }

    protected void updateSemanticElement(Object semanticElement) {
        if (FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.getTable(), this.representedAxisManager, 0)) {
            this.updateChildren(null);
        }
        if (this.managedElements.containsKey(semanticElement)) {
            for (ITreeItemAxis sementicItemRep : this.managedElements.get(semanticElement)) {
                this.updateChildren(sementicItemRep);
            }
        }
    }

    @Override
    public void managedHideShowCategoriesForDepth(List<Integer> depthToHide, List<Integer> depthToShow) {
        this.hideCategories(depthToHide);
        this.showCategoriesForDepth(depthToShow);
    }

    protected void hideCategories(List<Integer> depthToHide) {
        if (depthToHide == null || depthToHide.isEmpty()) {
            return;
        }
        RowHideShowLayer rowHideLayer = this.getRowHideShowLayer();
        if (rowHideLayer == null) {
            return;
        }
        NatTable natTable = (NatTable)this.getTableManager().getAdapter(NatTable.class);
        if (natTable == null) {
            return;
        }
        if (depthToHide != null && depthToHide.size() > 0) {
            TreeSet<Integer> indexesToHide = new TreeSet<Integer>();
            for (Integer curr : depthToHide) {
                List<TreeFillingConfiguration> fillingConf = FillingConfigurationUtils.getTreeFillingConfigurationForDepth(this.getTable(), this.representedAxisManager, curr);
                for (TreeFillingConfiguration treeFillingConfiguration : fillingConf) {
                    if (!this.managedElements.containsKey(treeFillingConfiguration)) continue;
                    for (ITreeItemAxis axis : this.managedElements.get(treeFillingConfiguration)) {
                        int index = this.getTableManager().getRowElementsList().indexOf(axis);
                        ITreeItemAxis parentAxis = axis.getParent();
                        if (parentAxis != null && parentAxis.isExpanded() && !axis.isExpanded()) {
                            this.getTreeLayer().expandTreeRow(index);
                            index = this.getTableManager().getRowElementsList().indexOf(axis);
                        } else if (parentAxis == null) {
                            this.getTreeLayer().expandTreeRow(index);
                            index = this.getTableManager().getRowElementsList().indexOf(axis);
                        }
                        if (index == -1) continue;
                        int convertedIndex = rowHideLayer.underlyingToLocalRowPosition((ILayer)natTable, index);
                        indexesToHide.add(convertedIndex);
                    }
                }
            }
            if (indexesToHide.size() > 0) {
                int[] ar = new int[indexesToHide.size()];
                Iterator iter = indexesToHide.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    ar[i] = (Integer)iter.next();
                    ++i;
                }
                natTable.doCommand((ILayerCommand)new MultiRowHideCommand((ILayer)rowHideLayer, ar));
            }
        }
    }

    protected void showCategoriesForDepth(List<Integer> depthToShow) {
        if (depthToShow == null || depthToShow.isEmpty()) {
            return;
        }
        NatTable natTable = (NatTable)this.getTableManager().getAdapter(NatTable.class);
        if (natTable == null) {
            return;
        }
        ArrayList<Integer> indexesToShow = new ArrayList<Integer>();
        for (Integer curr : depthToShow) {
            List<TreeFillingConfiguration> fillingConf = FillingConfigurationUtils.getTreeFillingConfigurationForDepth(this.getTable(), this.representedAxisManager, curr);
            for (TreeFillingConfiguration treeFillingConfiguration : fillingConf) {
                if (!this.managedElements.containsKey(treeFillingConfiguration)) continue;
                for (ITreeItemAxis axis : this.managedElements.get(treeFillingConfiguration)) {
                    indexesToShow.add(this.getTableManager().getRowElementsList().indexOf(axis));
                }
            }
        }
        if (indexesToShow.size() > 0) {
            natTable.doCommand((ILayerCommand)new MultiRowShowCommand(indexesToShow));
        }
    }

    protected final RowHideShowLayer getRowHideShowLayer() {
        if (this.tableManager != null && this.tableManager.getBodyLayerStack() != null) {
            return this.tableManager.getBodyLayerStack().getRowHideShowLayer();
        }
        return null;
    }

    @Override
    public void fillingConfigurationsHaveChanged() {
        List<TreeFillingConfiguration> oldFillingConfiguration = this.currentFillingConfiguration;
        List<TreeFillingConfiguration> newFillingConf = FillingConfigurationUtils.getTreeFillingConfiguration(this.getTable(), this.representedAxisManager);
        this.currentFillingConfiguration = newFillingConf;
        if (oldFillingConfiguration.equals(newFillingConf)) {
            return;
        }
        ArrayList<TreeFillingConfiguration> confToRemove = new ArrayList<TreeFillingConfiguration>(oldFillingConfiguration);
        confToRemove.removeAll(newFillingConf);
        for (TreeFillingConfiguration current : confToRemove) {
            if (!this.managedElements.containsKey(current)) continue;
            HashSet axisRepresentation = new HashSet(this.managedElements.get(current));
            for (ITreeItemAxis tmp : axisRepresentation) {
                this.removeObject(tmp);
            }
        }
        ArrayList<TreeFillingConfiguration> confToAdd = new ArrayList<TreeFillingConfiguration>(newFillingConf);
        confToAdd.removeAll(oldFillingConfiguration);
        if (confToAdd.isEmpty()) {
            return;
        }
        for (TreeFillingConfiguration treeFillingConfiguration : confToAdd) {
            int depth = treeFillingConfiguration.getDepth();
            if (depth == 0) {
                this.updateChildren(null);
                continue;
            }
            for (TreeFillingConfiguration previousConfig : FillingConfigurationUtils.getTreeFillingConfigurationForDepth(this.getTable(), this.representedAxisManager, depth - 1)) {
                if (!this.managedElements.containsKey(previousConfig)) continue;
                for (ITreeItemAxis axis : this.managedElements.get(previousConfig)) {
                    for (ITreeItemAxis child : axis.getChildren()) {
                        this.updateSemanticElement(child.getElement());
                    }
                }
            }
        }
    }
}

