/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.bundles.tests.apireport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.papyrus.bundles.tests.Activator;

public class ReportFixture {
    private static final IPath XML_REPORTS = new Path("apireports/xml");
    private static final IPath HTML_REPORTS = new Path("apireports/html");
    private static final IPath XML_REPORT_FILE = XML_REPORTS.append("api.xml");
    private static final IPath HTML_REPORT_FILE = HTML_REPORTS.append("api.html");
    private final File xmlReportFile;
    private final File htmlReportFile;

    public ReportFixture(IPath baseOutputDir) throws IOException {
        this.xmlReportFile = baseOutputDir.append(XML_REPORT_FILE).toFile();
        this.htmlReportFile = baseOutputDir.append(HTML_REPORT_FILE).toFile();
        this.ensureContents(this.xmlReportFile.getParentFile(), XML_REPORTS);
        this.ensureContents(this.htmlReportFile.getParentFile(), HTML_REPORTS);
    }

    public File getXMLReportFile() {
        return this.xmlReportFile;
    }

    public File getHTMLReportFile() {
        return this.htmlReportFile;
    }

    private void ensureContents(File directory, IPath resourcePath) throws IOException {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        Path base = new Path(directory.getAbsolutePath());
        LinkedList queue = new LinkedList();
        this.enqueueResources(new Path("resources").append(resourcePath).toString(), queue);
        String next = (String)queue.poll();
        while (next != null) {
            URL url;
            this.enqueueResources(next, queue);
            Path path = new Path(next);
            if (!path.hasTrailingSeparator() && (url = Activator.getDefault().getBundle().getEntry(next)) != null) {
                this.copyResource(url, base.append(path.removeFirstSegments(resourcePath.segmentCount() + 1)));
            }
            next = (String)queue.poll();
        }
    }

    private void enqueueResources(String basePath, Queue<? super String> queue) {
        Enumeration entries = Activator.getDefault().getBundle().getEntryPaths(basePath);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                queue.add((String)entries.nextElement());
            }
        }
    }

    private void copyResource(URL source, IPath destination) throws IOException {
        File localFile = destination.toFile();
        if (!localFile.exists()) {
            if (!localFile.getParentFile().exists()) {
                localFile.getParentFile().mkdirs();
            }
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream input = source.openStream();){
                Files.copy(input, Paths.get(localFile.getAbsolutePath(), new String[0]), new CopyOption[0]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

