/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.matchers;

import java.util.function.Predicate;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class CommandMatchers {
    private CommandMatchers() {
    }

    static <C> Matcher<C> executable(final Predicate<? super C> canExecute) {
        return new TypeSafeDiagnosingMatcher<C>(){

            public void describeTo(Description description) {
                description.appendText("executable");
            }

            protected boolean matchesSafely(C item, Description mismatch) {
                boolean result = canExecute.test(item);
                if (!result) {
                    mismatch.appendText("unexecutable");
                }
                return result;
            }
        };
    }

    public static class EMF {
        private EMF() {
        }

        public static Matcher<Command> canExecute() {
            return CommandMatchers.executable(Command::canExecute);
        }
    }

    public static final class GEF {
        private GEF() {
        }

        public static Matcher<org.eclipse.gef.commands.Command> canExecute() {
            return CommandMatchers.executable(org.eclipse.gef.commands.Command::canExecute);
        }
    }

    public static final class GMF {
        private GMF() {
        }

        public static Matcher<ICommand> canExecute() {
            return CommandMatchers.executable(IUndoableOperation::canExecute);
        }
    }
}

