/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.ecore.importer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ModelImporterApplication;
import org.eclipse.uml2.codegen.ecore.genmodel.GenModel;
import org.eclipse.uml2.uml.ecore.importer.UMLImporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLImporterApplication
extends ModelImporterApplication {
    protected boolean pluralizeGetters = false;
    protected boolean safeStrings = false;
    protected boolean cacheAdapterSupport = false;
    protected boolean factoryMethods = false;
    protected String invariantPrefix;
    protected Map<String, PackageInfo> nameToPackageInfo;
    protected Map<String, String> importerOptions = new HashMap<String, String>();

    public UMLImporter getUMLImporter() {
        return (UMLImporter)this.getModelImporter();
    }

    protected ModelImporter createModelImporter() {
        return new UMLImporter();
    }

    protected StringBuffer getUsage() {
        StringBuffer result = new StringBuffer();
        this.appendLine(result, "Usage: { <model.uml> }+ [ <model.genmodel> [ -reload ] ] <OPTIONS>");
        this.appendLine(result, "<OPTIONS>               ::= [ <PROJECT-OPTION> ] [ <PATHMAP> ]");
        this.appendLine(result, "                            { <PACKAGE> }+ { <REF-PACKAGE> }* { <REF-GEN-MODEL> }*");
        this.appendLine(result, "                            [ <TEMPLATE-PATH> ] [ <MODEL-PLUGIN-ID> ] [ <COPYRIGHT> ]");
        this.appendLine(result, "                            [ <SDO> ] [ <QUIET> ] { <IMPORTER-OPTION> }*");
        this.appendLine(result, "                            [ <CACHE-ADAPTER-SUPPORT> ] [ <FACTORY-METHODS> ] [ <PLURALIZE-GETTERS> ]");
        this.appendLine(result, "                            [ <SAFE-STRINGS> ] [ <INVARIANT-PREFIX> ]");
        this.appendLine(result, "<PROJECT-OPTION>        ::= <MODEL-PROJECT> [ <EDIT-PROJECT> ] [ <EDITOR-PROJECT> ]");
        this.appendLine(result, "                            [ <TESTS-PROJECT> ]");
        this.appendLine(result, "<MODEL-PROJECT>         ::= -modelProject <model-directory> <fragment-path>");
        this.appendLine(result, "<EDIT-PROJECT>          ::= -editProject <edit-directory> <fragment-path>");
        this.appendLine(result, "<EDITOR-PROJECT>        ::= -editorProject <editor-directory> <fragment-path>");
        this.appendLine(result, "<TESTS-PROJECT>         ::= -testsProject <tests-directory> <fragment-path>");
        this.appendLine(result, "<PACKAGE>               ::= -package <name> [ <nsPrefix> <nsURI> <base> <prefix> ]");
        this.appendLine(result, "                            [ <operationsPackage> ] [ resourceInterfaces ]");
        this.appendLine(result, "<REF-GEN-MODEL>         ::= -refGenModel <model.genmodel> { <nsURI> }+");
        this.appendLine(result, "<TEMPLATE-PATH>         ::= -templatePath <template-directory>");
        this.appendLine(result, "<MODEL-PLUGIN-ID>       ::= -modelPluginID <plugin-ID>");
        this.appendLine(result, "<COPYRIGHT>             ::= -copyright <copyright-string>");
        this.appendLine(result, "<JDK-LEVEL>             ::= -jdkLevel <jdk level: 1.4 5.0 6.0>");
        this.appendLine(result, "<VALIDATE-MODEL>        ::= -validateModel < true | false >");
        this.appendLine(result, "<SDO>                   ::= -sdo");
        this.appendLine(result, "<QUIET>                 ::= -quiet");
        this.appendLine(result, "<IMPORTER-OPTION>       ::= < -ECORE_TAGGED_VALUES |");
        this.appendLine(result, "                               -REDEFINING_OPERATIONS | -REDEFINING_PROPERTIES |");
        this.appendLine(result, "                               -SUBSETTING_PROPERTIES | -UNION_PROPERTIES | -DERIVED_FEATURES |");
        this.appendLine(result, "                               -DUPLICATE_OPERATIONS | -DUPLICATE_OPERATION_INHERITANCE |");
        this.appendLine(result, "                               -DUPLICATE_FEATURES | -DUPLICATE_FEATURE_INHERITANCE |");
        this.appendLine(result, "                               -SUPER_CLASS_ORDER | -ANNOTATION_DETAILS |");
        this.appendLine(result, "                               -INVARIANT_CONSTRAINTS | -OPERATION_BODIES | -COMMENTS |");
        this.appendLine(result, "                               -CAMEL_CASE_NAMES >");
        this.appendLine(result, "                             < PROCESS | IGNORE | REPORT | DISCARD >");
        this.appendLine(result, "<CACHE-ADAPTER-SUPPORT> ::= -cacheAdapterSupport");
        this.appendLine(result, "<FACTORY-METHODS>       ::= -factoryMethods");
        this.appendLine(result, "<PLURALIZE-GETTERS>     ::= -pluralizeGetters");
        this.appendLine(result, "<SAFE-STRINGS>          ::= -safeStrings");
        this.appendLine(result, "<INVARIANT-PREFIX>      ::= -invariantPrefix <prefix>");
        this.appendLine(result, "");
        this.appendLine(result, "For example:");
        this.appendLine(result, "");
        this.appendLine(result, "");
        this.appendLine(result, "  uml2genmodel");
        this.appendLine(result, "    ../../company/model.uml");
        this.appendLine(result, "    result/model/Extended.genmodel");
        this.appendLine(result, "    -modelProject result src");
        this.appendLine(result, "    -editProject result.edit src");
        this.appendLine(result, "    -editorProject result.editor src");
        this.appendLine(result, "    -refGenModel company.genmodel http://org.sample.company");
        return result;
    }

    protected int processArgument(String[] arguments, int index) {
        if (arguments[index].equalsIgnoreCase("-package")) {
            if (this.nameToPackageInfo == null) {
                this.nameToPackageInfo = new HashMap<String, PackageInfo>();
            }
            index = this.processPackageInformation(arguments, index, this.nameToPackageInfo);
        } else if (this.isImporterOption(arguments[index])) {
            this.importerOptions.put(arguments[index].substring(1), arguments[++index]);
        } else if (arguments[index].equalsIgnoreCase("-pluralizeGetters")) {
            this.pluralizeGetters = true;
        } else if (arguments[index].equalsIgnoreCase("-safeStrings")) {
            this.safeStrings = true;
        } else if (arguments[index].equalsIgnoreCase("-cacheAdapterSupport")) {
            this.cacheAdapterSupport = true;
        } else if (arguments[index].equalsIgnoreCase("-factoryMethods")) {
            this.factoryMethods = true;
        } else if (arguments[index].equalsIgnoreCase("-invariantPrefix")) {
            this.invariantPrefix = arguments[++index];
        } else {
            return super.processArgument(arguments, index);
        }
        return index + 1;
    }

    protected boolean isImporterOption(String key) {
        String strippedKey = key.substring(1);
        return "ECORE_TAGGED_VALUES".equalsIgnoreCase(strippedKey) || "REDEFINING_OPERATIONS".equalsIgnoreCase(strippedKey) || "REDEFINING_PROPERTIES".equalsIgnoreCase(strippedKey) || "SUBSETTING_PROPERTIES".equalsIgnoreCase(strippedKey) || "UNION_PROPERTIES".equalsIgnoreCase(strippedKey) || "DERIVED_FEATURES".equalsIgnoreCase(strippedKey) || "DUPLICATE_OPERATIONS".equalsIgnoreCase(strippedKey) || "DUPLICATE_OPERATION_INHERITANCE".equalsIgnoreCase(strippedKey) || "DUPLICATE_FEATURES".equalsIgnoreCase(strippedKey) || "DUPLICATE_FEATURE_INHERITANCE".equalsIgnoreCase(strippedKey) || "SUPER_CLASS_ORDER".equalsIgnoreCase(strippedKey) || "ANNOTATION_DETAILS".equalsIgnoreCase(strippedKey) || "INVARIANT_CONSTRAINTS".equalsIgnoreCase(strippedKey) || "OPERATION_BODIES".equalsIgnoreCase(strippedKey) || "COMMENTS".equalsIgnoreCase(strippedKey) || "CAMEL_CASE_NAMES".equalsIgnoreCase(strippedKey);
    }

    protected int processPackageInformation(String[] arguments, int index, Map<String, PackageInfo> nameToPackageInfo) {
        int start = index;
        PackageInfo packageInfo = new PackageInfo();
        if (index + 1 < arguments.length && !arguments[index + 1].startsWith("-")) {
            packageInfo.name = arguments[++index];
            if (!(index + 1 >= arguments.length || arguments[index + 1].startsWith("-") || arguments[index + 2].startsWith("-") || arguments[index + 3].startsWith("-"))) {
                packageInfo.nsPrefix = arguments[++index];
                if (index + 1 < arguments.length && !arguments[index + 1].startsWith("-")) {
                    packageInfo.nsURI = arguments[++index];
                    if (index + 1 < arguments.length && !arguments[index + 1].startsWith("-")) {
                        packageInfo.base = arguments[++index];
                        if (index + 1 < arguments.length && !arguments[index + 1].startsWith("-")) {
                            packageInfo.prefix = arguments[++index];
                        }
                    }
                }
            }
            while (index + 1 < arguments.length && !arguments[index + 1].startsWith("-")) {
                if (arguments[++index].equalsIgnoreCase("resourceInterfaces")) {
                    packageInfo.resourceInterfaces = true;
                    break;
                }
                packageInfo.operationsPackage = arguments[index];
            }
            if (index - start == 0 || index - start == 4) {
                throw new IllegalArgumentException("Error: Expecting either 1 - 3 or 5 - 7 arguments for " + arguments[start]);
            }
            nameToPackageInfo.put(packageInfo.name, packageInfo);
            nameToPackageInfo.put(packageInfo.name.toLowerCase(), packageInfo);
            return index;
        }
        throw new IllegalArgumentException("Error: No package name was specified for " + arguments[start]);
    }

    protected void adjustModelImporter(Monitor monitor) {
        try {
            monitor.beginTask("", 2);
            super.adjustModelImporter(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
            UMLImporter umlImporter = this.getUMLImporter();
            if (umlImporter != null) {
                umlImporter.getOptions().putAll(this.importerOptions);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void adjustGenModel(Monitor monitor) {
        try {
            monitor.beginTask("", 2);
            super.adjustGenModel(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
            org.eclipse.emf.codegen.ecore.genmodel.GenModel genModel = this.getUMLImporter().getGenModel();
            if (genModel instanceof GenModel) {
                GenModel uml2GenModel = (GenModel)genModel;
                if (this.pluralizeGetters) {
                    uml2GenModel.setPluralizedGetters(this.pluralizeGetters);
                }
                if (this.safeStrings) {
                    uml2GenModel.setSafeStrings(this.safeStrings);
                }
                if (this.cacheAdapterSupport) {
                    uml2GenModel.setCacheAdapterSupport(this.cacheAdapterSupport);
                }
                if (this.factoryMethods) {
                    uml2GenModel.setFactoryMethods(this.factoryMethods);
                }
                if (this.invariantPrefix != null) {
                    uml2GenModel.setInvariantPrefix(this.invariantPrefix);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void adjustEPackages(Monitor monitor) {
        try {
            monitor.beginTask("", 2);
            super.adjustEPackages(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
            UMLImporter umlImporter = this.getUMLImporter();
            List ePackages = umlImporter.getEPackages();
            this.traverseEPackages(ePackages);
            umlImporter.adjustEPackages(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
        }
        finally {
            monitor.done();
        }
    }

    protected void traverseEPackages(List<EPackage> ePackages) {
        for (EPackage ePackage : ePackages) {
            PackageInfo packageInfo;
            if (this.nameToPackageInfo != null && (packageInfo = this.nameToPackageInfo.get(ePackage.getName())) != null) {
                this.handleEPackage(ePackage, true);
                ModelImporter.EPackageImportInfo ePackageImportInfo = this.getUMLImporter().getEPackageImportInfo(ePackage);
                if (packageInfo.nsPrefix != null) {
                    ePackage.setNsPrefix(packageInfo.nsPrefix);
                }
                if (packageInfo.nsURI != null) {
                    ePackage.setNsURI(packageInfo.nsURI);
                }
                if (ePackageImportInfo.getBasePackage() == null) {
                    ePackageImportInfo.setBasePackage(packageInfo.base);
                }
                if (ePackageImportInfo.getPrefix() == null) {
                    ePackageImportInfo.setPrefix(packageInfo.prefix);
                }
                if (ePackageImportInfo instanceof UMLImporter.EPackageImportInfo) {
                    UMLImporter.EPackageImportInfo umlEPackageImportInfo = (UMLImporter.EPackageImportInfo)ePackageImportInfo;
                    umlEPackageImportInfo.setResourceInterfaces(packageInfo.resourceInterfaces);
                    umlEPackageImportInfo.setOperationsPackage(packageInfo.operationsPackage);
                }
            }
            this.handleQualifiedEPackageName(ePackage);
            this.traverseEPackages((List<EPackage>)ePackage.getESubpackages());
        }
    }

    public static class PackageInfo {
        public String name;
        public String nsPrefix;
        public String nsURI;
        public String base;
        public String prefix;
        public String operationsPackage;
        public boolean resourceInterfaces = false;
    }
}

