/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: RDFTriple.java,v 1.2 2007/03/18 08:39:02 lzhang Exp $
 */

package org.eclipse.eodm.rdf.resource.parser.element;

/**
 * The concrete class of RDF triple.
 */
public class RDFTriple {
    private RDFResourceElement subject = null;

    private URIReference predicate = null;

    private RDFValue object = null;

    /**
     * Construct an RDF Triple(also called statement) with its Subject,
     * Preficate, Object. The default is null.
     */
    public RDFTriple() {
    }

    /**
     * Construct an RDF Triple with the designated Subject, Predicate and
     * Object.
     * 
     * @param subject
     *            the Subject
     * @param predicate
     *            the Predicate
     * @param object
     *            the Object
     */
    public RDFTriple(RDFResourceElement subject, URIReference predicate,
            RDFValue object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    /**
     * Get the Subject
     * 
     * @return the Subject
     */
    public RDFResourceElement getSubject() {
        return subject;
    }

    /**
     * Set the Subject
     * 
     * @param subject
     *            the Subject
     */
    public void setSubject(RDFResourceElement subject) {
        this.subject = subject;
    }

    /**
     * Get the Predicate
     * 
     * @return the Predicate
     */
    public URIReference getPredicate() {
        return predicate;
    }

    /**
     * Set the Predicate
     * 
     * @param predicate
     *            the Predicate
     */
    public void setPredicate(URIReference predicate) {
        this.predicate = predicate;
    }

    /**
     * Get the Object
     * 
     * @return the Object
     */
    public RDFValue getObject() {
        return object;
    }

    /**
     * Set the Object
     * 
     * @param object
     *            the Object
     */
    public void setObject(RDFValue object) {
        this.object = object;
    }

    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("RDFTriple");
        buf.append("{").append(subject);
        buf.append(",").append(predicate);
        buf.append(",").append(object);
        buf.append('}');
        return buf.toString();
    }
}