/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: InternalCore.java,v 1.2 2007/03/18 10:23:39 lzhang Exp $
 */
package org.eclipse.eodm.impl;
import java.util.ArrayList;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.eodm.owl.owlbase.AllValuesFromRestriction;
import org.eclipse.eodm.owl.owlbase.CardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.ComplementClass;
import org.eclipse.eodm.owl.owlbase.EnumeratedClass;
import org.eclipse.eodm.owl.owlbase.HasValueRestriction;
import org.eclipse.eodm.owl.owlbase.Individual;
import org.eclipse.eodm.owl.owlbase.IntersectionClass;
import org.eclipse.eodm.owl.owlbase.MaxCardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction;
import org.eclipse.eodm.owl.owlbase.OWLAllDifferent;
import org.eclipse.eodm.owl.owlbase.OWLAnnotationProperty;
import org.eclipse.eodm.owl.owlbase.OWLDataRange;
import org.eclipse.eodm.owl.owlbase.OWLDatatypeProperty;
import org.eclipse.eodm.owl.owlbase.OWLObjectProperty;
import org.eclipse.eodm.owl.owlbase.OWLOntology;
import org.eclipse.eodm.owl.owlbase.OWLOntologyProperty;
import org.eclipse.eodm.owl.owlbase.SomeValuesFromRestriction;
import org.eclipse.eodm.owl.owlbase.Statement;
import org.eclipse.eodm.owl.owlbase.UnionClass;
import org.eclipse.eodm.rdf.rdfbase.BlankNode;
import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfbase.URIReferenceNode;
import org.eclipse.eodm.rdf.rdfs.RDFAlt;
import org.eclipse.eodm.rdf.rdfs.RDFBag;
import org.eclipse.eodm.rdf.rdfs.RDFList;
import org.eclipse.eodm.rdf.rdfs.RDFSContainerMembershipProperty;
import org.eclipse.eodm.rdf.rdfs.RDFSDatatype;
import org.eclipse.eodm.rdf.rdfs.RDFSeq;




/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Internal Core</b></em>'.
 * <!-- end-user-doc -->
 *
 *
 * @see org.eclipse.eodm.impl.EODMImplPackage#getInternalCore()
 * @model
 * @generated
 */
public interface InternalCore extends BlankNode, ComplementClass, OWLAllDifferent, CardinalityRestriction, MinCardinalityRestriction, SomeValuesFromRestriction, Individual, RDFAlt, RDFSeq, RDFList, OWLAnnotationProperty, OWLDatatypeProperty, OWLOntology, HasValueRestriction, AllValuesFromRestriction, MaxCardinalityRestriction, IntersectionClass, EnumeratedClass, UnionClass, RDFSDatatype, OWLDataRange, Statement, RDFBag, URIReferenceNode, OWLOntologyProperty, RDFSContainerMembershipProperty, OWLObjectProperty {
        /**
         * Return the proxy list of current InternalCore object
         * @return the proxy list of current object
         */ 
	    ArrayList getProxyList();
         /**
          * Add a proxy of the given type to the proxy list of this InternalCore object.
          * @param eclassType the EClass type of the proxy
          * @param classType the class type of the proxy
          * @return the added proxy 
          */
         RDFSResource addProxy(EClass eclassType, Class classType);
         /**
          * Set the URI of the InternalCore Object.
          * @param uri the uri of the InternalCore Object
          */
         void setURI(String uri);
         /**
          * Add the uri of a type to the rdfs:type elist of this InternalCore Object.
          * @param graph the context graph of the InternalCore Object
          * @param uriRef the URI of the type
          */
         public void addType(RDFGraph graph,URIReference uriRef);
} // InternalCore
