/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: MinCardinalityRestriction.java,v 1.1 2007/03/18 08:10:08 lzhang Exp $
 */
package org.eclipse.eodm.owl.owlbase;

import org.eclipse.eodm.rdf.rdfbase.TypedLiteral;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Min Cardinality Restriction</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction#getOWLminCardinality <em>OWLminCardinality</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getMinCardinalityRestriction()
 * @model
 * @generated
 */
public interface MinCardinalityRestriction extends OWLRestriction {
	/**
	 * Returns the value of the '<em><b>OWLminCardinality</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>OW Lmin Cardinality</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>OWLminCardinality</em>' reference.
	 * @see #setOWLminCardinality(TypedLiteral)
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getMinCardinalityRestriction_OWLminCardinality()
	 * @model required="true"
	 * @generated
	 */
	TypedLiteral getOWLminCardinality();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.owl.owlbase.MinCardinalityRestriction#getOWLminCardinality <em>OWLminCardinality</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>OWLminCardinality</em>' reference.
	 * @see #getOWLminCardinality()
	 * @generated
	 */
	void setOWLminCardinality(TypedLiteral value);

} // MinCardinalityRestriction
