/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFBaseFactory.java,v 1.2 2007/03/18 10:23:38 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase.util;

import org.eclipse.emf.ecore.EFactory;
import org.eclipse.eodm.rdf.rdfbase.BlankNode;
import org.eclipse.eodm.rdf.rdfbase.PlainLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFSLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.RDFStatement;
import org.eclipse.eodm.rdf.rdfbase.RDFXMLLiteral;
import org.eclipse.eodm.rdf.rdfbase.TypedLiteral;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfbase.URIReferenceNode;
import org.eclipse.eodm.rdf.rdfbase.UniformResourceIdentifier;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage
 * @generated
 */
public interface RDFBaseFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	RDFBaseFactory eINSTANCE = new org.eclipse.eodm.rdf.rdfbase.impl.RDFBaseFactoryImpl();

	/**
	 * Returns a new object of class '<em>Blank Node</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Blank Node</em>'.
	 * @generated
	 */
	BlankNode createBlankNode();

	/**
	 * Returns a new object of class '<em>RDFS Resource</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>RDFS Resource</em>'.
	 * @generated
	 */
	RDFSResource createRDFSResource();

	/**
	 * Returns a new object of class '<em>Plain Literal</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Plain Literal</em>'.
	 * @generated
	 */
	PlainLiteral createPlainLiteral();

	/**
	 * Returns a new object of class '<em>RDFS Literal</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>RDFS Literal</em>'.
	 * @generated
	 */
	RDFSLiteral createRDFSLiteral();

	/**
	 * Returns a new object of class '<em>URI Reference</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>URI Reference</em>'.
	 * @generated
	 */
	URIReference createURIReference();

	/**
	 * Returns a new object of class '<em>RDF Statement</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>RDF Statement</em>'.
	 * @generated
	 */
	RDFStatement createRDFStatement();

	/**
	 * Returns a new object of class '<em>Uniform Resource Identifier</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Uniform Resource Identifier</em>'.
	 * @generated
	 */
	UniformResourceIdentifier createUniformResourceIdentifier();

	/**
	 * Returns a new object of class '<em>RDFGraph</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>RDFGraph</em>'.
	 * @generated
	 */
	RDFGraph createGraph();

	/**
	 * Returns a new object of class '<em>URI Reference Node</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>URI Reference Node</em>'.
	 * @generated
	 */
	URIReferenceNode createURIReferenceNode();

	/**
	 * Returns a new object of class '<em>Typed Literal</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Typed Literal</em>'.
	 * @generated
	 */
	TypedLiteral createTypedLiteral();

	/**
	 * Returns a new object of class '<em>RDFXML Literal</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>RDFXML Literal</em>'.
	 * @generated
	 */
	RDFXMLLiteral createRDFXMLLiteral();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	RDFBasePackage getrdfbasePackage();

} //RDFBaseFactory
