/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.uml2.diagram.clazz.edit.helpers.DependencyEditHelper;
import org.eclipse.uml2.diagram.clazz.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class DependencyLinkCreateCommand
extends CreateElementCommand {
    private final EObject source;
    private final EObject target;
    private Package container;

    public DependencyLinkCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super((CreateElementRequest)request);
        this.source = source;
        this.target = target;
        if (request.getContainmentFeature() == null) {
            this.setContainmentFeature(UMLPackage.eINSTANCE.getPackage_PackagedElement());
        }
        EObject element = source;
        while (element != null) {
            if (element instanceof Package) {
                this.container = (Package)element;
                super.setElementToEdit((EObject)this.container);
                break;
            }
            element = element.eContainer();
        }
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof NamedElement)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof NamedElement)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canCreateDependency_4002(this.getContainer(), this.getSource(), this.getTarget());
    }

    protected EObject doDefaultElementCreationGen() {
        Dependency newElement = UMLFactory.eINSTANCE.createDependency();
        this.getContainer().getPackagedElements().add((Object)newElement);
        newElement.getClients().add((Object)this.getSource());
        newElement.getSuppliers().add((Object)this.getTarget());
        return newElement;
    }

    protected EObject doDefaultElementCreation() {
        Dependency newElement;
        EClass eClass = (EClass)this.getCreateRequest().getParameter(DependencyEditHelper.PARAMETER_DEPENDENCY_TYPE);
        if (eClass == null) {
            newElement = (Dependency)this.doDefaultElementCreationGen();
        } else {
            EReference containment = this.getContainmentFeature();
            EObject element = this.getElementToEdit();
            if (containment == null || element == null) {
                return null;
            }
            newElement = (Dependency)EMFCoreUtil.create((EObject)element, (EReference)containment, (EClass)eClass);
            if (newElement != null) {
                newElement.getClients().add((Object)this.getSource());
                newElement.getSuppliers().add((Object)this.getTarget());
            }
        }
        return newElement;
    }

    protected EClass getEClassToEdit() {
        return UMLPackage.eINSTANCE.getPackage();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        return super.doExecuteWithResult(monitor, info);
    }

    protected ConfigureRequest createConfigureRequest() {
        ConfigureRequest request = super.createConfigureRequest();
        request.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        request.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        return request;
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected NamedElement getSource() {
        return (NamedElement)this.source;
    }

    protected NamedElement getTarget() {
        return (NamedElement)this.target;
    }

    public Package getContainer() {
        return this.container;
    }
}

