/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.HeadAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.HeadNodeGroup;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class TracedHeadAnalysis
extends HeadAnalysis {
    public static @NonNull List<@NonNull HeadNodeGroup> computeTraceHeadGroupNodes(@NonNull ScheduleManager scheduleManager, @NonNull MappingRegion mappingRegion) {
        TracedHeadAnalysis mappingRegionAnalysis = new TracedHeadAnalysis(mappingRegion);
        Map<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSources = mappingRegionAnalysis.computeTracedTargetFromSources();
        Map<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSourcesClosure = CompilerUtil.computeClosure(targetFromSources);
        Map<@NonNull Node, @NonNull Set<@NonNull Node>> sourceToTargetsClosure = CompilerUtil.computeInverseClosure(targetFromSourcesClosure);
        return mappingRegionAnalysis.computeHeadNodeGroups(targetFromSourcesClosure, sourceToTargetsClosure, null);
    }

    protected TracedHeadAnalysis(@NonNull MappingRegion mappingRegion) {
        super(mappingRegion);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Map<@NonNull Node, @NonNull Set<@NonNull Node>> computeTracedTargetFromSources() {
        HashMap<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSources = new HashMap<Node, Set<Node>>();
        for (Node sourceNode : QVTscheduleUtil.getOwnedNodes((Region)this.mappingRegion)) {
            if (!sourceNode.isPattern() || !sourceNode.isUnconditional()) continue;
            @NonNull Set sources1 = (Set)targetFromSources.get(sourceNode);
            if (sources1 == null) {
                sources1 = Sets.newHashSet((Object[])new Node[]{sourceNode});
                targetFromSources.put(sourceNode, sources1);
            }
            for (NavigableEdge navigationEdge : sourceNode.getNavigableEdges()) {
                Property source2targetProperty = QVTscheduleUtil.getProperty((NavigableEdge)navigationEdge);
                boolean isMany = source2targetProperty.isIsMany();
                Node targetNode = navigationEdge.getEdgeTarget();
                if (isMany && !targetNode.isDataType() || !targetNode.isMatched() || targetNode.isNullLiteral() || targetNode.isConstant()) continue;
                @NonNull Set sources2 = (Set)targetFromSources.get(targetNode);
                if (sources2 == null) {
                    sources2 = Sets.newHashSet((Object[])new Node[]{targetNode});
                    targetFromSources.put(targetNode, sources2);
                }
                sources2.add(sourceNode);
            }
        }
        return targetFromSources;
    }
}

