/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.debug.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOVariable;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class QVTOWatchAction
implements IPartListener,
IWorkbenchWindowActionDelegate,
IEditorActionDelegate {
    private IAction fAction;
    private IWorkbenchPart fTargetPart;
    private IWorkbenchWindow fWindow;
    private Object fSelection;
    private IRegion fRegion;
    private IWorkbenchPart fNewTargetPart = null;
    private IDebugModelPresentation fPresentation;

    private void run() {
        Object selectedObject = this.fSelection;
        if (selectedObject instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)selectedObject;
            Iterator elements = selection.iterator();
            while (elements.hasNext()) {
                try {
                    this.createWatchExpression(((IVariable)elements.next()).getName());
                }
                catch (DebugException e) {
                    QVTODebugCore.log((Throwable)e);
                    return;
                }
            }
            this.showExpressionView();
        } else if (selectedObject instanceof String) {
            this.createWatchExpression((String)selectedObject);
            this.showExpressionView();
        }
    }

    private void showExpressionView() {
        if (this.getTargetPart().getSite().getId().equals("org.eclipse.debug.ui.ExpressionView")) {
            return;
        }
        IWorkbenchPage page = QVTOWatchAction.getActivePage();
        if (page != null) {
            IViewPart part = page.findView("org.eclipse.debug.ui.ExpressionView");
            if (part == null) {
                try {
                    page.showView("org.eclipse.debug.ui.ExpressionView");
                }
                catch (PartInitException e) {
                    this.reportError(e.getStatus().getMessage());
                }
            } else {
                page.bringToTop((IWorkbenchPart)part);
            }
        }
    }

    private void createWatchExpression(String expr) {
        IWatchExpression expression = DebugPlugin.getDefault().getExpressionManager().newWatchExpression(expr);
        DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)expression);
        IAdaptable object = DebugUITools.getDebugContext();
        IDebugElement context = null;
        if (object instanceof IDebugElement) {
            context = (IDebugElement)object;
        } else if (object instanceof ILaunch) {
            context = ((ILaunch)object).getDebugTarget();
        }
        expression.setExpressionContext(context);
    }

    private static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = QVTOWatchAction.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    private void reportError(String message) {
        throw new RuntimeException(message);
    }

    private void disposeDebugModelPresentation() {
        if (this.fPresentation != null) {
            this.fPresentation.dispose();
        }
    }

    private void setWindow(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    private void setNewTargetPart(IWorkbenchPart newTargetPart) {
        this.fNewTargetPart = newTargetPart;
    }

    private void setTargetPart(IWorkbenchPart part) {
        this.fTargetPart = part;
    }

    private void setSelectedObject(Object selection) {
        this.fSelection = selection;
    }

    private IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    private void setAction(IAction action) {
        this.fAction = action;
    }

    private ISelection getTargetSelection() {
        ISelectionProvider provider;
        IWorkbenchPart part = this.getTargetPart();
        if (part != null && (provider = part.getSite().getSelectionProvider()) != null) {
            return provider.getSelection();
        }
        return null;
    }

    private boolean textHasContent(String text) {
        int length;
        if (text != null && (length = text.length()) > 0) {
            int i = 0;
            while (i < length) {
                if (Character.isLetterOrDigit(text.charAt(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private Object resolveSelectedObjectUsingToken(Object selectedObject, ITextSelection ts, IEditorPart editor) {
        ITextEditor textEditor = (ITextEditor)editor;
        IDocument doc = textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        this.fRegion = JavaWordFinder.findWord(doc, ts.getOffset());
        if (this.fRegion != null) {
            try {
                selectedObject = doc.get(this.fRegion.getOffset(), this.fRegion.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return selectedObject;
    }

    private void resolveSelectedObject() {
        Object selectedObject = null;
        this.fRegion = null;
        ISelection selection = this.getTargetSelection();
        if (selection instanceof ITextSelection) {
            IEditorPart editor;
            ITextSelection ts = (ITextSelection)selection;
            String text = ts.getText();
            if (this.textHasContent(text)) {
                selectedObject = text;
                this.fRegion = new Region(ts.getOffset(), ts.getLength());
            } else if (this.getTargetPart() instanceof IEditorPart && (editor = (IEditorPart)this.getTargetPart()) instanceof ITextEditor) {
                selectedObject = this.resolveSelectedObjectUsingToken(selectedObject, ts, editor);
            }
        } else if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            if (this.getTargetPart().getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
                IEditorPart editor = this.getTargetPart().getSite().getPage().getActiveEditor();
                this.setTargetPart((IWorkbenchPart)editor);
                selection = this.getTargetSelection();
                if (selection instanceof ITextSelection) {
                    ITextSelection ts = (ITextSelection)selection;
                    String text = ts.getText();
                    if (this.textHasContent(text)) {
                        selectedObject = text;
                    } else if (editor instanceof ITextEditor) {
                        selectedObject = this.resolveSelectedObjectUsingToken(selectedObject, ts, editor);
                    }
                }
            } else {
                IStructuredSelection ss = (IStructuredSelection)selection;
                Iterator elements = ss.iterator();
                while (elements.hasNext()) {
                    if (elements.next() instanceof QVTOVariable) continue;
                    this.setSelectedObject(null);
                    return;
                }
                selectedObject = ss;
            }
        }
        this.setSelectedObject(selectedObject);
    }

    private void update() {
        if (this.fAction != null) {
            this.resolveSelectedObject();
        }
    }

    public void dispose() {
        this.disposeDebugModelPresentation();
        IWorkbenchWindow win = this.fWindow;
        if (win != null) {
            win.getPartService().removePartListener((IPartListener)this);
        }
    }

    public void init(IWorkbenchWindow window) {
        this.setWindow(window);
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            this.setTargetPart(page.getActivePart());
        }
        window.getPartService().addPartListener((IPartListener)this);
        this.update();
    }

    public void run(IAction action) {
        this.update();
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
    }

    public void partActivated(IWorkbenchPart part) {
        this.setTargetPart(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.getTargetPart()) {
            this.setTargetPart(null);
        }
        if (part == this.fNewTargetPart) {
            this.setNewTargetPart(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setAction(action);
        this.setTargetPart((IWorkbenchPart)targetEditor);
    }

    private static class JavaWordFinder {
        private JavaWordFinder() {
        }

        public static IRegion findWord(IDocument document, int offset) {
            int start = -1;
            int end = -1;
            try {
                char c;
                int pos = offset;
                while (pos >= 0) {
                    c = document.getChar(pos);
                    if (!Character.isJavaIdentifierPart(c)) break;
                    --pos;
                }
                start = pos;
                pos = offset;
                int length = document.getLength();
                while (pos < length) {
                    c = document.getChar(pos);
                    if (!Character.isJavaIdentifierPart(c)) break;
                    ++pos;
                }
                end = pos;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (start > -1 && end > -1) {
                if (start == offset && end == offset) {
                    return new Region(offset, 0);
                }
                if (start == offset) {
                    return new Region(start, end - start);
                }
                return new Region(start + 1, end - start - 1);
            }
            return null;
        }
    }
}

