/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors;

import java.util.ArrayList;
import java.util.Collection;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.CompletionProposalUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.LightweightParserUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionProposal;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors.AbstractCollector;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors.MappingExtrasMappingNameCollector;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColonColonCollector
extends AbstractCollector {
    @Override
    protected boolean isApplicableInternal(QvtCompletionData data) {
        IToken leftToken = data.getLeftToken();
        return leftToken.getKind() == 65;
    }

    @Override
    public void addPropoposals(Collection<ICompletionProposal> proposals, QvtCompletionData data) {
        IToken prevToken;
        ModelType modelType;
        IToken leftToken = data.getLeftToken();
        IPrsStream prsStream = data.getPrsStream();
        ArrayList<String> pathName = new ArrayList<String>();
        IToken pathNameFirstToken = leftToken;
        int i = leftToken.getTokenIndex();
        while (i >= 1) {
            IToken name;
            IToken colonColon = prsStream.getTokenAt(i);
            if (colonColon.getKind() != 65) break;
            pathNameFirstToken = name = prsStream.getTokenAt(i - 1);
            pathName.add(0, name.toString());
            i -= 2;
        }
        QvtOperationalEnv env = data.getEnvironment();
        if (pathName.size() == 1 && (modelType = env.getModelType((String)pathName.get(0))) != null) {
            EList metamodels = modelType.getMetamodel();
            for (EPackage pack : metamodels) {
                QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal(pack.getName(), "cat-package", data);
                CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
            }
            for (EPackage pack : metamodels) {
                CompletionProposalUtil.addPackageContentsProposals(proposals, data, pack);
            }
            return;
        }
        EPackage pack = env.lookupPackage(pathName);
        if (pack != null) {
            CompletionProposalUtil.addPackageContentsProposals(proposals, data, pack);
            return;
        }
        EClassifier classifier = env.lookupClassifier(pathName);
        if (classifier instanceof EEnum) {
            EEnum eEnum = (EEnum)classifier;
            for (EEnumLiteral enumLiteral : eEnum.getELiterals()) {
                QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal(enumLiteral.getName(), "cat-enum-literal", data);
                CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
            }
        }
        if (classifier != null && (prevToken = LightweightParserUtil.getPreviousToken(pathNameFirstToken)) != null) {
            IToken resolveToken;
            if (QvtCompletionData.isKindOf(prevToken, 2) && (resolveToken = LightweightParserUtil.getPreviousToken(prevToken)) != null && QvtCompletionData.isKindOf(resolveToken, LightweightParserUtil.RESOLVE_FAMILY_TERMINALS)) {
                CompletionProposalUtil.addAllMappingNamesProposals(proposals, data, classifier, false, true);
            }
            if (MappingExtrasMappingNameCollector.isCollectorApplicable(prevToken)) {
                CompletionProposalUtil.addAllMappingNamesProposals(proposals, data, classifier, false, false);
            }
        }
    }
}

