/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.CommentScanner;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.NonRuleBasedDamagerRepairer;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtAnnotationHover;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtDocumentProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtDoubleClickStrategy;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtIndentAutoEditStrategy;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtReconciler;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtReconcilingStrategy;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtScanner;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.IQVTColors;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.QVTColorManager;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionProcessor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hovers.QvtTextHover;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.QvtHyperlinkDetector;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;

public class QvtConfiguration
extends TextSourceViewerConfiguration {
    private QvtDoubleClickStrategy doubleClickStrategy;
    private QvtScanner scanner;
    private QVTColorManager myColorManager;
    private ContentAssistant myContentAssistant;
    private ITextEditor myEditor;
    private static final int ASSIST_AUTO_ACTIVATION_DELAY = 200;
    private static final int RECONCILER_DELAY = 500;

    public QvtConfiguration(ITextEditor editor, QVTColorManager colorManager, IPreferenceStore store) {
        super(store);
        if (colorManager == null || store == null) {
            throw new IllegalArgumentException();
        }
        this.myColorManager = colorManager;
        this.myEditor = editor;
    }

    public QvtConfiguration(QVTColorManager colorManager, IPreferenceStore store) {
        this(null, colorManager, store);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__qvt_documentation", "__qvt_sl_comment", "__qvt_ml_comment", "__qvt_string"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new QvtDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected QvtScanner getQvtScanner() {
        if (this.scanner == null) {
            this.scanner = new QvtScanner(this.myColorManager);
            this.scanner.setDefaultReturnToken((IToken)this.myColorManager.getColor(IQVTColors.DEFAULT).createToken());
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        QVTPresentationReconciler reconciler = new QVTPresentationReconciler();
        reconciler.setDocumentPartitioning("__qvt_partitioning");
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getQvtScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer slCommentRepairer = new NonRuleBasedDamagerRepairer((IToken)this.myColorManager.getColor(IQVTColors.LINE_COMMENT).createToken());
        reconciler.setDamager(slCommentRepairer, "__qvt_sl_comment");
        reconciler.setRepairer(slCommentRepairer, "__qvt_sl_comment");
        NonRuleBasedDamagerRepairer mlCommentRepairer = new NonRuleBasedDamagerRepairer((IToken)this.myColorManager.getColor(IQVTColors.MULTILINE_COMMENT).createToken());
        reconciler.setDamager(mlCommentRepairer, "__qvt_ml_comment");
        reconciler.setRepairer(mlCommentRepairer, "__qvt_ml_comment");
        DefaultDamagerRepairer d = new DefaultDamagerRepairer((ITokenScanner)new CommentScanner(this.myColorManager, IQVTColors.MULTILINE_COMMENT));
        reconciler.setDamager((IPresentationDamager)d, "__qvt_ml_comment");
        reconciler.setRepairer((IPresentationRepairer)d, "__qvt_ml_comment");
        d = new DefaultDamagerRepairer((ITokenScanner)new CommentScanner(this.myColorManager, IQVTColors.MULTILINE_COMMENT));
        reconciler.setDamager((IPresentationDamager)d, "__qvt_sl_comment");
        reconciler.setRepairer((IPresentationRepairer)d, "__qvt_sl_comment");
        NonRuleBasedDamagerRepairer docRepairer = new NonRuleBasedDamagerRepairer((IToken)this.myColorManager.getColor(IQVTColors.DOC_OTHERS).createToken());
        reconciler.setDamager(docRepairer, "__qvt_documentation");
        reconciler.setRepairer(docRepairer, "__qvt_documentation");
        d = new DefaultDamagerRepairer((ITokenScanner)new CommentScanner(this.myColorManager, IQVTColors.DOC_OTHERS));
        reconciler.setDamager((IPresentationDamager)d, "__qvt_documentation");
        reconciler.setRepairer((IPresentationRepairer)d, "__qvt_documentation");
        NonRuleBasedDamagerRepairer stringRepairer = new NonRuleBasedDamagerRepairer((IToken)this.myColorManager.getColor(IQVTColors.STRING).createToken());
        reconciler.setDamager(stringRepairer, "__qvt_string");
        reconciler.setRepairer(stringRepairer, "__qvt_string");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (!this.isQVTDocProvidereditorAvailable()) {
            return null;
        }
        this.myContentAssistant = new ContentAssistant();
        QvtCompletionProcessor processor = new QvtCompletionProcessor(this.myEditor, sourceViewer, this.myContentAssistant);
        this.myContentAssistant.setRestoreCompletionProposalSize(this.getSettings("completion_proposal_size"));
        this.myContentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        this.myContentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__qvt_string");
        this.myContentAssistant.setDocumentPartitioning("__qvt_partitioning");
        this.myContentAssistant.enableAutoInsert(true);
        this.myContentAssistant.enableAutoActivation(true);
        this.myContentAssistant.setAutoActivationDelay(200);
        this.myContentAssistant.setProposalPopupOrientation(10);
        this.myContentAssistant.setContextInformationPopupOrientation(20);
        this.myContentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        this.myContentAssistant.setProposalSelectorBackground(Display.getDefault().getSystemColor(1));
        return this.myContentAssistant;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.myEditor == null) {
            return null;
        }
        QvtReconcilingStrategy strategy = new QvtReconcilingStrategy(this.myEditor);
        QvtReconciler reconciler = new QvtReconciler(this.myEditor, strategy, false);
        reconciler.setDelay(500);
        return reconciler;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new QvtIndentAutoEditStrategy()};
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new QvtAnnotationHover();
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (!this.isQVTDocProvidereditorAvailable()) {
            return null;
        }
        return new QvtTextHover((QvtDocumentProvider)this.myEditor.getDocumentProvider());
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (!this.isQVTDocProvidereditorAvailable()) {
            return null;
        }
        ArrayList<QvtHyperlinkDetector> detectors = new ArrayList<QvtHyperlinkDetector>();
        detectors.add(new QvtHyperlinkDetector((QvtDocumentProvider)this.myEditor.getDocumentProvider()));
        return detectors.toArray(new IHyperlinkDetector[detectors.size()]);
    }

    private IDialogSettings getSettings(String sectionName) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    private boolean isQVTDocProvidereditorAvailable() {
        return this.myEditor != null && this.myEditor.getDocumentProvider() instanceof QvtDocumentProvider;
    }

    public static final class QVTPresentationReconciler
    extends PresentationReconciler {
        private IDocument fLastDocument;

        private QVTPresentationReconciler() {
        }

        public TextPresentation createRepairDescription(IRegion damage, IDocument document) {
            if (document != this.fLastDocument) {
                this.setDocumentToDamagers(document);
                this.setDocumentToRepairers(document);
                this.fLastDocument = document;
            }
            return this.createPresentation(damage, document);
        }
    }
}

