/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.imports;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.documentation.IJavaDocTypeReferenceProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.imports.ImportsAcceptor;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.services.XbaseGrammarAccess;

public class ImportsCollector {
    @Inject
    private XbaseGrammarAccess grammarAccess;
    @Inject
    private IJavaDocTypeReferenceProvider javaDocTypeReferenceProvider;
    @Inject
    private IScopeProvider scopeProvider;

    public void collectImports(XtextResource state, ITextRegion selectedRegion, ImportsAcceptor acceptor) {
        IParseResult _parseResult = state.getParseResult();
        ICompositeNode rootNode = _parseResult.getRootNode();
        EObject selectedSemanticObj = this.findActualSemanticObjectFor(rootNode, selectedRegion);
        ICompositeNode _findActualNodeFor = NodeModelUtils.findActualNodeFor((EObject)selectedSemanticObj);
        Iterable contentsIterator = _findActualNodeFor.getLeafNodes();
        for (ILeafNode node : contentsIterator) {
            ITextRegion nodeRegion = node.getTotalTextRegion();
            boolean _contains = selectedRegion.contains(nodeRegion);
            if (_contains) {
                boolean _notEquals;
                EObject semanticElement = node.getSemanticElement();
                boolean bl = _notEquals = !Objects.equal((Object)semanticElement, null);
                if (_notEquals) {
                    ICompositeNode _findActualNodeFor_1 = NodeModelUtils.findActualNodeFor((EObject)semanticElement);
                    this.visit(semanticElement, (INode)_findActualNodeFor_1, acceptor);
                }
            }
            if (!node.isHidden() || !this.grammarAccess.getML_COMMENTRule().equals(node.getGrammarElement())) continue;
            this.addJavaDocReferences((INode)node, selectedRegion, acceptor);
        }
    }

    public EObject findActualSemanticObjectFor(ICompositeNode rootNode, ITextRegion textRegion) {
        int _offset = textRegion.getOffset();
        ILeafNode leafNodeAtOffset = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)_offset);
        EObject semanticElementOffset = leafNodeAtOffset.getSemanticElement();
        ICompositeNode actualOffsetNode = NodeModelUtils.findActualNodeFor((EObject)semanticElementOffset);
        int _offset_1 = textRegion.getOffset();
        int _length = textRegion.getLength();
        int endOffset = _offset_1 + _length;
        while (!Objects.equal((Object)actualOffsetNode.getParent(), null) && actualOffsetNode.getTotalEndOffset() < endOffset) {
            ICompositeNode _parent;
            actualOffsetNode = _parent = actualOffsetNode.getParent();
        }
        EObject actualSemanticObj = actualOffsetNode.getSemanticElement();
        return actualSemanticObj;
    }

    protected void _visit(EObject semanticObj, INode originNode, ImportsAcceptor acceptor) {
    }

    protected void _visit(JvmTypeReference semanticElement, INode originNode, ImportsAcceptor acceptor) {
        JvmType _type = semanticElement.getType();
        this.visit((EObject)_type, originNode, acceptor);
    }

    protected void _visit(XAbstractFeatureCall semanticObj, INode originNode, ImportsAcceptor acceptor) {
        this.collectStaticImportsFrom(semanticObj, acceptor);
    }

    protected void _visit(XMemberFeatureCall semanticObj, INode originNode, ImportsAcceptor acceptor) {
        boolean _isExplicitStatic;
        boolean _not;
        if (semanticObj.getFeature() instanceof JvmType && semanticObj.isTypeLiteral()) {
            JvmIdentifiableElement _feature = semanticObj.getFeature();
            this.visit((EObject)((JvmType)_feature), originNode, acceptor);
        }
        boolean bl = _not = !(_isExplicitStatic = semanticObj.isExplicitStatic());
        if (_not) {
            boolean _isTypeLiteral;
            XExpression target = semanticObj.getMemberCallTarget();
            if (target instanceof XAbstractFeatureCall && (_isTypeLiteral = ((XAbstractFeatureCall)target).isTypeLiteral())) {
                return;
            }
            this.collectStaticImportsFrom(semanticObj, acceptor);
        }
    }

    protected void _visit(XFeatureCall semanticObj, INode originNode, ImportsAcceptor acceptor) {
        if (semanticObj.getFeature() instanceof JvmType && semanticObj.isTypeLiteral()) {
            JvmIdentifiableElement _feature = semanticObj.getFeature();
            this.visit((EObject)((JvmType)_feature), originNode, acceptor);
        } else {
            this.collectStaticImportsFrom(semanticObj, acceptor);
        }
    }

    protected void _visit(JvmGenericType jvmType, INode originNode, ImportsAcceptor acceptor) {
        boolean _isAnonymous = jvmType.isAnonymous();
        if (_isAnonymous) {
            EList _superTypes = jvmType.getSuperTypes();
            JvmTypeReference _last = (JvmTypeReference)IterableExtensions.last((Iterable)_superTypes);
            JvmType _type = _last.getType();
            this.visit((EObject)_type, originNode, acceptor);
        } else {
            this._visit((JvmDeclaredType)jvmType, originNode, acceptor);
        }
    }

    protected void _visit(JvmDeclaredType jvmType, INode originNode, ImportsAcceptor acceptor) {
        String text;
        String outerSegment;
        JvmDeclaredType outerType;
        boolean _equals_1;
        JvmDeclaredType _declaringType = jvmType.getDeclaringType();
        boolean _equals = Objects.equal((Object)_declaringType, null);
        if (_equals) {
            this.collectTypeImportFrom(jvmType, acceptor);
        }
        if (_equals_1 = Objects.equal((Object)(outerType = this.findDeclaringTypeBySimpleName(jvmType, outerSegment = this.getFirstNameSegment(text = NodeModelUtils.getTokenText((INode)originNode)))), null)) {
            throw new IllegalStateException();
        }
        this.collectTypeImportFrom(outerType, acceptor);
    }

    private JvmDeclaredType findDeclaringTypeBySimpleName(JvmDeclaredType referencedType, String outerSegment) {
        if (Objects.equal((Object)referencedType.getDeclaringType(), null) || outerSegment.equals(referencedType.getSimpleName())) {
            return referencedType;
        }
        JvmDeclaredType _declaringType = referencedType.getDeclaringType();
        return this.findDeclaringTypeBySimpleName(_declaringType, outerSegment);
    }

    protected void _visit(XConstructorCall semanticElement, INode originNode, ImportsAcceptor acceptor) {
        JvmConstructor _constructor = semanticElement.getConstructor();
        JvmDeclaredType _declaringType = _constructor.getDeclaringType();
        this.visit((EObject)_declaringType, originNode, acceptor);
    }

    protected void _visit(XAnnotation semanticElement, INode originNode, ImportsAcceptor acceptor) {
        JvmType _annotationType = semanticElement.getAnnotationType();
        this.visit((EObject)_annotationType, originNode, acceptor);
    }

    protected void _visit(XTypeLiteral semanticElement, INode originNode, ImportsAcceptor acceptor) {
        List elementNode = NodeModelUtils.findNodesForFeature((EObject)semanticElement, (EStructuralFeature)XbasePackage.Literals.XTYPE_LITERAL__TYPE);
        JvmType _type = semanticElement.getType();
        INode _head = (INode)IterableExtensions.head((Iterable)elementNode);
        this.visit((EObject)_type, _head, acceptor);
    }

    protected void _visit(Void nullCase, INode originNode, ImportsAcceptor acceptor) {
    }

    protected void collectTypeImportFrom(JvmDeclaredType type, ImportsAcceptor acceptor) {
        acceptor.acceptTypeImport((JvmType)type);
    }

    protected void collectStaticImportsFrom(XAbstractFeatureCall abstractFeatureCall, ImportsAcceptor acceptor) {
        boolean _isStatic = abstractFeatureCall.isStatic();
        if (_isStatic) {
            boolean _isExtension = abstractFeatureCall.isExtension();
            if (_isExtension) {
                acceptor.acceptStaticExtensionImport(abstractFeatureCall);
            } else {
                acceptor.acceptStaticImport(abstractFeatureCall);
            }
        }
    }

    protected String getFirstNameSegment(String text_finalParam_) {
        String text = text_finalParam_;
        Character _valueOf = Character.valueOf('.');
        char _charValue = _valueOf.charValue();
        int firstDelimiter = text.indexOf(_charValue);
        if (firstDelimiter == -1) {
            int _indexOf;
            Character _valueOf_1 = Character.valueOf('$');
            char _charValue_1 = _valueOf_1.charValue();
            firstDelimiter = _indexOf = text.indexOf(_charValue_1);
        } else {
            Character _valueOf_2 = Character.valueOf('$');
            char _charValue_2 = _valueOf_2.charValue();
            int dollar = text.indexOf(_charValue_2);
            if (dollar != -1) {
                int _min;
                firstDelimiter = _min = Math.min(firstDelimiter, dollar);
            }
        }
        if (firstDelimiter == -1) {
            int _indexOf_1 = text.indexOf("::");
            firstDelimiter = _indexOf_1;
            if (firstDelimiter == text.length() - 2 && firstDelimiter >= 0) {
                String _substring;
                text = _substring = text.substring(0, firstDelimiter);
                firstDelimiter = -1;
            }
        } else {
            int colon = text.indexOf("::");
            if (colon != text.length() - 2 && colon != -1) {
                int _min_1;
                firstDelimiter = _min_1 = Math.min(firstDelimiter, colon);
            }
        }
        if (firstDelimiter != -1) {
            return text.substring(0, firstDelimiter);
        }
        return text;
    }

    private void addJavaDocReferences(INode documentationNode, ITextRegion selectedRegion, ImportsAcceptor acceptor) {
        List _computeTypeRefRegions = this.javaDocTypeReferenceProvider.computeTypeRefRegions(documentationNode);
        for (ReplaceRegion docTypeReference : _computeTypeRefRegions) {
            boolean _not;
            boolean _notEquals;
            int _length;
            int _offset = docTypeReference.getOffset();
            TextRegion referenceRange = new TextRegion(_offset, _length = docTypeReference.getLength());
            boolean _contains = selectedRegion.contains((ITextRegion)referenceRange);
            if (!_contains) continue;
            String docTypeText = docTypeReference.getText();
            EObject element = NodeModelUtils.findActualSemanticObjectFor((INode)documentationNode);
            IScope scope = this.scopeProvider.getScope(element, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
            QualifiedName _create = QualifiedName.create((String)docTypeText);
            IEObjectDescription singleElement = scope.getSingleElement(_create);
            JvmType referencedType = null;
            boolean bl = _notEquals = !Objects.equal((Object)singleElement, null);
            if (_notEquals) {
                EObject _eObjectOrProxy = singleElement.getEObjectOrProxy();
                referencedType = (JvmType)_eObjectOrProxy;
            }
            if (!(referencedType instanceof JvmDeclaredType) || referencedType.eIsProxy()) continue;
            JvmDeclaredType casted = (JvmDeclaredType)referencedType;
            String _qualifiedName = casted.getQualifiedName();
            boolean _equals = _qualifiedName.equals(docTypeText);
            boolean bl2 = _not = !_equals;
            if (!_not) continue;
            acceptor.acceptTypeImport((JvmType)casted);
        }
    }

    public void visit(EObject jvmType, INode originNode, ImportsAcceptor acceptor) {
        if (jvmType instanceof JvmGenericType) {
            this._visit((JvmGenericType)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType instanceof JvmDeclaredType) {
            this._visit((JvmDeclaredType)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType instanceof XFeatureCall) {
            this._visit((XFeatureCall)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType instanceof XMemberFeatureCall) {
            this._visit((XMemberFeatureCall)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType instanceof XAbstractFeatureCall) {
            this._visit((XAbstractFeatureCall)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType instanceof XConstructorCall) {
            this._visit((XConstructorCall)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType instanceof XTypeLiteral) {
            this._visit((XTypeLiteral)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType instanceof XAnnotation) {
            this._visit((XAnnotation)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType instanceof JvmTypeReference) {
            this._visit((JvmTypeReference)jvmType, originNode, acceptor);
            return;
        }
        if (jvmType != null) {
            this._visit(jvmType, originNode, acceptor);
            return;
        }
        if (jvmType == null) {
            this._visit((Void)null, originNode, acceptor);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(jvmType, originNode, acceptor).toString());
    }
}

