/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.builder;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.builder.ParallelBuilderParticipant;
import org.eclipse.xtext.generator.OutputConfiguration;

public class XtendParallelBuilderParticipant
extends ParallelBuilderParticipant {
    private static final Logger logger = Logger.getLogger(XtendParallelBuilderParticipant.class);

    protected boolean shouldGenerate(Resource resource, IXtextBuilderParticipant.IBuildContext context) {
        return true;
    }

    protected Map<OutputConfiguration, Iterable<IMarker>> getGeneratorMarkers(IProject builtProject, Collection<OutputConfiguration> outputConfigurations) throws CoreException {
        HashMap generatorMarkers = Maps.newHashMap();
        List<IPath> sourcePath = this.getSourceFolderPathes(builtProject);
        for (OutputConfiguration config : outputConfigurations) {
            if (!config.isCleanUpDerivedResources()) continue;
            ArrayList containerToSearchIn = Lists.newArrayList();
            for (IPath sourceFolder : sourcePath) {
                if (sourceFolder.segmentCount() == 1) {
                    containerToSearchIn.add(builtProject);
                    continue;
                }
                IFolder sourcePathBasedContainer = builtProject.getWorkspace().getRoot().getFolder(sourceFolder);
                containerToSearchIn.add(sourcePathBasedContainer);
            }
            ArrayList markers = Lists.newArrayList();
            for (IContainer container : containerToSearchIn) {
                Iterables.addAll((Collection)markers, (Iterable)this.getDerivedResourceMarkers().findDerivedResourceMarkers((IResource)container, this.getGeneratorIdProvider().getGeneratorIdentifier()));
            }
            generatorMarkers.put(config, markers);
        }
        return this.buildGeneratorMarkersReverseLookupMap(generatorMarkers);
    }

    public List<IPath> getSourceFolderPathes(IProject project) {
        ArrayList sourceFolder = Lists.newArrayList();
        try {
            if (project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                List<IPackageFragmentRoot> packageFragmentRoots = Arrays.asList(javaProject.getPackageFragmentRoots());
                for (IPackageFragmentRoot packageFragmentRoot : packageFragmentRoots) {
                    if (packageFragmentRoot.getKind() != 1) continue;
                    IPath path = packageFragmentRoot.getPath();
                    sourceFolder.add(path);
                }
            }
        }
        catch (JavaModelException e) {
            if (!e.isDoesNotExist()) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (CoreException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return sourceFolder;
    }
}

