/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.contentassist;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class ParameterData {
    private List<Pair<String, Boolean>> variants = Lists.newArrayList();
    private boolean sorted = false;
    private String cachedDisplayString;

    public String getDisplayString() {
        if (this.cachedDisplayString == null) {
            this.sort();
            this.cachedDisplayString = Joiner.on((char)'\n').join(this.getRawDisplayString());
        }
        return this.cachedDisplayString;
    }

    private void sort() {
        if (this.sorted) {
            return;
        }
        Collections.sort(this.variants, new Comparator<Pair<String, Boolean>>(){

            @Override
            public int compare(Pair<String, Boolean> o1, Pair<String, Boolean> o2) {
                return ((String)o1.getFirst()).compareTo((String)o2.getFirst());
            }
        });
        this.sorted = true;
    }

    public void addOverloaded(String string, boolean varArgs) {
        this.cachedDisplayString = null;
        this.sorted = false;
        Pair newVariant = Tuples.create((Object)string, (Object)varArgs);
        if (!this.variants.contains(newVariant)) {
            this.variants.add((Pair<String, Boolean>)newVariant);
        }
    }

    public boolean isVarArgs(int variant) {
        return (Boolean)this.variants.get(variant).getSecond();
    }

    public List<String> getRawDisplayString() {
        this.sort();
        return Lists.transform(this.variants, (Function)new Function<Pair<String, Boolean>, String>(){

            public String apply(Pair<String, Boolean> input) {
                return (String)input.getFirst();
            }
        });
    }
}

