/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.net.URL;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.ui.IImageHelper;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

@Singleton
public class PluginImageHelper
implements IImageHelper,
IImageHelper.IImageDescriptorHelper,
SynchronousBundleListener {
    private static final String PLATFORM_URL_PREFIX = "platform:/plugin/";
    private static final String PLATFORM_URL_SEPARATOR = "/";
    private Map<ImageDescriptor, Image> registry = Maps.newHashMapWithExpectedSize((int)10);
    @Inject
    private AbstractUIPlugin plugin;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.PluginImageHelper.pathSuffix")
    private String pathSuffix = "icons/";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.PluginImageHelper.defaultImage")
    private String defaultImage = "default.gif";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.PluginImageHelper.notFound")
    private String notFound = "notFound.gif";
    private DisplayDisposeListener displayDisposeListener = null;

    @Override
    public Image getImage(ImageDescriptor descriptor) {
        Image result;
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = this.registry.get(descriptor)) != null) {
            return result;
        }
        result = descriptor.createImage();
        if (result != null) {
            this.putToRegistry(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        for (Image image : this.registry.values()) {
            image.dispose();
        }
        this.registry.clear();
        if (this.displayDisposeListener != null) {
            this.displayDisposeListener.setHelper(null);
            this.displayDisposeListener = null;
        }
    }

    @Inject
    public void hookBundleListener(AbstractUIPlugin plugin) {
        plugin.getBundle().getBundleContext().addBundleListener((BundleListener)this);
    }

    @Override
    public Image getImage(String imageName) {
        String imgname;
        ImageDescriptor descriptor = this.findImage(imageName);
        if (descriptor != null) {
            return this.getImage(descriptor);
        }
        String string = imgname = imageName == null ? this.defaultImage : imageName;
        if (imgname != null) {
            Image result = null;
            URL imgUrl = this.getPlugin().getBundle().getEntry(String.valueOf(this.getPathSuffix()) + imgname);
            if (imgUrl != null) {
                ImageDescriptor id = null;
                result = this.getPlugin().getImageRegistry().get(imgUrl.toExternalForm());
                if (result == null && (id = ImageDescriptor.createFromURL((URL)imgUrl)) != null) {
                    result = id.createImage();
                    this.getPlugin().getImageRegistry().put(imgUrl.toExternalForm(), result);
                }
                return result;
            }
            if (!imgname.equals(this.notFound)) {
                return this.getImage(this.notFound);
            }
        }
        return null;
    }

    @Override
    public ImageDescriptor getImageDescriptor(String imageName) {
        String imgname;
        ImageDescriptor descriptor = this.findImage(imageName);
        if (descriptor != null) {
            return descriptor;
        }
        String string = imgname = imageName == null ? this.defaultImage : imageName;
        if (imgname != null) {
            URL imgUrl = this.getPlugin().getBundle().getEntry(String.valueOf(this.getPathSuffix()) + imgname);
            if (imgUrl != null) {
                return ImageDescriptor.createFromURL((URL)imgUrl);
            }
            if (!imgname.equals(this.notFound)) {
                return this.getImageDescriptor(this.notFound);
            }
        }
        return null;
    }

    @Override
    public ImageDescriptor getImageDescriptor(Image image) {
        for (Map.Entry<ImageDescriptor, Image> entry : this.registry.entrySet()) {
            if (!entry.getValue().equals((Object)image)) continue;
            return entry.getKey();
        }
        ImageDescriptor newDescriptor = ImageDescriptor.createFromImage((Image)image);
        this.putToRegistry(newDescriptor, image);
        return newDescriptor;
    }

    protected void putToRegistry(ImageDescriptor descriptor, Image image) {
        if (this.displayDisposeListener == null) {
            this.displayDisposeListener = new DisplayDisposeListener(this);
            Display.getCurrent().disposeExec((Runnable)this.displayDisposeListener);
        }
        this.registry.put(descriptor, image);
    }

    public void setPathSuffix(String pathSuffix) {
        this.pathSuffix = pathSuffix;
    }

    public String getPathSuffix() {
        return this.pathSuffix;
    }

    public void setPlugin(AbstractUIPlugin plugin) {
        this.plugin = plugin;
    }

    public AbstractUIPlugin getPlugin() {
        return this.plugin;
    }

    public void setNotFound(String notFound) {
        this.notFound = notFound;
    }

    public String getNotFound() {
        return this.notFound;
    }

    public String getDefaultImage() {
        return this.defaultImage;
    }

    public void setDefaultImage(String defaultImage) {
        this.defaultImage = defaultImage;
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 256 && event.getBundle().getBundleId() == this.getPlugin().getBundle().getBundleId()) {
            this.dispose();
        }
    }

    protected ImageDescriptor findImage(String name) {
        int index;
        if (name != null && name.startsWith(PLATFORM_URL_PREFIX) && (index = name.indexOf(PLATFORM_URL_SEPARATOR, PLATFORM_URL_PREFIX.length())) >= 0) {
            String pluginId = name.substring(PLATFORM_URL_PREFIX.length(), index);
            String imageId = name.substring(index + 1);
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)(String.valueOf(this.getPathSuffix()) + imageId));
        }
        return null;
    }

    public static class DisplayDisposeListener
    implements Runnable {
        private PluginImageHelper helper;

        public DisplayDisposeListener(PluginImageHelper helper) {
            this.helper = helper;
        }

        public PluginImageHelper getHelper() {
            return this.helper;
        }

        public void setHelper(PluginImageHelper helper) {
            this.helper = helper;
        }

        @Override
        public void run() {
            if (this.helper != null) {
                this.helper.dispose();
            }
            this.helper = null;
        }
    }
}

