/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.AbstractTypeReferencePairWalker;
import org.eclipse.xtext.xbase.typesystem.util.ActualTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeReferences;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

public class UnboundTypeParameterAwareTypeArgumentCollector
extends ActualTypeArgumentCollector {
    public UnboundTypeParameterAwareTypeArgumentCollector(Collection<JvmTypeParameter> parametersToBeMapped, BoundTypeArgumentSource defaultSource, ITypeReferenceOwner owner) {
        super(parametersToBeMapped, defaultSource, owner);
    }

    @Override
    protected TypeParameterSubstitutor<?> createTypeParameterSubstitutor(Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping) {
        return new UnboundTypeParameterPreservingSubstitutor(mapping, this.getOwner());
    }

    @Override
    protected AbstractTypeReferencePairWalker.UnboundTypeReferenceTraverser createUnboundTypeReferenceTraverser() {
        return new UnboundTypeParameterAwareUnboundTypeReferenceTraverser();
    }

    protected void acceptHint(UnboundTypeReference reference, LightweightTypeReference param) {
        reference.acceptHint(this.boundByDefaultSource(param));
    }

    @Override
    protected AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser createParameterizedTypeReferenceTraverser() {
        return new UnboundTypeParameterAwareParameterizedTypeReferenceTraverser();
    }

    @Override
    protected JvmTypeParameter findMappedParameter(JvmTypeParameter parameter, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping, Collection<JvmTypeParameter> visited) {
        return UnboundTypeReferences.findMappedParameter(parameter, mapping, visited);
    }

    protected class UnboundTypeParameterAwareParameterizedTypeReferenceTraverser
    extends ActualTypeArgumentCollector.ActualParameterizedTypeReferenceTraverser {
        protected UnboundTypeParameterAwareParameterizedTypeReferenceTraverser() {
        }

        @Override
        public void doVisitUnboundTypeReference(UnboundTypeReference reference, ParameterizedTypeReference declaration) {
            JvmType type = declaration.getType();
            if (type instanceof JvmTypeParameter) {
                JvmTypeParameter unboundTypeParameter = (JvmTypeParameter)type;
                if (unboundTypeParameter != reference.getTypeParameter() && UnboundTypeParameterAwareTypeArgumentCollector.this.shouldProcess(unboundTypeParameter)) {
                    UnboundTypeParameterAwareTypeArgumentCollector.this.processTypeParameter(unboundTypeParameter, reference);
                }
            } else {
                UnboundTypeParameterAwareTypeArgumentCollector.this.acceptHint(reference, declaration);
            }
        }

        @Override
        protected void doVisitCompoundTypeReference(CompoundTypeReference reference, ParameterizedTypeReference declaration) {
            JvmType type = declaration.getType();
            if (type instanceof JvmTypeParameter) {
                JvmTypeParameter unboundTypeParameter = (JvmTypeParameter)type;
                if (UnboundTypeParameterAwareTypeArgumentCollector.this.shouldProcess(unboundTypeParameter)) {
                    UnboundTypeParameterAwareTypeArgumentCollector.this.processTypeParameter(unboundTypeParameter, reference);
                }
            } else {
                super.doVisitCompoundTypeReference(reference, declaration);
            }
        }
    }

    protected class UnboundTypeParameterAwareUnboundTypeReferenceTraverser
    extends AbstractTypeReferencePairWalker.UnboundTypeReferenceTraverser {
        protected UnboundTypeParameterAwareUnboundTypeReferenceTraverser() {
            super(UnboundTypeParameterAwareTypeArgumentCollector.this);
        }

        @Override
        protected void doVisitTypeReference(LightweightTypeReference reference, UnboundTypeReference declaration) {
            if (declaration.internalIsResolved() || UnboundTypeParameterAwareTypeArgumentCollector.this.getOwner().isResolved(declaration.getHandle())) {
                declaration.tryResolve();
                UnboundTypeParameterAwareTypeArgumentCollector.this.outerVisit(declaration, reference, declaration, UnboundTypeParameterAwareTypeArgumentCollector.this.getExpectedVariance(), UnboundTypeParameterAwareTypeArgumentCollector.this.getActualVariance());
            } else {
                UnboundTypeParameterAwareTypeArgumentCollector.this.acceptHint(declaration, reference);
            }
        }

        @Override
        protected void doVisitUnboundTypeReference(UnboundTypeReference reference, UnboundTypeReference declaration) {
            if (declaration.internalIsResolved() || UnboundTypeParameterAwareTypeArgumentCollector.this.getOwner().isResolved(declaration.getHandle())) {
                declaration.tryResolve();
                UnboundTypeParameterAwareTypeArgumentCollector.this.outerVisit(declaration, reference, declaration, UnboundTypeParameterAwareTypeArgumentCollector.this.getExpectedVariance(), UnboundTypeParameterAwareTypeArgumentCollector.this.getActualVariance());
            } else {
                if (UnboundTypeParameterAwareTypeArgumentCollector.this.getParametersToProcess().contains(declaration.getTypeParameter()) && VarianceInfo.OUT == UnboundTypeParameterAwareTypeArgumentCollector.this.getActualVariance() && VarianceInfo.OUT == UnboundTypeParameterAwareTypeArgumentCollector.this.getExpectedVariance() && UnboundTypeParameterAwareTypeArgumentCollector.this.getDefaultSource() == BoundTypeArgumentSource.EXPECTATION) {
                    List<LightweightBoundTypeArgument> hints = reference.getAllHints();
                    int i = 0;
                    while (i < hints.size()) {
                        if (hints.get(i).getSource() == BoundTypeArgumentSource.INFERRED) {
                            return;
                        }
                        ++i;
                    }
                }
                UnboundTypeParameterAwareTypeArgumentCollector.this.acceptHint(declaration, reference);
            }
        }

        @Override
        protected void doVisitCompoundTypeReference(CompoundTypeReference reference, UnboundTypeReference param) {
            this.doVisitTypeReference((LightweightTypeReference)reference, param);
        }
    }
}

