/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtend.core.resource.DescriptionFlags;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.ide.labeling.XtendImages;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.label.DefaultDescriptionLabelProvider;
import org.eclipse.xtext.xtype.XtypePackage;

public class XtendDescriptionLabelProvider
extends DefaultDescriptionLabelProvider {
    @Inject
    private XtendImages images;
    @Inject
    private DescriptionFlags descriptionFlags;

    public Object image(IEObjectDescription element) {
        int adornments;
        EClass eClass = element.getEClass();
        int n = adornments = this.descriptionFlags.isStatic(element) ? 8 : 0;
        if (eClass == XtendPackage.Literals.XTEND_FILE) {
            return this.images.forFile();
        }
        if (eClass == XtypePackage.Literals.XIMPORT_DECLARATION) {
            return this.images.forImport();
        }
        if (eClass == XtendPackage.Literals.XTEND_CLASS || eClass == TypesPackage.Literals.JVM_GENERIC_TYPE) {
            return this.images.forClass(JvmVisibility.PUBLIC, adornments);
        }
        if (eClass == XtendPackage.Literals.XTEND_FUNCTION) {
            return this.images.forOperation(JvmVisibility.PUBLIC, adornments);
        }
        if (eClass == XtendPackage.Literals.XTEND_FIELD) {
            return this.images.forField(JvmVisibility.PUBLIC, adornments);
        }
        if (eClass == TypesPackage.Literals.JVM_OPERATION) {
            return this.descriptionFlags.isDispatcherOperation(element) ? this.images.forDispatcherFunction(JvmVisibility.PUBLIC, adornments) : this.images.forOperation(JvmVisibility.PUBLIC, adornments);
        }
        return super.image(element);
    }
}

