/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ecoreInference;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.XtextSwitch;
import org.eclipse.xtext.xtext.ecoreInference.EClassifierInfo;
import org.eclipse.xtext.xtext.ecoreInference.EClassifierInfos;
import org.eclipse.xtext.xtext.ecoreInference.ElementTypeCalculator;
import org.eclipse.xtext.xtext.ecoreInference.TransformationErrorCode;
import org.eclipse.xtext.xtext.ecoreInference.TransformationException;

public class Xtext2EcoreInterpretationContext {
    private final EClassifierInfos eClassifierInfos;
    private final Function<AbstractElement, EClassifier> classifierCalculator;
    private final Collection<EClassifierInfo> currentTypes = Sets.newLinkedHashSet();
    private boolean isRuleCallAllowed = true;

    private Xtext2EcoreInterpretationContext(EClassifierInfos classifierInfos) {
        if (classifierInfos == null) {
            throw new NullPointerException("classifierInfos may not be null");
        }
        this.eClassifierInfos = classifierInfos;
        this.classifierCalculator = new ElementTypeCalculator(this.eClassifierInfos);
    }

    public Xtext2EcoreInterpretationContext(EClassifierInfos eClassifierInfos, EClassifierInfo currentType) {
        this(eClassifierInfos);
        this.currentTypes.add(currentType);
    }

    private Xtext2EcoreInterpretationContext(Collection<EClassifierInfo> currentTypes, EClassifierInfos classifierInfos, boolean isRuleCallAllowed) {
        this(classifierInfos);
        this.currentTypes.addAll(currentTypes);
        this.isRuleCallAllowed = isRuleCallAllowed;
    }

    public Xtext2EcoreInterpretationContext(EClassifierInfo newType, EClassifierInfos classifierInfos, boolean isRuleCallAllowed) {
        this(classifierInfos);
        this.currentTypes.add(newType);
        this.isRuleCallAllowed = isRuleCallAllowed;
    }

    public void addFeature(Assignment assignment) throws TransformationException {
        EClassifierInfo featureTypeInfo;
        String featureName = assignment.getFeature();
        boolean isMultivalue = GrammarUtil.isMultipleAssignment(assignment);
        boolean isContainment = true;
        if (GrammarUtil.isBooleanAssignment(assignment)) {
            EDataType eBoolean = GrammarUtil.findEBoolean(GrammarUtil.getGrammar(assignment));
            featureTypeInfo = this.getEClassifierInfoOrThrowException((EClassifier)eBoolean, assignment);
            isMultivalue = false;
        } else {
            AbstractElement terminal = assignment.getTerminal();
            if (terminal == null) {
                throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Cannot derive type from incomplete assignment.", assignment);
            }
            EClassifier type = this.getTerminalType(terminal);
            isContainment = this.isContainmentAssignment(assignment);
            featureTypeInfo = this.getEClassifierInfoOrThrowException(type, assignment);
        }
        this.addFeature(featureName, featureTypeInfo, isMultivalue, isContainment, assignment);
    }

    public boolean isContainmentAssignment(Assignment assignment) {
        return (Boolean)new XtextSwitch<Boolean>(){

            @Override
            public Boolean caseAlternatives(Alternatives object) {
                for (AbstractElement group : object.getElements()) {
                    if (!((Boolean)this.doSwitch(group)).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean caseCrossReference(CrossReference object) {
                return false;
            }

            @Override
            public Boolean caseAbstractElement(AbstractElement object) {
                return true;
            }
        }.doSwitch(assignment.getTerminal());
    }

    public void addFeature(String featureName, EClassifierInfo featureTypeInfo, boolean isMultivalue, boolean isContainment, AbstractElement parserElement) throws TransformationException {
        for (EClassifierInfo type : this.currentTypes) {
            type.addFeature(featureName, featureTypeInfo, isMultivalue, isContainment, parserElement);
        }
    }

    private EClassifier getTerminalType(AbstractElement terminal) throws TransformationException {
        EClassifier result = (EClassifier)this.classifierCalculator.apply((Object)terminal);
        if (result == null) {
            ICompositeNode node = NodeModelUtils.getNode(terminal);
            if (node != null) {
                throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Cannot find type for '" + node.getText().trim() + "'.", terminal);
            }
            throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Cannot find type for " + terminal.eClass().getName(), terminal);
        }
        return result;
    }

    private EClassifierInfo getEClassifierInfoOrThrowException(EClassifier type, AbstractElement parserElement) throws TransformationException {
        EClassifierInfo featureTypeInfo = this.eClassifierInfos.getInfoOrNull(type);
        if (featureTypeInfo == null) {
            String typeName = "null";
            if (type != null) {
                typeName = type.getName();
            }
            throw new TransformationException(TransformationErrorCode.NoSuchTypeAvailable, "Cannot resolve type " + typeName, parserElement);
        }
        return featureTypeInfo;
    }

    public Xtext2EcoreInterpretationContext spawnContextForGroup() {
        Xtext2EcoreInterpretationContext result = new Xtext2EcoreInterpretationContext(this.currentTypes, this.eClassifierInfos, this.isRuleCallAllowed);
        return result;
    }

    public Xtext2EcoreInterpretationContext spawnContextWithCalledRule(EClassifierInfo newType, EObject parserElement) throws TransformationException {
        if (!this.isRuleCallAllowed) {
            throw new TransformationException(TransformationErrorCode.MoreThanOneTypeChangeInOneRule, "Cannot change type twice within a rule", parserElement);
        }
        return new Xtext2EcoreInterpretationContext(newType, this.eClassifierInfos, false);
    }

    public Xtext2EcoreInterpretationContext mergeSpawnedContexts(List<Xtext2EcoreInterpretationContext> contexts) {
        Xtext2EcoreInterpretationContext result = new Xtext2EcoreInterpretationContext(this.eClassifierInfos);
        for (Xtext2EcoreInterpretationContext context : contexts) {
            result.currentTypes.addAll(context.currentTypes);
            result.isRuleCallAllowed &= context.isRuleCallAllowed;
        }
        return result;
    }

    public EClassifierInfo getCurrentCompatibleType() {
        return this.eClassifierInfos.getCompatibleTypeOf(this.currentTypes);
    }

    public Xtext2EcoreInterpretationContext spawnContextWithReferencedType(EClassifierInfo referencedType, EObject parserElement) {
        return new Xtext2EcoreInterpretationContext(referencedType, this.eClassifierInfos, false);
    }
}

