/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.linking.lazy.LazyURIEncoder;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class UIStrings {
    @Inject
    private LazyURIEncoder lazyURIEncoder;
    @Inject
    private IBatchTypeResolver typeResolver;

    public String signature(JvmExecutable executable) {
        StringBuilder b = new StringBuilder(executable.getSimpleName());
        b.append(this.parameters((JvmIdentifiableElement)executable));
        if (executable instanceof JvmOperation) {
            b.append(" : ").append(((JvmOperation)executable).getReturnType().getSimpleName());
        }
        return b.toString();
    }

    public String parameters(JvmIdentifiableElement element) {
        if (element instanceof JvmExecutable) {
            return "(" + this.parameterTypes((Iterable<JvmFormalParameter>)((JvmExecutable)element).getParameters(), ((JvmExecutable)element).isVarArgs()) + ")";
        }
        return "";
    }

    public String arguments(XAbstractFeatureCall featureCall) {
        EList<XExpression> arguments = featureCall.getActualArguments();
        return "(" + this.expressionTypes((Iterable<XExpression>)arguments) + ")";
    }

    public String arguments(XConstructorCall constructorCall) {
        return "(" + this.expressionTypes((Iterable<XExpression>)constructorCall.getArguments()) + ")";
    }

    public String typeParameters(Iterable<? extends JvmTypeParameter> typeParams) {
        if (!Iterables.isEmpty(typeParams)) {
            return "<" + this.toString(typeParams) + ">";
        }
        return "";
    }

    public String typeParameters(JvmIdentifiableElement element) {
        if (element instanceof JvmTypeParameterDeclarator) {
            EList typeParameters = ((JvmTypeParameterDeclarator)element).getTypeParameters();
            return this.typeParameters((Iterable<? extends JvmTypeParameter>)typeParameters);
        }
        return "";
    }

    public String typeArguments(XAbstractFeatureCall featureCall) {
        return "<" + this.referencesToString((Iterable<? extends JvmTypeReference>)featureCall.getTypeArguments()) + ">";
    }

    public String typeArguments(XConstructorCall constructorCall) {
        return "<" + this.referencesToString((Iterable<? extends JvmTypeReference>)constructorCall.getTypeArguments()) + ">";
    }

    public String toString(Iterable<? extends JvmTypeParameter> elements) {
        StringBuilder buffer = new StringBuilder();
        boolean needsSeparator = false;
        for (JvmTypeParameter jvmTypeParameter : elements) {
            if (needsSeparator) {
                buffer.append(", ");
            }
            needsSeparator = true;
            if (jvmTypeParameter != null) {
                buffer.append(jvmTypeParameter.getSimpleName());
                ArrayList upper = Lists.newArrayList();
                String lower = null;
                for (JvmTypeConstraint constr : jvmTypeParameter.getConstraints()) {
                    String simpleName = constr.getTypeReference().getSimpleName();
                    if (constr instanceof JvmUpperBound) {
                        upper.add(simpleName);
                        continue;
                    }
                    lower = simpleName;
                }
                if (!upper.isEmpty()) {
                    buffer.append(" extends ");
                    buffer.append(Strings.concat((String)" & ", (List)upper));
                }
                if (lower == null) continue;
                buffer.append(" super ");
                buffer.append(lower);
                continue;
            }
            buffer.append("[null]");
        }
        return buffer.toString();
    }

    protected String referencesToString(Iterable<? extends JvmTypeReference> elements) {
        StringBuilder buffer = new StringBuilder();
        boolean needsSeparator = false;
        for (JvmTypeReference jvmTypeReference : elements) {
            if (needsSeparator) {
                buffer.append(", ");
            }
            needsSeparator = true;
            buffer.append(this.referenceToString(jvmTypeReference, "[null]"));
        }
        return buffer.toString();
    }

    public String referenceToString(JvmTypeReference typeRef, String defaultLabel) {
        if (typeRef != null) {
            if (typeRef instanceof JvmAnyTypeReference) {
                return "Object";
            }
            JvmType type = typeRef.getType();
            if (type != null && type.eIsProxy() && typeRef.eResource() != null) {
                URI proxyURI = EcoreUtil.getURI((EObject)type);
                String fragment = proxyURI.fragment();
                if (this.lazyURIEncoder.isCrossLinkFragment(typeRef.eResource(), fragment)) {
                    Triple decoded = this.lazyURIEncoder.decode(typeRef.eResource(), fragment);
                    INode node = (INode)decoded.getThird();
                    if (node != null) {
                        int pointIndex;
                        ITextRegion textRegion;
                        String text = node.getRootNode().getText();
                        String result = text.substring((textRegion = node.getTextRegion()).getOffset(), textRegion.getLength() + textRegion.getOffset());
                        if (result != null && (pointIndex = result.lastIndexOf(46)) >= 0 && pointIndex < result.length() - 1) {
                            return result.substring(pointIndex + 1);
                        }
                        return result;
                    }
                    return defaultLabel;
                }
            } else {
                return typeRef.getSimpleName();
            }
        }
        return defaultLabel;
    }

    protected String expressionTypes(Iterable<XExpression> expressions) {
        Iterator<XExpression> iterator = expressions.iterator();
        if (iterator.hasNext()) {
            XExpression expression = iterator.next();
            IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes(expression);
            LightweightTypeReference reference = resolvedTypes.getActualType(expression);
            if (!iterator.hasNext()) {
                return this.referenceToString(reference);
            }
            StringBuilder result = new StringBuilder(reference.toString());
            while (iterator.hasNext()) {
                reference = resolvedTypes.getActualType(iterator.next());
                result.append(", ");
                result.append(this.referenceToString(reference));
            }
            return result.toString();
        }
        return "";
    }

    protected String referenceToString(LightweightTypeReference reference) {
        if (reference == null) {
            return "[null]";
        }
        if (reference.isAny()) {
            return "Object";
        }
        return reference.getHumanReadableName();
    }

    protected String parametersToString(Iterable<? extends JvmFormalParameter> elements, boolean isVarArgs, boolean includeName) {
        StringBuilder result = new StringBuilder();
        boolean needsSeparator = false;
        Iterator<? extends JvmFormalParameter> iterator = elements.iterator();
        while (iterator.hasNext()) {
            JvmFormalParameter parameter = iterator.next();
            if (needsSeparator) {
                result.append(", ");
            }
            needsSeparator = true;
            JvmTypeReference typeRef = parameter.getParameterType();
            if (isVarArgs && !iterator.hasNext() && typeRef instanceof JvmGenericArrayTypeReference) {
                typeRef = ((JvmGenericArrayTypeReference)typeRef).getComponentType();
                result.append(this.referenceToString(typeRef, "[null]"));
                result.append("...");
            } else {
                result.append(this.referenceToString(typeRef, "[null]"));
            }
            if (!includeName) continue;
            result.append(" " + parameter.getName());
        }
        return result.toString();
    }

    protected String parameterTypes(Iterable<JvmFormalParameter> parameters, boolean isVarArgs) {
        return this.parametersToString(parameters, isVarArgs, false);
    }
}

