/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.ecore2xtext;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xtext.ui.wizard.ecore2xtext.EPackageInfo;
import org.eclipse.xtext.xtext.ui.wizard.ecore2xtext.Ecore2XtextProjectInfo;
import org.eclipse.xtext.xtext.ui.wizard.ecore2xtext.UniqueNameUtil;

public class Ecore2XtextExtensions {
    public static Iterable<EClassifier> allConcreteRuleClassifiers(Ecore2XtextProjectInfo it) {
        Iterable _xifexpression = null;
        EClass _rootElementClass = it.getRootElementClass();
        boolean _equals = Objects.equal((Object)_rootElementClass, null);
        if (_equals) {
            Collection<EPackageInfo> _ePackageInfos = it.getEPackageInfos();
            Functions.Function1<EPackageInfo, Set<EClassifier>> _function = new Functions.Function1<EPackageInfo, Set<EClassifier>>(){

                public Set<EClassifier> apply(EPackageInfo it) {
                    EPackage _ePackage = it.getEPackage();
                    return Ecore2XtextExtensions.allReferencedClassifiers(_ePackage, false);
                }
            };
            Iterable _map = IterableExtensions.map(_ePackageInfos, (Functions.Function1)_function);
            Iterable _flatten = Iterables.concat((Iterable)_map);
            Set _set = IterableExtensions.toSet((Iterable)_flatten);
            Functions.Function1<EClassifier, Boolean> _function_1 = new Functions.Function1<EClassifier, Boolean>(){

                public Boolean apply(EClassifier it) {
                    return Ecore2XtextExtensions.needsConcreteRule(it);
                }
            };
            _xifexpression = IterableExtensions.filter((Iterable)_set, (Functions.Function1)_function_1);
        } else {
            Set _xblockexpression = null;
            EClass _rootElementClass_1 = it.getRootElementClass();
            EClassifier _cast = (EClassifier)EClassifier.class.cast(_rootElementClass_1);
            ArrayList c = CollectionLiterals.newArrayList((Object[])new EClassifier[]{_cast});
            EClass _rootElementClass_2 = it.getRootElementClass();
            Ecore2XtextExtensions.allAssignedClassifiers(_rootElementClass_2, c);
            Functions.Function1<EClassifier, Boolean> _function_2 = new Functions.Function1<EClassifier, Boolean>(){

                public Boolean apply(EClassifier cl) {
                    return Ecore2XtextExtensions.needsConcreteRule(cl);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)c, (Functions.Function1)_function_2);
            _xblockexpression = IterableExtensions.toSet((Iterable)_filter);
            _xifexpression = _xblockexpression;
        }
        return _xifexpression;
    }

    public static Collection<EClass> allDispatcherRuleClasses(Ecore2XtextProjectInfo it) {
        Set _xifexpression = null;
        EClass _rootElementClass = it.getRootElementClass();
        boolean _equals = Objects.equal((Object)_rootElementClass, null);
        if (_equals) {
            Collection<EPackageInfo> _ePackageInfos = it.getEPackageInfos();
            Functions.Function1<EPackageInfo, Set<EClassifier>> _function = new Functions.Function1<EPackageInfo, Set<EClassifier>>(){

                public Set<EClassifier> apply(EPackageInfo it) {
                    EPackage _ePackage = it.getEPackage();
                    return Ecore2XtextExtensions.allReferencedClassifiers(_ePackage, false);
                }
            };
            Iterable _map = IterableExtensions.map(_ePackageInfos, (Functions.Function1)_function);
            Iterable _flatten = Iterables.concat((Iterable)_map);
            Set _set = IterableExtensions.toSet((Iterable)_flatten);
            Functions.Function1<EClassifier, Boolean> _function_1 = new Functions.Function1<EClassifier, Boolean>(){

                public Boolean apply(EClassifier c) {
                    return Ecore2XtextExtensions.needsDispatcherRule(c);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)_set, (Functions.Function1)_function_1);
            Iterable _filter_1 = Iterables.filter((Iterable)_filter, EClass.class);
            _xifexpression = IterableExtensions.toSet((Iterable)_filter_1);
        } else {
            Iterable<EClassifier> _allConcreteRuleClassifiers = Ecore2XtextExtensions.allConcreteRuleClassifiers(it);
            Iterable _filter_2 = Iterables.filter(_allConcreteRuleClassifiers, EClass.class);
            Functions.Function1<EClass, Iterable<EClassifier>> _function_2 = new Functions.Function1<EClass, Iterable<EClassifier>>(){

                public Iterable<EClassifier> apply(EClass c) {
                    EList _eAllReferences = c.getEAllReferences();
                    Functions.Function1<EReference, Boolean> _function = new Functions.Function1<EReference, Boolean>(){

                        public Boolean apply(EReference r) {
                            return Ecore2XtextExtensions.needsAssignment((EStructuralFeature)r);
                        }
                    };
                    Iterable _filter = IterableExtensions.filter((Iterable)_eAllReferences, (Functions.Function1)_function);
                    Functions.Function1<EReference, EClassifier> _function_1 = new Functions.Function1<EReference, EClassifier>(){

                        public EClassifier apply(EReference it) {
                            return it.getEType();
                        }
                    };
                    return IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
                }
            };
            Iterable _map_1 = IterableExtensions.map((Iterable)_filter_2, (Functions.Function1)_function_2);
            Iterable _flatten_1 = Iterables.concat((Iterable)_map_1);
            Iterable _filter_3 = Iterables.filter((Iterable)_flatten_1, EClass.class);
            _xifexpression = IterableExtensions.toSet((Iterable)_filter_3);
        }
        return _xifexpression;
    }

    public static Collection<EPackage> allReferencedEPackages(Ecore2XtextProjectInfo prjInfo) {
        Collection<EPackageInfo> _ePackageInfos = prjInfo.getEPackageInfos();
        Functions.Function1<EPackageInfo, Set<EPackage>> _function = new Functions.Function1<EPackageInfo, Set<EPackage>>(){

            public Set<EPackage> apply(EPackageInfo it) {
                EPackage _ePackage = it.getEPackage();
                return Ecore2XtextExtensions.allReferencedEPackages(_ePackage, true);
            }
        };
        Iterable _map = IterableExtensions.map(_ePackageInfos, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        return IterableExtensions.toSet((Iterable)_flatten);
    }

    public static Set<EPackage> allReferencedEPackages(EPackage ePack, boolean includeCrossRefs) {
        Set<EClassifier> _allReferencedClassifiers = Ecore2XtextExtensions.allReferencedClassifiers(ePack, includeCrossRefs);
        Functions.Function1<EClassifier, EPackage> _function = new Functions.Function1<EClassifier, EPackage>(){

            public EPackage apply(EClassifier it) {
                return it.getEPackage();
            }
        };
        Iterable _map = IterableExtensions.map(_allReferencedClassifiers, (Functions.Function1)_function);
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)_map);
        return IterableExtensions.toSet((Iterable)_filterNull);
    }

    public static Set<EClassifier> allReferencedClassifiers(EPackage ePack, final boolean includeCrossRefs) {
        EList _eClassifiers = ePack.getEClassifiers();
        Iterable _filter = Iterables.filter((Iterable)_eClassifiers, EClass.class);
        Functions.Function1<EClass, Iterable<EStructuralFeature>> _function = new Functions.Function1<EClass, Iterable<EStructuralFeature>>(){

            public Iterable<EStructuralFeature> apply(EClass it) {
                EList _eAllStructuralFeatures = it.getEAllStructuralFeatures();
                Functions.Function1<EStructuralFeature, Boolean> _function = new Functions.Function1<EStructuralFeature, Boolean>(){

                    public Boolean apply(EStructuralFeature f) {
                        boolean _and = false;
                        boolean _needsAssignment = Ecore2XtextExtensions.needsAssignment(f);
                        if (!_needsAssignment) {
                            _and = false;
                        } else {
                            boolean _isContainment;
                            boolean _or = false;
                            _or = includeCrossRefs ? true : (_isContainment = Ecore2XtextExtensions.isContainment(f));
                            _and = _or;
                        }
                        return _and;
                    }
                };
                return IterableExtensions.filter((Iterable)_eAllStructuralFeatures, (Functions.Function1)_function);
            }
        };
        Iterable strFeatures = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)strFeatures);
        Functions.Function1<EStructuralFeature, EClassifier> _function_1 = new Functions.Function1<EStructuralFeature, EClassifier>(){

            public EClassifier apply(EStructuralFeature it) {
                return it.getEType();
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_flatten, (Functions.Function1)_function_1);
        Set refTypes = IterableExtensions.toSet((Iterable)_map);
        EList _eClassifiers_1 = ePack.getEClassifiers();
        Iterable _plus = Iterables.concat((Iterable)_eClassifiers_1, (Iterable)refTypes);
        Set retVal = IterableExtensions.toSet((Iterable)_plus);
        EClassifier _eString = UniqueNameUtil.eString();
        retVal.add(_eString);
        return retVal;
    }

    private static void allAssignedClassifiers(EClass eClazz, final Collection<EClassifier> acceptor) {
        EList _eAllStructuralFeatures = eClazz.getEAllStructuralFeatures();
        Functions.Function1<EStructuralFeature, Boolean> _function = new Functions.Function1<EStructuralFeature, Boolean>(){

            public Boolean apply(EStructuralFeature f) {
                return Ecore2XtextExtensions.needsAssignment(f);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_eAllStructuralFeatures, (Functions.Function1)_function);
        Functions.Function1<EStructuralFeature, EClassifier> _function_1 = new Functions.Function1<EStructuralFeature, EClassifier>(){

            public EClassifier apply(EStructuralFeature it) {
                return it.getEType();
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        List classifiers = IterableExtensions.toList((Iterable)_map);
        Iterable<EClass> _subClasses = Ecore2XtextExtensions.subClasses(eClazz);
        Iterables.addAll((Collection)classifiers, _subClasses);
        classifiers.removeAll(acceptor);
        boolean _isEmpty = classifiers.isEmpty();
        if (_isEmpty) {
            return;
        }
        Iterables.addAll(acceptor, (Iterable)classifiers);
        Iterable _filter_1 = Iterables.filter((Iterable)classifiers, EClass.class);
        Procedures.Procedure1<EClass> _function_2 = new Procedures.Procedure1<EClass>(){

            public void apply(EClass c) {
                Ecore2XtextExtensions.allAssignedClassifiers(c, acceptor);
            }
        };
        IterableExtensions.forEach((Iterable)_filter_1, (Procedures.Procedure1)_function_2);
    }

    public static String fqn(EClassifier it) {
        boolean _equals;
        String _xifexpression = null;
        EPackage _ePackage = it.getEPackage();
        String _uniqueName = null;
        if (_ePackage != null) {
            _uniqueName = UniqueNameUtil.uniqueName((ENamedElement)_ePackage);
        }
        if (_equals = Objects.equal((Object)_uniqueName, null)) {
            String _name = it.getName();
            _xifexpression = Ecore2XtextExtensions.quoteIfNeccesary(_name);
        } else {
            EPackage _ePackage_1 = it.getEPackage();
            String _uniqueName_1 = UniqueNameUtil.uniqueName((ENamedElement)_ePackage_1);
            String _plus = String.valueOf(_uniqueName_1) + "::";
            String _name_1 = it.getName();
            String _quoteIfNeccesary = Ecore2XtextExtensions.quoteIfNeccesary(_name_1);
            _xifexpression = String.valueOf(_plus) + _quoteIfNeccesary;
        }
        return _xifexpression;
    }

    public static Iterable<EStructuralFeature> prefixFeatures(EClass it) {
        EList _eAllStructuralFeatures = it.getEAllStructuralFeatures();
        Functions.Function1<EStructuralFeature, Boolean> _function = new Functions.Function1<EStructuralFeature, Boolean>(){

            public Boolean apply(EStructuralFeature f) {
                boolean _isPrefixBooleanFeature;
                boolean _and = false;
                boolean _needsAssignment = Ecore2XtextExtensions.needsAssignment(f);
                _and = !_needsAssignment ? false : (_isPrefixBooleanFeature = Ecore2XtextExtensions.isPrefixBooleanFeature(f));
                return _and;
            }
        };
        return IterableExtensions.filter((Iterable)_eAllStructuralFeatures, (Functions.Function1)_function);
    }

    public static Iterable<EStructuralFeature> inlinedFeatures(EClass it) {
        EList _eAllStructuralFeatures = it.getEAllStructuralFeatures();
        Functions.Function1<EStructuralFeature, Boolean> _function = new Functions.Function1<EStructuralFeature, Boolean>(){

            public Boolean apply(EStructuralFeature f) {
                return Ecore2XtextExtensions.needsAssignment(f);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_eAllStructuralFeatures, (Functions.Function1)_function);
        List features = IterableExtensions.toList((Iterable)_filter);
        EAttribute _idAttribute = Ecore2XtextExtensions.idAttribute(it);
        features.remove(_idAttribute);
        Iterable<EStructuralFeature> _prefixFeatures = Ecore2XtextExtensions.prefixFeatures(it);
        List _list = IterableExtensions.toList(_prefixFeatures);
        features.removeAll(_list);
        return features;
    }

    public static boolean onlyOptionalFeatures(EClass it) {
        boolean _xblockexpression = false;
        Iterable<EStructuralFeature> _prefixFeatures = Ecore2XtextExtensions.prefixFeatures(it);
        Iterable<EStructuralFeature> _inlinedFeatures = Ecore2XtextExtensions.inlinedFeatures(it);
        Iterable features = Iterables.concat(_prefixFeatures, _inlinedFeatures);
        Functions.Function1<EStructuralFeature, Boolean> _function = new Functions.Function1<EStructuralFeature, Boolean>(){

            public Boolean apply(EStructuralFeature f) {
                return f.isRequired();
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)features, (Functions.Function1)_function);
        _xblockexpression = IterableExtensions.isEmpty((Iterable)_filter);
        return _xblockexpression;
    }

    public static String assignedRuleCall(EAttribute it) {
        String _xifexpression = null;
        boolean _isPrefixBooleanFeature = Ecore2XtextExtensions.isPrefixBooleanFeature((EStructuralFeature)it);
        if (_isPrefixBooleanFeature) {
            String _name = it.getName();
            String _plus = "'" + _name;
            _xifexpression = String.valueOf(_plus) + "'";
        } else {
            EClassifier _eType = it.getEType();
            _xifexpression = UniqueNameUtil.uniqueName((ENamedElement)_eType);
        }
        return _xifexpression;
    }

    public static String concreteRuleName(EClass it) {
        String _xifexpression = null;
        boolean _needsDispatcherRule = Ecore2XtextExtensions.needsDispatcherRule((EClassifier)it);
        _xifexpression = _needsDispatcherRule ? UniqueNameUtil.uniqueImplName((ENamedElement)it) : UniqueNameUtil.uniqueName((ENamedElement)it);
        return _xifexpression;
    }

    public static String dataTypeRuleBody(EDataType it) {
        String _switchResult = null;
        String _name = it.getName();
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)_name, (Object)"EBigDecimal")) {
            _matched = true;
            _switchResult = "INT? '.' INT";
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"EBigInteger")) {
            _matched = true;
            _switchResult = Ecore2XtextExtensions.intRuleBody();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"EBoolean")) {
            _matched = true;
            _switchResult = Ecore2XtextExtensions.booleanRuleBody();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"EBooleanObject")) {
            _matched = true;
            _switchResult = Ecore2XtextExtensions.booleanRuleBody();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"EByte")) {
            _matched = true;
            _switchResult = Ecore2XtextExtensions.intRuleBody();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"EByteObject")) {
            _matched = true;
            _switchResult = Ecore2XtextExtensions.intRuleBody();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"EChar")) {
            _matched = true;
            _switchResult = Ecore2XtextExtensions.intRuleBody();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"ECharObject")) {
            _matched = true;
            _switchResult = Ecore2XtextExtensions.intRuleBody();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"EDouble")) {
            _matched = true;
            _switchResult = Ecore2XtextExtensions.decimalRuleBody();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"EDoubleObject")) {
            _matched = true;
            _switchResult = Ecore2XtextExtensions.decimalRuleBody();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"EFloat")) {
            _matched = true;
            _switchResult = Ecore2XtextExtensions.decimalRuleBody();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"EFloatObject")) {
            _matched = true;
            _switchResult = Ecore2XtextExtensions.decimalRuleBody();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"EInt")) {
            _matched = true;
            _switchResult = Ecore2XtextExtensions.intRuleBody();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"EIntegerObject")) {
            _matched = true;
            _switchResult = Ecore2XtextExtensions.intRuleBody();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"ELong")) {
            _matched = true;
            _switchResult = Ecore2XtextExtensions.intRuleBody();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"ELongObject")) {
            _matched = true;
            _switchResult = Ecore2XtextExtensions.intRuleBody();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"EShort")) {
            _matched = true;
            _switchResult = Ecore2XtextExtensions.intRuleBody();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"EShortObject")) {
            _matched = true;
            _switchResult = Ecore2XtextExtensions.intRuleBody();
        }
        if (!_matched && Objects.equal((Object)_name, (Object)"EString")) {
            _matched = true;
            _switchResult = "STRING | ID";
        }
        if (!_matched) {
            String _name_1 = it.getName();
            String _plus = "'" + _name_1;
            _switchResult = String.valueOf(_plus) + "' /* TODO: implement this rule and an appropriate IValueConverter */";
        }
        return _switchResult;
    }

    public static String intRuleBody() {
        return "'-'? INT";
    }

    public static String decimalRuleBody() {
        return "'-'? INT? '.' INT (('E'|'e') '-'? INT)?";
    }

    public static String booleanRuleBody() {
        return "'true' | 'false'";
    }

    public static String assignmentKeyword(EStructuralFeature it) {
        String _xifexpression = null;
        boolean _isPrefixBooleanFeature = Ecore2XtextExtensions.isPrefixBooleanFeature(it);
        if (_isPrefixBooleanFeature) {
            _xifexpression = "";
        } else {
            String _name = it.getName();
            String _plus = "'" + _name;
            _xifexpression = String.valueOf(_plus) + "' ";
        }
        return _xifexpression;
    }

    public static String quoteIfNeccesary(String str) {
        String _xifexpression = null;
        boolean _isXtextKeyword = Ecore2XtextExtensions.isXtextKeyword(str);
        _xifexpression = _isXtextKeyword ? "^" + str : str;
        return _xifexpression;
    }

    public static boolean isXtextKeyword(String str) {
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new String[]{"returns", "generate", "terminal", "with", "hidden", "enum", "grammar", "import", "as", "current", "fragment", "EOF"});
        return _newArrayList.contains(str);
    }

    public static EAttribute idAttribute(EClass it) {
        boolean _notEquals;
        EAttribute _xblockexpression = null;
        EAttribute idAttr = Ecore2XtextExtensions.idAttributeInternal(it);
        EAttribute _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)idAttr, null);
        if (_notEquals) {
            _xifexpression = idAttr;
        } else {
            EList _eAllAttributes = it.getEAllAttributes();
            Functions.Function1<EAttribute, Boolean> _function = new Functions.Function1<EAttribute, Boolean>(){

                public Boolean apply(EAttribute a) {
                    boolean _isMany;
                    boolean _not;
                    boolean _and = false;
                    boolean _and_1 = false;
                    boolean _and_2 = false;
                    boolean _needsAssignment = Ecore2XtextExtensions.needsAssignment((EStructuralFeature)a);
                    if (!_needsAssignment) {
                        _and_2 = false;
                    } else {
                        boolean _equals;
                        String _name = a.getName();
                        _and_2 = _equals = Objects.equal((Object)_name, (Object)"name");
                    }
                    if (!_and_2) {
                        _and_1 = false;
                    } else {
                        boolean _equals_1;
                        EClassifier _eType = a.getEType();
                        String _name_1 = _eType.getName();
                        _and_1 = _equals_1 = Objects.equal((Object)_name_1, (Object)"EString");
                    }
                    _and = !_and_1 ? false : (_not = !(_isMany = a.isMany()));
                    return _and;
                }
            };
            _xifexpression = (EAttribute)IterableExtensions.findFirst((Iterable)_eAllAttributes, (Functions.Function1)_function);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private static EAttribute idAttributeInternal(EClass it) {
        EList _eAllAttributes = it.getEAllAttributes();
        Functions.Function1<EAttribute, Boolean> _function = new Functions.Function1<EAttribute, Boolean>(){

            public Boolean apply(EAttribute a) {
                boolean _isID;
                boolean _and = false;
                boolean _needsAssignment = Ecore2XtextExtensions.needsAssignment((EStructuralFeature)a);
                _and = !_needsAssignment ? false : (_isID = a.isID());
                return _and;
            }
        };
        return (EAttribute)IterableExtensions.findFirst((Iterable)_eAllAttributes, (Functions.Function1)_function);
    }

    public static boolean isBoolean(EClassifier it) {
        boolean _isEcoreType;
        boolean _and = false;
        boolean _and_1 = false;
        if (!(it instanceof EDataType)) {
            _and_1 = false;
        } else {
            boolean _contains;
            ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new String[]{"EBoolean", "EBooleanObject"});
            String _name = it.getName();
            _and_1 = _contains = _newArrayList.contains(_name);
        }
        _and = !_and_1 ? false : (_isEcoreType = Ecore2XtextExtensions.isEcoreType(it));
        return _and;
    }

    public static boolean isPrefixBooleanFeature(EStructuralFeature it) {
        String _defaultValueLiteral;
        boolean _notEquals;
        boolean _isMany;
        boolean _not;
        boolean _and = false;
        boolean _and_1 = false;
        EClassifier _eType = it.getEType();
        boolean _isBoolean = Ecore2XtextExtensions.isBoolean(_eType);
        _and_1 = !_isBoolean ? false : (_not = !(_isMany = it.isMany()));
        _and = !_and_1 ? false : (_notEquals = !Objects.equal((Object)(_defaultValueLiteral = it.getDefaultValueLiteral()), (Object)"true"));
        return _and;
    }

    public static boolean isString(EClassifier it) {
        boolean _isEcoreType;
        boolean _and = false;
        boolean _and_1 = false;
        if (!(it instanceof EDataType)) {
            _and_1 = false;
        } else {
            boolean _equals;
            String _name = it.getName();
            _and_1 = _equals = Objects.equal((Object)_name, (Object)"EString");
        }
        _and = !_and_1 ? false : (_isEcoreType = Ecore2XtextExtensions.isEcoreType(it));
        return _and;
    }

    public static boolean isEcoreType(EClassifier it) {
        EPackage _ePackage = it.getEPackage();
        String _nsURI = null;
        if (_ePackage != null) {
            _nsURI = _ePackage.getNsURI();
        }
        return Objects.equal((Object)_nsURI, (Object)"http://www.eclipse.org/emf/2002/Ecore");
    }

    public static boolean isID(EStructuralFeature it) {
        boolean _and = false;
        if (!(it instanceof EAttribute)) {
            _and = false;
        } else {
            boolean _isID;
            EAttribute _cast = (EAttribute)EAttribute.class.cast(it);
            _and = _isID = _cast.isID();
        }
        return _and;
    }

    public static boolean needsAssignment(EStructuralFeature it) {
        boolean _isTransient;
        boolean _not_1;
        boolean _not;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        boolean _isDerived = it.isDerived();
        boolean bl = _not = !_isDerived;
        _and_2 = !_not ? false : (_not_1 = !(_isTransient = it.isTransient()));
        if (!_and_2) {
            _and_1 = false;
        } else {
            boolean _not_2;
            boolean _and_3 = false;
            if (!(it instanceof EReference)) {
                _and_3 = false;
            } else {
                boolean _isContainer;
                EReference _cast = (EReference)EReference.class.cast(it);
                _and_3 = _isContainer = _cast.isContainer();
            }
            _and_1 = _not_2 = !_and_3;
        }
        if (!_and_1) {
            _and = false;
        } else {
            boolean _not_4;
            EClassifier _eType_1;
            EDataType _cast_1;
            boolean _isSerializable;
            boolean _not_3;
            boolean _and_4 = false;
            EClassifier _eType = it.getEType();
            _and_4 = !(_eType instanceof EDataType) ? false : (_not_3 = !(_isSerializable = (_cast_1 = (EDataType)EDataType.class.cast(_eType_1 = it.getEType())).isSerializable()));
            _and = _not_4 = !_and_4;
        }
        return _and;
    }

    public static boolean needsConcreteRule(EClassifier eClassifier) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (!_matched && eClassifier instanceof EClass) {
            boolean _isInterface;
            boolean _not_1;
            boolean _not;
            _matched = true;
            boolean _and = false;
            boolean _isAbstract = ((EClass)eClassifier).isAbstract();
            boolean bl = _not = !_isAbstract;
            _and = !_not ? false : (_not_1 = !(_isInterface = ((EClass)eClassifier).isInterface()));
            _switchResult = _and;
        }
        if (!_matched) {
            _switchResult = true;
        }
        return _switchResult;
    }

    public static boolean needsDispatcherRule(EClassifier eClassifier) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (!_matched && eClassifier instanceof EClass) {
            Functions.Function1<EClass, Boolean> _function;
            _matched = true;
            Iterable<EClass> _subClasses = Ecore2XtextExtensions.subClasses((EClass)eClassifier);
            Iterable _filter = IterableExtensions.filter(_subClasses, (Functions.Function1)(_function = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass c) {
                    return Ecore2XtextExtensions.needsConcreteRule((EClassifier)c);
                }
            }));
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter);
            boolean bl = _switchResult = !_isEmpty;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static boolean isContainment(EStructuralFeature eStrFeat) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (!_matched && eStrFeat instanceof EAttribute) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && eStrFeat instanceof EReference) {
            _matched = true;
            _switchResult = ((EReference)eStrFeat).isContainment();
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static Iterable<EClass> subClasses(final EClass it) {
        Iterable _xifexpression = null;
        EPackage _ePackage = it.getEPackage();
        boolean _equals = Objects.equal((Object)_ePackage, null);
        if (_equals) {
            _xifexpression = CollectionLiterals.emptyList();
        } else {
            EPackage _ePackage_1 = it.getEPackage();
            EList _eClassifiers = _ePackage_1.getEClassifiers();
            Iterable _filter = Iterables.filter((Iterable)_eClassifiers, EClass.class);
            Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass c) {
                    EList _eAllSuperTypes = c.getEAllSuperTypes();
                    return _eAllSuperTypes.contains((Object)it);
                }
            };
            _xifexpression = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
        }
        return _xifexpression;
    }

    public static Iterable<EAttribute> allAttributes(EClass it) {
        Iterable<EStructuralFeature> _inlinedFeatures = Ecore2XtextExtensions.inlinedFeatures(it);
        return Iterables.filter(_inlinedFeatures, EAttribute.class);
    }

    public static Iterable<EReference> allCrossReferences(EClass it) {
        Iterable<EStructuralFeature> _inlinedFeatures = Ecore2XtextExtensions.inlinedFeatures(it);
        Iterable _filter = Iterables.filter(_inlinedFeatures, EReference.class);
        Functions.Function1<EReference, Boolean> _function = new Functions.Function1<EReference, Boolean>(){

            public Boolean apply(EReference f) {
                boolean _isContainment = f.isContainment();
                return !_isContainment;
            }
        };
        return IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
    }

    public static Iterable<EReference> allContainmentReferences(EClass it) {
        Iterable<EStructuralFeature> _inlinedFeatures = Ecore2XtextExtensions.inlinedFeatures(it);
        Iterable _filter = Iterables.filter(_inlinedFeatures, EReference.class);
        Functions.Function1<EReference, Boolean> _function = new Functions.Function1<EReference, Boolean>(){

            public Boolean apply(EReference f) {
                return f.isContainment();
            }
        };
        return IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
    }
}

