/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.build;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@FinalFieldsConstructor
public class Source2GeneratedMapping
implements Externalizable {
    private final Multimap<URI, URI> source2generated;
    private final Multimap<URI, URI> generated2source;
    private final Map<URI, String> generated2OutputConfigName;

    public Source2GeneratedMapping() {
        this((Multimap<URI, URI>)HashMultimap.create(), (Multimap<URI, URI>)HashMultimap.create(), CollectionLiterals.newHashMap((Pair[])new Pair[0]));
    }

    public Source2GeneratedMapping copy() {
        HashMultimap _create = HashMultimap.create(this.source2generated);
        HashMultimap _create_1 = HashMultimap.create(this.generated2source);
        HashMap<URI, String> _hashMap = new HashMap<URI, String>(this.generated2OutputConfigName);
        return new Source2GeneratedMapping((Multimap<URI, URI>)_create, (Multimap<URI, URI>)_create_1, _hashMap);
    }

    public void addSource2Generated(URI source, URI generated) {
        this.addSource2Generated(source, generated, "DEFAULT_OUTPUT");
    }

    public void addSource2Generated(URI source, URI generated, String outputCfgName) {
        this.source2generated.put((Object)source, (Object)generated);
        this.generated2source.put((Object)generated, (Object)source);
        this.generated2OutputConfigName.put(generated, outputCfgName);
    }

    public void removeSource2Generated(URI source, URI generated) {
        this.source2generated.remove((Object)source, (Object)generated);
        this.generated2source.remove((Object)generated, (Object)source);
    }

    public Set<URI> deleteSource(final URI source) {
        Collection _removeAll = this.source2generated.removeAll((Object)source);
        HashSet<URI> generated = new HashSet<URI>(_removeAll);
        Procedures.Procedure1<URI> _function = new Procedures.Procedure1<URI>(){

            public void apply(URI it) {
                Source2GeneratedMapping.this.generated2source.remove((Object)it, (Object)source);
            }
        };
        IterableExtensions.forEach(generated, (Procedures.Procedure1)_function);
        return generated;
    }

    public void deleteGenerated(final URI generated) {
        Collection _removeAll = this.generated2source.removeAll((Object)generated);
        Procedures.Procedure1<URI> _function = new Procedures.Procedure1<URI>(){

            public void apply(URI it) {
                Source2GeneratedMapping.this.source2generated.remove((Object)it, (Object)generated);
            }
        };
        IterableExtensions.forEach((Iterable)_removeAll, (Procedures.Procedure1)_function);
        this.generated2OutputConfigName.remove(generated);
    }

    public String getOutputConfigName(URI generated) {
        return this.generated2OutputConfigName.get(generated);
    }

    public List<URI> getGenerated(URI source) {
        Collection _get = this.source2generated.get((Object)source);
        return Lists.newArrayList((Iterable)_get);
    }

    public List<URI> getSource(URI generated) {
        Collection _get = this.generated2source.get((Object)generated);
        return Lists.newArrayList((Iterable)_get);
    }

    public List<URI> getAllGenerated() {
        Set _keySet = this.generated2source.keySet();
        return Lists.newArrayList((Iterable)_keySet);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int numEntries = in.readInt();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, numEntries, true);
        for (Integer i : _doubleDotLessThan) {
            String _readUTF = in.readUTF();
            URI source = URI.createURI((String)_readUTF);
            int numGenerated = in.readInt();
            ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, numGenerated, true);
            for (Integer j : _doubleDotLessThan_1) {
                String _readUTF_1 = in.readUTF();
                URI generated = URI.createURI((String)_readUTF_1);
                String outputConfig = in.readUTF();
                this.addSource2Generated(source, generated, outputConfig);
            }
        }
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        Map _asMap = this.source2generated.asMap();
        Set entries = _asMap.entrySet();
        int _size = entries.size();
        out.writeInt(_size);
        Procedures.Procedure1<Map.Entry<URI, Collection<URI>>> _function = new Procedures.Procedure1<Map.Entry<URI, Collection<URI>>>(){

            public void apply(Map.Entry<URI, Collection<URI>> it) {
                try {
                    URI _key = it.getKey();
                    String _string = _key.toString();
                    out.writeUTF(_string);
                    Collection<URI> _value = it.getValue();
                    int _size = _value.size();
                    out.writeInt(_size);
                    Collection<URI> _value_1 = it.getValue();
                    Procedures.Procedure1<URI> _function = new Procedures.Procedure1<URI>(){

                        public void apply(URI it) {
                            try {
                                String _string = it.toString();
                                out.writeUTF(_string);
                                String _elvis = null;
                                String _get = (String)Source2GeneratedMapping.this.generated2OutputConfigName.get(it);
                                _elvis = _get != null ? _get : "DEFAULT_OUTPUT";
                                out.writeUTF(_elvis);
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        }
                    };
                    IterableExtensions.forEach(_value_1, (Procedures.Procedure1)_function);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        IterableExtensions.forEach(entries, (Procedures.Procedure1)_function);
    }

    public Source2GeneratedMapping(Multimap<URI, URI> source2generated, Multimap<URI, URI> generated2source, Map<URI, String> generated2OutputConfigName) {
        this.source2generated = source2generated;
        this.generated2source = generated2source;
        this.generated2OutputConfigName = generated2OutputConfigName;
    }
}

