/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.serializer;

import com.google.inject.Inject;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.generator.Naming;

public class SerializerGenFileNames {
    private GenFileName abstractSemanticSequencer;
    private GenFileName abstractSyntacticSequencer;
    private GenFileName grammarConstraints;
    private GenFileName semanticSequencer;
    private GenFileName syntacticSequencer;

    @Inject
    public SerializerGenFileNames(Naming naming, Grammar grammar) {
        this.semanticSequencer = new GenFileName(grammar, naming, false, "SemanticSequencer", "java");
        this.syntacticSequencer = new GenFileName(grammar, naming, false, "SyntacticSequencer", "java");
        this.abstractSemanticSequencer = new GenFileName(grammar, naming, true, "SemanticSequencer", "java");
        this.abstractSyntacticSequencer = new GenFileName(grammar, naming, true, "SyntacticSequencer", "java");
        this.grammarConstraints = new GenFileName(grammar, naming, false, "GrammarConstraints", "xtext");
    }

    public GenFileName getAbstractSemanticSequencer() {
        return this.abstractSemanticSequencer;
    }

    public GenFileName getAbstractSyntacticSequencer() {
        return this.abstractSyntacticSequencer;
    }

    public GenFileName getGrammarConstraints() {
        return this.grammarConstraints;
    }

    public GenFileName getSemanticSequencer() {
        return this.semanticSequencer;
    }

    public GenFileName getSyntacticSequencer() {
        return this.syntacticSequencer;
    }

    public class GenFileName {
        private boolean _abstract;
        private String component;
        private String fileext;
        private Grammar grammar;
        private Naming naming;

        public GenFileName(Grammar grammar, Naming naming, boolean _abstract, String component, String fileext) {
            this.grammar = grammar;
            this.naming = naming;
            this._abstract = _abstract;
            this.component = component;
            this.fileext = fileext;
        }

        public String getFileName() {
            return String.valueOf(this.naming.asPath(this.getQualifiedName())) + "." + this.fileext;
        }

        protected String getName(Grammar grammar, String component) {
            String prefix = this._abstract ? "Abstract" : "";
            return String.valueOf(this.naming.basePackageRuntime(grammar)) + ".serializer." + prefix + this.naming.toSimpleName(grammar.getName()) + component;
        }

        public String getPackageName() {
            return this.naming.toPackageName(this.getQualifiedName());
        }

        public String getQualifiedName() {
            return this.getName(this.grammar, this.component);
        }

        public String getQualifiedName(Grammar grammar) {
            return this.getName(grammar, this.component);
        }

        public String getSimpleName() {
            return this.naming.toSimpleName(this.getQualifiedName());
        }

        public String getSimpleName(Grammar grammar) {
            return this.naming.toSimpleName(this.getQualifiedName(grammar));
        }

        public boolean isAbstract() {
            return this._abstract;
        }
    }
}

