/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.contentassist;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.ide.contentassist.AbstractXtendProposalProvider;
import org.eclipse.xtend.ide.contentassist.ImplementMemberFromSuperAssist;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.xtext.ui.ITypesProposalProvider;
import org.eclipse.xtext.common.types.xtext.ui.JdtVariableCompletions;
import org.eclipse.xtext.common.types.xtext.ui.TypeMatchFilters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.util.SimpleAttributeResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendProposalProvider
extends AbstractXtendProposalProvider {
    @Inject
    private JdtVariableCompletions completions;
    @Inject
    private IGrammarAccess grammarAccess;
    @Inject
    private ImplementMemberFromSuperAssist overrideAssist;

    @Override
    public void completeMember_Name(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (model instanceof XtendField) {
            List siblings = EcoreUtil2.getSiblingsOfType((EObject)model, XtendField.class);
            HashSet alreadyTaken = Sets.newHashSet((Iterable)Lists.transform((List)siblings, (Function)SimpleAttributeResolver.NAME_RESOLVER));
            alreadyTaken.addAll(this.getAllKeywords());
            this.completions.getVariableProposals(model, XtendPackage.Literals.XTEND_FIELD__TYPE, JdtVariableCompletions.VariableType.INSTANCE_FIELD, (Set)alreadyTaken, new JdtVariableCompletions.CompletionDataAcceptor(){

                public void accept(String replaceText, StyledString label, Image img) {
                    acceptor.accept(XtendProposalProvider.this.createCompletionProposal(replaceText, label, img, context));
                }
            });
        } else {
            super.completeMember_Name(model, assignment, context, acceptor);
        }
    }

    @Override
    public void completeMember_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof XtendField) {
            this.completeJavaTypes(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, true, (IValueConverter)this.getQualifiedNameValueConverter(), (ITypesProposalProvider.Filter)new TypeMatchFilters.All(0), acceptor);
        }
    }

    @Override
    public void completeMember_ReturnType(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, true, (IValueConverter)this.getQualifiedNameValueConverter(), (ITypesProposalProvider.Filter)new TypeMatchFilters.All(0), acceptor);
    }

    protected Set<String> getAllKeywords() {
        return GrammarUtil.getAllKeywords((Grammar)this.grammarAccess.getGrammar());
    }

    @Override
    public void completeParameter_Name(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (model instanceof XtendParameter) {
            List siblings = EcoreUtil2.getSiblingsOfType((EObject)model, XtendParameter.class);
            HashSet alreadyTaken = Sets.newHashSet((Iterable)Lists.transform((List)siblings, (Function)SimpleAttributeResolver.NAME_RESOLVER));
            alreadyTaken.addAll(this.getAllKeywords());
            this.completions.getVariableProposals(model, XtendPackage.Literals.XTEND_PARAMETER__PARAMETER_TYPE, JdtVariableCompletions.VariableType.PARAMETER, (Set)alreadyTaken, new JdtVariableCompletions.CompletionDataAcceptor(){

                public void accept(String replaceText, StyledString label, Image img) {
                    acceptor.accept(XtendProposalProvider.this.createCompletionProposal(replaceText, label, img, context));
                }
            });
        } else {
            super.completeParameter_Name(model, assignment, context, acceptor);
        }
    }

    protected Predicate<IEObjectDescription> getFeatureDescriptionPredicate(ContentAssistContext contentAssistContext) {
        if (contentAssistContext.getPrefix().startsWith("_")) {
            return super.getFeatureDescriptionPredicate(contentAssistContext);
        }
        final Predicate delegate = super.getFeatureDescriptionPredicate(contentAssistContext);
        return new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                return !input.getName().getFirstSegment().startsWith("_") && delegate.apply((Object)input);
            }
        };
    }

    @Override
    public void completeType_Extends(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, true, (IValueConverter)this.getQualifiedNameValueConverter(), new ITypesProposalProvider.Filter(){

            public int getSearchFor() {
                return 5;
            }

            public boolean accept(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                if (TypeMatchFilters.isInternalClass((char[])simpleTypeName, (char[][])enclosingTypeNames)) {
                    return false;
                }
                return !Flags.isFinal((int)modifiers);
            }
        }, acceptor);
    }

    @Override
    public void completeType_Implements(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, true, (IValueConverter)this.getQualifiedNameValueConverter(), TypeMatchFilters.all((int)6), acceptor);
    }

    @Override
    public void completeType_Members(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof XtendClass) {
            this.overrideAssist.createOverrideProposals((XtendClass)model, context, acceptor, this.getConflictHelper());
        }
        super.completeType_Members(model, assignment, context, acceptor);
    }

    protected void addGuillemotsProposal(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        acceptor.accept((ICompletionProposal)new ConfigurableCompletionProposal("\u00ab\u00bb", context.getOffset(), context.getSelectedText().length(), 1));
    }

    public void completeInRichString(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        INode node = context.getCurrentNode();
        int offset = node.getOffset();
        int length = node.getLength();
        String currentNodeText = node.getText();
        if (currentNodeText.startsWith("\u00bb") && offset + 1 <= context.getOffset() || currentNodeText.startsWith("'''") && offset + 3 <= context.getOffset()) {
            if (context.getOffset() > offset && context.getOffset() < offset + length) {
                this.addGuillemotsProposal(context, acceptor);
            }
        } else if (currentNodeText.startsWith("\u00ab\u00ab")) {
            try {
                IDocument document = context.getViewer().getDocument();
                int nodeLine = document.getLineOfOffset(offset);
                int completionLine = document.getLineOfOffset(context.getOffset());
                if (completionLine > nodeLine) {
                    this.addGuillemotsProposal(context, acceptor);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void completeXFeatureCall_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof XtendField) {
            this.createLocalVariableAndImplicitProposals(model, context, acceptor);
        } else {
            super.completeXFeatureCall_Feature(model, assignment, context, acceptor);
        }
    }

    @Override
    public void complete_RICH_TEXT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeInRichString(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_RICH_TEXT_START(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeInRichString(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_RICH_TEXT_END(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeInRichString(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_RICH_TEXT_INBETWEEN(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeInRichString(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_COMMENT_RICH_TEXT_END(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeInRichString(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_COMMENT_RICH_TEXT_INBETWEEN(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeInRichString(model, ruleCall, context, acceptor);
    }
}

