/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.hover;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.util.XbaseSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendHoverSerializer
implements IFeatureNames {
    private static final String STATICDELIMITER = "::";
    private static final String SEPARATOR = ", ";
    private static final String DELIMITER = ".";

    public String computeUnsugaredExpression(EObject object) {
        if (object instanceof XAbstractFeatureCall) {
            StringBuilder stringBuilder = new StringBuilder();
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)object;
            JvmIdentifiableElement feature = featureCall.getFeature();
            if (feature != null && !feature.eIsProxy()) {
                JvmOperation jvmOperation;
                if (featureCall instanceof XMemberFeatureCall && feature instanceof JvmOperation && (jvmOperation = (JvmOperation)feature).isStatic()) {
                    return stringBuilder.append(this.getStaticCallDesugaredVersion(featureCall, (JvmMember)jvmOperation)).toString();
                }
                if (featureCall.getImplicitReceiver() != null || featureCall.getImplicitFirstArgument() != null) {
                    if (featureCall.isStatic()) {
                        return stringBuilder.append(this.getStaticCallDesugaredVersion(featureCall, (JvmMember)feature)).toString();
                    }
                    XExpression receiver = featureCall.getActualReceiver();
                    if (receiver instanceof XMemberFeatureCall) {
                        stringBuilder.append(THIS).append(DELIMITER);
                        stringBuilder.append(((XMemberFeatureCall)receiver).getFeature().getSimpleName()).append(DELIMITER);
                    } else if (receiver instanceof XAbstractFeatureCall) {
                        JvmIdentifiableElement receiverFeature = ((XAbstractFeatureCall)receiver).getFeature();
                        if (receiverFeature.getSimpleName().equals(IT.toString())) {
                            stringBuilder.append(IT).append(DELIMITER);
                        }
                        if (receiverFeature == feature.eContainer()) {
                            stringBuilder.append(THIS).append(DELIMITER);
                        }
                    }
                    stringBuilder.append(feature.getSimpleName());
                    if (feature instanceof JvmExecutable) {
                        stringBuilder.append(this.computeArguments(featureCall));
                    }
                    return stringBuilder.toString();
                }
            }
        }
        return "";
    }

    protected String getStaticCallDesugaredVersion(XAbstractFeatureCall featureCall, JvmMember jvmMember) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(jvmMember.getDeclaringType().getSimpleName());
        stringBuilder.append(STATICDELIMITER);
        stringBuilder.append(jvmMember.getSimpleName());
        stringBuilder.append(this.computeArguments(featureCall));
        return stringBuilder.toString();
    }

    public String computeArguments(XAbstractFeatureCall featureCall) {
        StringBuilder stringBuilder = new StringBuilder("(");
        if (featureCall != null) {
            int start;
            XtendHoverXbaseSwitch xbaseSwitch;
            String doSwitch;
            XExpression implicitFirstArgument = featureCall.getImplicitFirstArgument();
            EList arguments = featureCall.getActualArguments();
            if (implicitFirstArgument != null && (doSwitch = ((String)(xbaseSwitch = new XtendHoverXbaseSwitch()).doSwitch((EObject)implicitFirstArgument)).trim()) != null) {
                stringBuilder.append(doSwitch);
            }
            int i = start = implicitFirstArgument != null ? 1 : 0;
            while (i < arguments.size()) {
                XExpression expression;
                ICompositeNode node;
                if (i != 0) {
                    stringBuilder.append(SEPARATOR);
                }
                if ((node = NodeModelUtils.findActualNodeFor((EObject)(expression = (XExpression)arguments.get(i)))) != null) {
                    stringBuilder.append(node.getText().trim());
                }
                ++i;
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public Pair<String, String> computePreAndSuffix(EObject element) {
        IParseResult parseResult;
        XtextResource resource;
        ICompositeNode node = NodeModelUtils.getNode((EObject)element);
        if (node != null && (resource = (XtextResource)element.eResource()) != null && (parseResult = resource.getParseResult()) != null) {
            String model = parseResult.getRootNode().getText();
            return Tuples.create((Object)(String.valueOf(model.substring(0, node.getTotalOffset())) + "\n"), (Object)("\n" + model.substring(node.getTotalEndOffset())));
        }
        return Tuples.create((Object)"", (Object)"");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class XtendHoverXbaseSwitch
    extends XbaseSwitch<String> {
        private XtendHoverXbaseSwitch() {
        }

        public String caseXAbstractFeatureCall(XAbstractFeatureCall object) {
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)object);
            if (node != null) {
                return node.getText();
            }
            return object.getFeature().getSimpleName();
        }

        public String caseXExpression(XExpression object) {
            ICompositeNode node;
            if (object != null && (node = NodeModelUtils.findActualNodeFor((EObject)object)) != null) {
                return node.getText();
            }
            return "";
        }
    }
}

