/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public abstract class BucketedEObjectDescription
extends EObjectDescription
implements IIdentifiableElementDescription {
    private final int bucketId;
    private final boolean visible;

    protected BucketedEObjectDescription(QualifiedName qualifiedName, JvmIdentifiableElement feature, int bucketId, boolean visible) {
        super(qualifiedName, (EObject)feature, null);
        this.bucketId = bucketId;
        this.visible = visible;
    }

    @Override
    public String getShadowingKey() {
        EObject object = this.getEObjectOrProxy();
        if (object instanceof JvmIdentifiableElement) {
            JvmIdentifiableElement identifiable = (JvmIdentifiableElement)object;
            StringBuilder builder = new StringBuilder(identifiable.getSimpleName());
            if (object instanceof JvmExecutable) {
                JvmExecutable executable = (JvmExecutable)object;
                builder.append('(');
                boolean first = true;
                for (JvmFormalParameter parameter : executable.getParameters()) {
                    if (!first) {
                        builder.append(',');
                    } else {
                        first = false;
                    }
                    if (parameter.getParameterType() != null && parameter.getParameterType().getType() != null) {
                        builder.append(parameter.getParameterType().getType().getIdentifier());
                        continue;
                    }
                    builder.append("null");
                }
                builder.append(')');
            }
            if (this.getImplicitFirstArgument() != null) {
                builder.append(":implicitFirstArgument");
            }
            if (this.getImplicitReceiver() != null) {
                builder.append(":implicitReceiver");
            }
            if (this.isVisible()) {
                builder.append('+');
            } else {
                builder.append('-');
            }
            return builder.toString();
        }
        return String.valueOf(this.getName().toString()) + (this.isVisible() ? (char)'+' : '-');
    }

    @Override
    public int getBucketId() {
        return this.bucketId;
    }

    @Override
    @Nullable
    public LightweightTypeReference getImplicitReceiverType() {
        return null;
    }

    @Override
    @Nullable
    public XExpression getImplicitReceiver() {
        return null;
    }

    @Override
    public Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getImplicitReceiverTypeParameterMapping() {
        return Collections.emptyMap();
    }

    @Override
    public EnumSet<ConformanceHint> getImplicitReceiverConformanceHints() {
        return EnumSet.noneOf(ConformanceHint.class);
    }

    @Override
    @Nullable
    public LightweightTypeReference getSyntacticReceiverType() {
        return null;
    }

    @Override
    @Nullable
    public XExpression getSyntacticReceiver() {
        return null;
    }

    @Override
    public Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getSyntacticReceiverTypeParameterMapping() {
        return Collections.emptyMap();
    }

    @Override
    public EnumSet<ConformanceHint> getSyntacticReceiverConformanceHints() {
        return EnumSet.noneOf(ConformanceHint.class);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public String toString() {
        return String.format("%s [key: %s]", this.getElementOrProxy().getIdentifier(), this.getShadowingKey());
    }

    @Override
    public JvmIdentifiableElement getElementOrProxy() {
        return (JvmIdentifiableElement)this.getEObjectOrProxy();
    }

    @Override
    @Nullable
    public XExpression getImplicitFirstArgument() {
        return null;
    }

    @Override
    @Nullable
    public LightweightTypeReference getImplicitFirstArgumentType() {
        return null;
    }
}

