/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.typesystem.computation.AbstractClosureTypeHelper;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeAssigner;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.DeferredTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByUnboundSubstitutor;

@NonNullByDefault
public class ClosureWithExpectationHelper
extends AbstractClosureTypeHelper {
    private final JvmOperation operation;
    private FunctionTypeReference expectedClosureType;
    private FunctionTypeReference resultClosureType;

    protected ClosureWithExpectationHelper(XClosure closure, JvmOperation operation, ITypeExpectation expectation, ITypeComputationState state) {
        super(closure, expectation, state);
        this.operation = operation;
        if (operation == null || expectation.getExpectedType() == null) {
            throw new IllegalStateException("Cannot locate appropriate operation for " + this.getClosure());
        }
        this.prepareComputation();
    }

    public JvmOperation getOperation() {
        return this.operation;
    }

    public FunctionTypeReference getExpectedClosureType() {
        return this.expectedClosureType;
    }

    protected void computeTypes() {
        this.prepareResultType();
        if (this.resultClosureType == null) {
            throw new IllegalStateException("Cannot locate appropriate operation for " + this.getClosure());
        }
        LightweightTypeReference expectedReturnType = this.expectedClosureType.getReturnType();
        if (expectedReturnType == null) {
            throw new IllegalStateException("expected return type may not be null");
        }
        ITypeAssigner typeAssigner = this.getState().withRootExpectation(expectedReturnType).assignTypes();
        ITypeComputationState closureBodyTypeComputationState = this.getClosureBodyTypeComputationState(typeAssigner);
        ITypeComputationResult expressionResult = closureBodyTypeComputationState.computeTypes(this.getClosure().getExpression());
        boolean incompatible = this.processExpressionType(expressionResult);
        if (this.resultClosureType.getReturnType() == null) {
            throw new IllegalStateException("Closure has no return type assigned");
        }
        if (this.expectedClosureType.isFunctionType()) {
            if (incompatible) {
                this.getExpectation().acceptActualType(this.resultClosureType, ConformanceHint.CHECKED, ConformanceHint.INCOMPATIBLE, ConformanceHint.PROPAGATED_TYPE);
            } else {
                this.getExpectation().acceptActualType(this.resultClosureType, ConformanceHint.UNCHECKED);
            }
        } else if (incompatible) {
            this.getExpectation().acceptActualType(this.resultClosureType, ConformanceHint.CHECKED, ConformanceHint.INCOMPATIBLE, ConformanceHint.PROPAGATED_TYPE);
        } else {
            this.getExpectation().acceptActualType(this.resultClosureType, ConformanceHint.UNCHECKED);
        }
    }

    protected void prepareComputation() {
        LightweightTypeReference expectedType = this.getExpectation().getExpectedType();
        if (expectedType == null) {
            throw new IllegalStateException();
        }
        JvmType type = expectedType.getType();
        if (type == null) {
            throw new IllegalStateException();
        }
        this.expectedClosureType = this.initKnownClosureType(type, this.operation);
        this.deferredBindTypeArgument(expectedType, this.expectedClosureType, BoundTypeArgumentSource.INFERRED_CONSTRAINT);
    }

    protected void prepareResultType() {
        this.resultClosureType = new FunctionTypeReference(this.expectedClosureType.getOwner(), this.expectedClosureType.getType());
        for (LightweightTypeReference argument : this.expectedClosureType.getTypeArguments()) {
            this.resultClosureType.addTypeArgument(argument);
        }
    }

    protected FunctionTypeReference initKnownClosureType(JvmType type, JvmOperation operation) {
        ITypeReferenceOwner owner = this.getExpectation().getReferenceOwner();
        FunctionTypeReference result = new FunctionTypeReference(owner, type);
        OwnedConverter converter = new OwnedConverter(owner);
        TypeParameterByUnboundSubstitutor substitutor = new TypeParameterByUnboundSubstitutor(Collections.emptyMap(), owner){

            protected UnboundTypeReference createUnboundTypeReference(JvmTypeParameter type) {
                UnboundTypeReference result = ClosureWithExpectationHelper.this.getExpectation().createUnboundTypeReference(ClosureWithExpectationHelper.this.getClosure(), type);
                return result;
            }
        };
        if (type instanceof JvmTypeParameterDeclarator) {
            EList typeParameters = ((JvmTypeParameterDeclarator)type).getTypeParameters();
            for (JvmTypeParameter typeParameter : typeParameters) {
                ParameterizedTypeReference parameterReference = new ParameterizedTypeReference(owner, (JvmType)typeParameter);
                LightweightTypeReference substituted = substitutor.substitute(parameterReference);
                result.addTypeArgument(substituted);
            }
            Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> definedMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(result);
            substitutor.enhanceMapping(definedMapping);
        }
        LightweightTypeReference declaredReturnType = converter.toLightweightReference(operation.getReturnType());
        for (JvmFormalParameter parameter : operation.getParameters()) {
            LightweightTypeReference lightweight = converter.toLightweightReference(parameter.getParameterType());
            LightweightTypeReference lowerBound = lightweight.getLowerBoundSubstitute();
            LightweightTypeReference substituted = substitutor.substitute(lowerBound);
            result.addParameterType(substituted);
        }
        LightweightTypeReference returnType = declaredReturnType;
        LightweightTypeReference substituted = substitutor.substitute(returnType);
        result.setReturnType(substituted);
        return result;
    }

    protected ITypeComputationState getClosureBodyTypeComputationState(ITypeAssigner typeAssigner) {
        EList exceptions;
        JvmFormalParameter closureParameter;
        List<LightweightTypeReference> operationParameterTypes = this.expectedClosureType.getParameterTypes();
        EList<JvmFormalParameter> closureParameters = this.getClosure().getFormalParameters();
        int paramCount = Math.min(closureParameters.size(), operationParameterTypes.size());
        int i = 0;
        while (i < paramCount) {
            closureParameter = (JvmFormalParameter)closureParameters.get(i);
            LightweightTypeReference operationParameterType = operationParameterTypes.get(i);
            if (closureParameter.eContainingFeature() != XbasePackage.Literals.XCLOSURE__IMPLICIT_PARAMETER && closureParameter.getParameterType() != null) {
                LightweightTypeReference closureParameterType = typeAssigner.toLightweightTypeReference(closureParameter.getParameterType());
                new DeferredTypeParameterHintCollector(this.getExpectation().getReferenceOwner()){

                    protected void addHint(UnboundTypeReference typeParameter, LightweightTypeReference reference) {
                        LightweightTypeReference wrapped = reference.getWrapperTypeIfPrimitive();
                        typeParameter.acceptHint(wrapped, BoundTypeArgumentSource.RESOLVED, this.getOrigin(), this.getExpectedVariance(), this.getActualVariance());
                    }
                }.processPairedReferences(operationParameterType, closureParameterType);
                typeAssigner.assignType((JvmIdentifiableElement)closureParameter, closureParameterType);
                this.resultClosureType.addParameterType(closureParameterType);
            } else {
                typeAssigner.assignType((JvmIdentifiableElement)closureParameter, operationParameterType);
                this.resultClosureType.addParameterType(operationParameterType);
            }
            ++i;
        }
        i = paramCount;
        while (i < closureParameters.size()) {
            closureParameter = (JvmFormalParameter)closureParameters.get(i);
            JvmTypeReference parameterType = closureParameter.getParameterType();
            if (parameterType != null) {
                LightweightTypeReference lightweight = typeAssigner.toLightweightTypeReference(parameterType);
                typeAssigner.assignType((JvmIdentifiableElement)closureParameter, lightweight);
                this.resultClosureType.addParameterType(lightweight);
            } else {
                LightweightTypeReference objectType = typeAssigner.toLightweightTypeReference(this.getServices().getTypeReferences().getTypeForName(Object.class, (Notifier)closureParameter, new JvmTypeReference[0]));
                typeAssigner.assignType((JvmIdentifiableElement)closureParameter, objectType);
                this.resultClosureType.addParameterType(objectType);
            }
            ++i;
        }
        ITypeComputationState result = typeAssigner.getForkedState();
        LightweightTypeReference expectedType = this.getExpectation().getExpectedType();
        if (expectedType == null) {
            throw new IllegalStateException();
        }
        JvmType knownType = expectedType.getType();
        if (knownType != null && knownType instanceof JvmGenericType) {
            result.assignType(IFeatureNames.SELF, knownType, expectedType);
        }
        if ((exceptions = this.operation.getExceptions()).isEmpty()) {
            return result;
        }
        ArrayList expectedExceptions = Lists.newArrayListWithCapacity((int)exceptions.size());
        for (JvmTypeReference exception : exceptions) {
            expectedExceptions.add(typeAssigner.toLightweightTypeReference(exception));
        }
        return result.withExpectedExceptions(expectedExceptions);
    }

    protected boolean processExpressionType(ITypeComputationResult expressionResult) {
        LightweightTypeReference expressionResultType = expressionResult.getReturnType();
        if (expressionResultType == null || expressionResultType instanceof AnyTypeReference) {
            LightweightTypeReference returnType = this.expectedClosureType.getReturnType();
            if (returnType == null) {
                throw new IllegalStateException("return type shall not be null");
            }
            this.resultClosureType.setReturnType(returnType);
        } else {
            LightweightTypeReference expectedReturnType = this.expectedClosureType.getReturnType();
            if (expectedReturnType == null) {
                throw new IllegalStateException("expected return type may not be null");
            }
            if (!expressionResultType.isPrimitiveVoid()) {
                this.deferredBindTypeArgument(expectedReturnType, expressionResultType, BoundTypeArgumentSource.INFERRED);
            }
            if (expectedReturnType.isAssignableFrom(expressionResultType)) {
                this.resultClosureType.setReturnType(expressionResultType);
            } else {
                this.resultClosureType.setReturnType(expectedReturnType);
                return true;
            }
        }
        return false;
    }
}

