/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceResult;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.DefaultReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.ExpectedExceptionsStackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionAwareStackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.FollowUpError;
import org.eclipse.xtext.xbase.typesystem.internal.ReassigningStackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeData;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.ConstraintVisitingInfo;
import org.eclipse.xtext.xbase.typesystem.util.CustomTypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.ExpectationTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.util.Maps2;
import org.eclipse.xtext.xbase.typesystem.util.MultimapJoiner;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByUnboundSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public abstract class ResolvedTypes
implements IResolvedTypes {
    private final OwnedConverter converter;
    private final DefaultReentrantTypeResolver resolver;
    private Set<AbstractDiagnostic> diagnostics;
    private Map<JvmIdentifiableElement, LightweightTypeReference> types;
    private Map<JvmIdentifiableElement, LightweightTypeReference> reassignedTypes;
    private Map<XExpression, List<TypeData>> expressionTypes;
    private Map<XExpression, ILinkingCandidate> featureLinking;
    private Map<Object, UnboundTypeReference> unboundTypeParameters;
    private Map<Object, List<LightweightBoundTypeArgument>> typeParameterHints;
    private Set<Object> resolvedTypeParameters;
    private Set<XExpression> propagatedTypes;
    private List<JvmTypeParameter> declaredTypeParameters;

    protected ResolvedTypes(DefaultReentrantTypeResolver resolver) {
        this.resolver = resolver;
        this.converter = this.createConverter();
    }

    protected void clear() {
        this.diagnostics = null;
        this.types = null;
        this.reassignedTypes = null;
        this.expressionTypes = null;
        this.featureLinking = null;
        this.unboundTypeParameters = null;
        this.typeParameterHints = null;
        this.resolvedTypeParameters = null;
        this.propagatedTypes = null;
        this.declaredTypeParameters = null;
    }

    protected abstract IssueSeverities getSeverities();

    protected OwnedConverter getConverter() {
        return this.converter;
    }

    public ITypeReferenceOwner getReferenceOwner() {
        return this.getConverter().getOwner();
    }

    protected OwnedConverter createConverter() {
        return new OwnedConverter(new Owner());
    }

    public ResourceSet getContextResourceSet() {
        return this.resolver.getRoot().eResource().getResourceSet();
    }

    public CommonTypeComputationServices getServices() {
        return this.resolver.getServices();
    }

    @Override
    public Collection<AbstractDiagnostic> getQueuedDiagnostics() {
        if (this.diagnostics == null) {
            return Collections.emptyList();
        }
        return this.diagnostics;
    }

    public void addDiagnostic(AbstractDiagnostic diagnostic) {
        if (this.diagnostics == null) {
            this.diagnostics = Sets.newLinkedHashSet();
        }
        if (!this.diagnostics.add(diagnostic)) {
            throw new IllegalStateException("Duplicate diagnostic: " + diagnostic);
        }
    }

    @Override
    @Nullable
    public JvmIdentifiableElement getLinkedFeature(@Nullable XAbstractFeatureCall featureCall) {
        return this.doGetLinkedFeature(featureCall);
    }

    @Override
    @Nullable
    public JvmIdentifiableElement getLinkedFeature(@Nullable XConstructorCall constructorCall) {
        return this.doGetLinkedFeature(constructorCall);
    }

    @Nullable
    protected JvmIdentifiableElement doGetLinkedFeature(@Nullable XExpression featureOrConstructorCall) {
        if (this.featureLinking == null || featureOrConstructorCall == null) {
            return null;
        }
        ILinkingCandidate candidate = this.featureLinking.get(featureOrConstructorCall);
        if (candidate == null) {
            return null;
        }
        return candidate.getFeature();
    }

    @Nullable
    protected TypeData getTypeData(XExpression expression, boolean returnType) {
        Collection<TypeData> values = this.doGetTypeData(expression);
        if (values == null) {
            return null;
        }
        TypeData result = this.mergeTypeData(expression, values, returnType, false);
        return result;
    }

    @Nullable
    protected Collection<TypeData> doGetTypeData(XExpression expression) {
        List<TypeData> result = this.basicGetExpressionTypes().get(expression);
        return result;
    }

    @Nullable
    protected TypeData mergeTypeData(XExpression expression, Collection<TypeData> allValues, boolean returnType, boolean nullIfEmpty) {
        ArrayList values = Lists.newArrayListWithCapacity((int)allValues.size());
        this.collectValues(allValues, returnType, values);
        if (values.isEmpty()) {
            if (nullIfEmpty || allValues.isEmpty()) {
                return null;
            }
            if (returnType) {
                values.addAll(allValues);
            }
        }
        if (values.size() == 1) {
            TypeData typeData = (TypeData)values.get(0);
            LightweightTypeReference upperBoundSubstitute = typeData.getActualType().getUpperBoundSubstitute();
            if (upperBoundSubstitute != typeData.getActualType()) {
                return new TypeData(expression, typeData.getExpectation(), upperBoundSubstitute, typeData.getConformanceHints(), returnType);
            }
            return typeData;
        }
        MergeData mergeData = new MergeData();
        this.enhanceMergeData(values, mergeData);
        LightweightTypeReference mergedType = this.getMergedType(mergeData, values);
        if (mergedType == null) {
            return null;
        }
        if (mergeData.expectation == null) {
            throw new IllegalStateException("Expectation should never be null here");
        }
        mergedType = this.refineMergedType(mergeData, mergedType, returnType, nullIfEmpty);
        TypeData result = new TypeData(expression, mergeData.expectation, mergedType, mergeData.mergedHints, returnType);
        return result;
    }

    private LightweightTypeReference refineMergedType(MergeData mergeData, LightweightTypeReference mergedType, boolean returnType, boolean useExpectation) {
        LightweightTypeReference expectedType;
        if (useExpectation && mergeData.expectation != null && (returnType || !mergeData.allNoImplicitReturn) && (expectedType = mergeData.expectation.getExpectedType()) != null && expectedType.isResolved() && !expectedType.isAssignableFrom(mergedType)) {
            boolean valid = true;
            for (LightweightTypeReference mergedReference : mergeData.references) {
                if (expectedType.isAssignableFrom(mergedReference)) continue;
                valid = false;
                break;
            }
            if (valid) {
                mergedType = expectedType;
            }
        }
        if (mergeData.voidSeen && returnType && !mergeData.references.isEmpty()) {
            mergedType = mergedType.getWrapperTypeIfPrimitive();
        }
        return mergedType;
    }

    @Nullable
    private LightweightTypeReference getMergedType(MergeData mergeData, List<TypeData> values) {
        LightweightTypeReference mergedType = !mergeData.references.isEmpty() || !mergeData.voidSeen ? this.getMergedType(mergeData.references) : values.get(0).getActualType();
        return mergedType;
    }

    private void enhanceMergeData(List<TypeData> values, MergeData mergeData) {
        for (TypeData value : values) {
            ITypeExpectation knownExpectation;
            LightweightTypeReference reference = value.getActualType().getUpperBoundSubstitute();
            if (reference.isPrimitiveVoid()) {
                mergeData.voidSeen = true;
            } else {
                mergeData.references.add(reference);
            }
            mergeData.allNoImplicitReturn = mergeData.allNoImplicitReturn && value.getConformanceHints().contains((Object)ConformanceHint.NO_IMPLICIT_RETURN);
            mergeData.mergedHints.addAll(value.getConformanceHints());
            if (mergeData.expectation == null) {
                mergeData.expectation = value.getExpectation();
                continue;
            }
            if (mergeData.expectation.getExpectedType() != null || (knownExpectation = value.getExpectation()).getExpectedType() == null) continue;
            mergeData.expectation = knownExpectation;
        }
        if (!mergeData.allNoImplicitReturn) {
            mergeData.mergedHints.remove((Object)ConformanceHint.NO_IMPLICIT_RETURN);
        }
    }

    private void collectValues(Collection<TypeData> allValues, boolean returnType, List<TypeData> result) {
        for (TypeData value : allValues) {
            if (returnType != value.isReturnType()) continue;
            result.add(value);
        }
    }

    @Nullable
    protected LightweightTypeReference getMergedType(List<LightweightTypeReference> types) {
        if (types.isEmpty()) {
            return null;
        }
        if (types.size() == 1) {
            LightweightTypeReference result = types.get(0);
            return result;
        }
        LightweightTypeReference result = this.getServices().getTypeConformanceComputer().getCommonSuperType(types, this.getReferenceOwner());
        if (result != null || types.isEmpty()) {
            return result;
        }
        for (LightweightTypeReference type : types) {
            if (type.isType(Void.TYPE)) continue;
            return type;
        }
        return types.get(0);
    }

    @Override
    @Nullable
    public LightweightTypeReference getActualType(XExpression expression) {
        LightweightTypeReference result = this.doGetActualType(expression);
        return this.toOwnedReference(result);
    }

    @Nullable
    protected abstract LightweightTypeReference getExpectedTypeForAssociatedExpression(JvmMember var1, XExpression var2);

    @Override
    @Nullable
    public LightweightTypeReference getReturnType(XExpression expression) {
        LightweightTypeReference result = this.doGetReturnType(expression);
        return this.toOwnedReference(result);
    }

    @Nullable
    protected LightweightTypeReference toOwnedReference(@Nullable LightweightTypeReference result) {
        return result != null ? result.copyInto(this.getReferenceOwner()) : null;
    }

    @Nullable
    protected LightweightTypeReference doGetActualType(XExpression expression) {
        TypeData typeData = this.getTypeData(expression, false);
        if (typeData != null) {
            return typeData.getActualType();
        }
        return null;
    }

    @Nullable
    protected LightweightTypeReference doGetReturnType(XExpression expression) {
        TypeData typeData = this.getTypeData(expression, true);
        if (typeData != null) {
            return typeData.getActualType();
        }
        return null;
    }

    @Override
    @Nullable
    public LightweightTypeReference getExpectedType(XExpression expression) {
        LightweightTypeReference result = this.doGetExpectedType(expression, false);
        return this.toOwnedReference(result);
    }

    protected ResolvedTypes pushExpectedExceptions(List<LightweightTypeReference> exceptions) {
        return new ExpectedExceptionsStackedResolvedTypes(this, exceptions);
    }

    protected ResolvedTypes discardExpectedExceptions() {
        return new ExpectedExceptionsStackedResolvedTypes(this);
    }

    protected ResolvedTypes pushExpectedExceptions(JvmExecutable exceptionDeclarator) {
        EList executablesExceptions = exceptionDeclarator.getExceptions();
        if (executablesExceptions.isEmpty()) {
            return this;
        }
        ArrayList exceptions = Lists.newArrayListWithCapacity((int)executablesExceptions.size());
        for (JvmTypeReference exception : executablesExceptions) {
            exceptions.add(this.getConverter().toLightweightReference(exception));
        }
        return this.pushExpectedExceptions(exceptions);
    }

    @Override
    @Nullable
    public LightweightTypeReference getExpectedReturnType(XExpression expression) {
        LightweightTypeReference result = this.doGetExpectedType(expression, true);
        return this.toOwnedReference(result);
    }

    @Override
    public boolean isVoidTypeAllowed(XExpression expression) {
        TypeData typeData = this.getTypeData(expression, false);
        if (typeData != null) {
            return typeData.getExpectation().isVoidTypeAllowed();
        }
        return true;
    }

    public boolean isVoidReturnTypeAllowed(XExpression expression) {
        TypeData typeData = this.getTypeData(expression, true);
        if (typeData != null && typeData.isReturnType()) {
            return typeData.getExpectation().isVoidTypeAllowed();
        }
        return true;
    }

    @Nullable
    protected LightweightTypeReference doGetExpectedType(XExpression expression, boolean returnType) {
        TypeData typeData = this.getTypeData(expression, returnType);
        if (typeData != null) {
            return typeData.getExpectation().getExpectedType();
        }
        return null;
    }

    @Override
    public final List<LightweightTypeReference> getActualTypeArguments(XExpression expression) {
        List<LightweightTypeReference> result = this.doGetActualTypeArguments(expression);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Nullable
    protected List<LightweightTypeReference> doGetActualTypeArguments(XExpression expression) {
        ILinkingCandidate result = this.basicGetLinkingCandidates().get(expression);
        if (result != null) {
            return result.getTypeArguments();
        }
        return Collections.emptyList();
    }

    public void setType(JvmIdentifiableElement identifiable, LightweightTypeReference reference) {
        if (this.ensureTypesMapExists().put(identifiable, reference) != null) {
            throw new IllegalStateException("identifiable was already typed");
        }
    }

    public void reassignType(JvmIdentifiableElement identifiable, @Nullable LightweightTypeReference reference) {
        if (reference != null) {
            LightweightTypeReference actualType = this.getActualType(identifiable);
            if (actualType != null) {
                if (!reference.isAssignableFrom(actualType)) {
                    if (actualType.isAssignableFrom(reference)) {
                        this.ensureReassignedTypesMapExists().put(identifiable, reference);
                    } else {
                        CompoundTypeReference multiType = actualType.toMultiType(reference);
                        this.ensureReassignedTypesMapExists().put(identifiable, multiType);
                    }
                }
            } else {
                this.ensureReassignedTypesMapExists().put(identifiable, reference);
            }
        } else if (this.reassignedTypes != null) {
            this.ensureReassignedTypesMapExists().remove(identifiable);
        }
    }

    public void reassignTypeWithoutMerge(JvmIdentifiableElement identifiable, @Nullable LightweightTypeReference reference) {
        this.ensureReassignedTypesMapExists().put(identifiable, reference);
    }

    protected LightweightTypeReference acceptType(final XExpression expression, AbstractTypeExpectation expectation, LightweightTypeReference type, boolean returnType, ConformanceHint ... hints) {
        if (!type.isOwnedBy(this.getReferenceOwner())) {
            throw new IllegalArgumentException("type is associated with an incompatible owner");
        }
        if (!expectation.isOwnedBy(this.getReferenceOwner())) {
            throw new IllegalArgumentException("expected type is associated with an incompatible owner");
        }
        TypeParameterByUnboundSubstitutor substitutor = new TypeParameterByUnboundSubstitutor(Collections.emptyMap(), this.getReferenceOwner()){

            @Nullable
            protected UnboundTypeReference createUnboundTypeReference(JvmTypeParameter type) {
                if (expression instanceof XAbstractFeatureCall || expression instanceof XConstructorCall || expression instanceof XClosure) {
                    return ResolvedTypes.this.createUnboundTypeReference(expression, type);
                }
                return null;
            }
        };
        LightweightTypeReference actualType = ((TypeParameterSubstitutor)substitutor).substitute(type).getUpperBoundSubstitute();
        this.acceptType(expression, new TypeData(expression, expectation, actualType, EnumSet.copyOf(Arrays.asList(hints)), returnType));
        return actualType;
    }

    protected EnumSet<ConformanceHint> getConformanceHints(TypeData typeData, boolean recompute) {
        EnumSet<ConformanceHint> conformanceHints = typeData.getConformanceHints();
        if (recompute) {
            conformanceHints.add(ConformanceHint.UNCHECKED);
            conformanceHints.remove((Object)ConformanceHint.INCOMPATIBLE);
            conformanceHints.remove((Object)ConformanceHint.SUCCESS);
        }
        if (conformanceHints.contains((Object)ConformanceHint.UNCHECKED)) {
            LightweightTypeReference actualType = typeData.getActualType();
            ITypeExpectation expectation = typeData.getExpectation();
            LightweightTypeReference expectedType = expectation.getExpectedType();
            if (expectedType != null) {
                TypeConformanceResult conformanceResult = expectedType.getUpperBoundSubstitute().internalIsAssignableFrom(actualType, new TypeConformanceComputationArgument());
                conformanceHints.addAll(conformanceResult.getConformanceHints());
                conformanceHints.remove((Object)ConformanceHint.UNCHECKED);
                conformanceHints.add(ConformanceHint.CHECKED);
            } else {
                conformanceHints.remove((Object)ConformanceHint.UNCHECKED);
                conformanceHints.add(ConformanceHint.CHECKED);
                conformanceHints.add(ConformanceHint.SUCCESS);
            }
        }
        return conformanceHints;
    }

    protected void acceptType(XExpression expression, TypeData typeData) {
        Maps2.putIntoListMap(expression, typeData, this.ensureExpressionTypesMapExists());
    }

    protected Map<JvmIdentifiableElement, LightweightTypeReference> basicGetTypes() {
        return this.types != null ? this.types : Collections.emptyMap();
    }

    private Map<JvmIdentifiableElement, LightweightTypeReference> ensureTypesMapExists() {
        if (this.types == null) {
            this.types = Maps.newLinkedHashMap();
        }
        return this.types;
    }

    private Map<JvmIdentifiableElement, LightweightTypeReference> ensureReassignedTypesMapExists() {
        if (this.reassignedTypes == null) {
            this.reassignedTypes = Maps.newLinkedHashMap();
        }
        return this.reassignedTypes;
    }

    protected Map<XExpression, List<TypeData>> basicGetExpressionTypes() {
        return this.expressionTypes != null ? this.expressionTypes : Collections.emptyMap();
    }

    private Map<XExpression, List<TypeData>> ensureExpressionTypesMapExists() {
        if (this.expressionTypes == null) {
            this.expressionTypes = Maps.newHashMap();
        }
        return this.expressionTypes;
    }

    protected void refineExpectedType(XExpression receiver, ITypeExpectation refinedExpectation) {
        Collection typeData = this.ensureExpressionTypesMapExists().get(receiver);
        ArrayList replaced = Lists.newArrayListWithCapacity((int)typeData.size());
        for (TypeData existing : typeData) {
            TypeData newTypeData = new TypeData(receiver, refinedExpectation, existing.getActualType(), existing.getConformanceHints(), existing.isReturnType());
            replaced.add(newTypeData);
        }
        this.ensureExpressionTypesMapExists().put(receiver, replaced);
    }

    protected Map<Object, List<LightweightBoundTypeArgument>> basicGetTypeParameterHints() {
        return this.typeParameterHints != null ? this.typeParameterHints : Collections.emptyMap();
    }

    private Map<Object, List<LightweightBoundTypeArgument>> ensureTypeParameterHintsMapExists() {
        if (this.typeParameterHints == null) {
            this.typeParameterHints = Maps.newHashMap();
        }
        return this.typeParameterHints;
    }

    private Map<XExpression, ILinkingCandidate> ensureLinkingMapExists() {
        if (this.featureLinking == null) {
            this.featureLinking = Maps.newLinkedHashMap();
        }
        return this.featureLinking;
    }

    protected Map<XExpression, ILinkingCandidate> basicGetLinkingCandidates() {
        return this.featureLinking != null ? this.featureLinking : Collections.emptyMap();
    }

    @Override
    public Collection<ILinkingCandidate> getFollowUpErrors() {
        return Collections2.filter(this.basicGetLinkingCandidates().values(), (Predicate)new Predicate<ILinkingCandidate>(){

            public boolean apply(@Nullable ILinkingCandidate input) {
                if (input == null) {
                    throw new IllegalArgumentException();
                }
                return input instanceof FollowUpError;
            }
        });
    }

    @Override
    @Nullable
    public LightweightTypeReference getActualType(JvmIdentifiableElement identifiable) {
        LightweightTypeReference result = this.doGetActualType(identifiable, false);
        return this.toOwnedReference(result);
    }

    @Nullable
    protected LightweightTypeReference doGetActualType(JvmIdentifiableElement identifiable, boolean ignoreReassignedTypes) {
        LightweightTypeReference result;
        if (this.reassignedTypes != null && !ignoreReassignedTypes && (result = this.reassignedTypes.get(identifiable)) != null) {
            return result;
        }
        if (this.types == null) {
            return this.getDeclaredType(identifiable);
        }
        result = this.basicGetTypes().get(identifiable);
        if (result == null) {
            return this.getDeclaredType(identifiable);
        }
        return result;
    }

    @Nullable
    protected LightweightTypeReference getDeclaredType(JvmIdentifiableElement identifiable) {
        if (identifiable instanceof JvmType) {
            ParameterizedTypeReference result = new ParameterizedTypeReference(this.getConverter().getOwner(), (JvmType)identifiable);
            if (identifiable instanceof JvmTypeParameterDeclarator) {
                for (JvmTypeParameter param : ((JvmTypeParameterDeclarator)identifiable).getTypeParameters()) {
                    result.addTypeArgument(new ParameterizedTypeReference(this.getConverter().getOwner(), (JvmType)param));
                }
            }
            return result;
        }
        JvmTypeReference type = this.getUnconvertedDeclaredType(identifiable);
        if (type != null) {
            LightweightTypeReference result = this.getConverter().toLightweightReference(type);
            return result;
        }
        return null;
    }

    @Nullable
    protected JvmTypeReference getUnconvertedDeclaredType(JvmIdentifiableElement identifiable) {
        if (identifiable instanceof JvmOperation) {
            return ((JvmOperation)identifiable).getReturnType();
        }
        if (identifiable instanceof JvmField) {
            return ((JvmField)identifiable).getType();
        }
        if (identifiable instanceof JvmConstructor) {
            return this.resolver.getServices().getTypeReferences().createTypeRef((JvmType)((JvmConstructor)identifiable).getDeclaringType(), new JvmTypeReference[0]);
        }
        if (identifiable instanceof JvmFormalParameter) {
            JvmTypeReference parameterType = ((JvmFormalParameter)identifiable).getParameterType();
            return parameterType;
        }
        return null;
    }

    @Nullable
    public IFeatureLinkingCandidate getFeature(XAbstractFeatureCall featureCall) {
        return (IFeatureLinkingCandidate)this.basicGetLinkingCandidates().get(featureCall);
    }

    @Nullable
    public IConstructorLinkingCandidate getConstructor(XConstructorCall constructorCall) {
        return (IConstructorLinkingCandidate)this.basicGetLinkingCandidates().get(constructorCall);
    }

    public void acceptLinkingInformation(XExpression expression, ILinkingCandidate candidate) {
        ILinkingCandidate prev = this.ensureLinkingMapExists().put(expression, candidate);
        if (prev != null) {
            throw new IllegalStateException("Expression " + expression + " was already linked to: " + prev + "\nCannot relink to: " + candidate);
        }
    }

    protected DefaultReentrantTypeResolver getResolver() {
        return this.resolver;
    }

    protected UnboundTypeReference getUnboundTypeReference(Object handle) {
        UnboundTypeReference result = this.basicGetTypeParameters().get(handle);
        if (result == null) {
            throw new IllegalStateException("Could not find type parameter");
        }
        if (result.internalIsResolved()) {
            throw new IllegalStateException("Cannot query unbount type reference that was already resolved");
        }
        return result;
    }

    protected UnboundTypeReference createUnboundTypeReference(XExpression expression, JvmTypeParameter type) {
        UnboundTypeReference result = new UnboundTypeReference(this.getReferenceOwner(), expression, type){};
        this.acceptUnboundTypeReference(result.getHandle(), result);
        return result;
    }

    protected void acceptUnboundTypeReference(Object handle, UnboundTypeReference reference) {
        this.ensureTypeParameterMapExists().put(handle, reference);
    }

    protected Map<Object, UnboundTypeReference> basicGetTypeParameters() {
        return this.unboundTypeParameters != null ? this.unboundTypeParameters : Collections.emptyMap();
    }

    private Map<Object, UnboundTypeReference> ensureTypeParameterMapExists() {
        if (this.unboundTypeParameters == null) {
            this.unboundTypeParameters = Maps.newLinkedHashMap();
        }
        return this.unboundTypeParameters;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName()).append(": [");
        this.appendContent(result, "  ");
        this.closeBracket(result, "");
        return result.toString();
    }

    protected void closeBracket(StringBuilder result, String indentation) {
        if (result.charAt(result.length() - 1) != '[') {
            result.append('\n').append(indentation).append("]");
        } else {
            result.append("]");
        }
    }

    protected void appendContent(StringBuilder result, String indentation) {
        this.appendContent(this.types, "types", result, indentation);
        this.appendContent(this.reassignedTypes, "reassignedTypes", result, indentation);
        this.appendListMapContent(this.expressionTypes, "expressionTypes", result, indentation);
        this.appendContent(this.featureLinking, "featureLinking", result, indentation);
        this.appendContent(this.unboundTypeParameters, "unboundTypeParameters", result, indentation);
        this.appendListMapContent(this.typeParameterHints, "typeParameterHints", result, indentation);
        this.appendContent(this.declaredTypeParameters, "declaredTypeParameters", result, indentation);
        this.appendContent(this.diagnostics, "diagnostics", result, indentation);
        this.appendContent(this.propagatedTypes, "propagatedTypes", result, indentation);
    }

    protected void appendContent(@Nullable Map<?, ?> map, String prefix, StringBuilder result, String indentation) {
        if (map != null) {
            Joiner.MapJoiner joiner = Joiner.on((String)("\n  " + indentation)).withKeyValueSeparator(" -> ");
            result.append("\n").append(indentation).append(prefix).append(":\n").append(indentation).append("  ");
            joiner.appendTo(result, map);
        }
    }

    protected void appendContent(@Nullable Collection<?> values, String prefix, StringBuilder result, String indentation) {
        if (values != null) {
            Joiner joiner = Joiner.on((String)("\n  " + indentation));
            result.append("\n").append(indentation).append(prefix).append(":\n").append(indentation).append("  ");
            joiner.appendTo(result, values);
        }
    }

    protected void appendListMapContent(@Nullable Map<?, ? extends Collection<?>> map, String prefix, StringBuilder result, String indentation) {
        if (map != null) {
            MultimapJoiner joiner = new MultimapJoiner(Joiner.on((String)("\n    " + indentation)), "\n  " + indentation, " ->\n" + indentation + "    ");
            result.append("\n").append(indentation).append(prefix).append(":\n").append(indentation).append("  ");
            joiner.appendTo(result, map);
        }
    }

    public void acceptHint(Object handle, LightweightBoundTypeArgument boundTypeArgument) {
        if (boundTypeArgument.getSource() == BoundTypeArgumentSource.RESOLVED) {
            if (this.resolvedTypeParameters == null) {
                this.resolvedTypeParameters = Sets.newHashSetWithExpectedSize((int)3);
            }
            if (this.resolvedTypeParameters.add(handle)) {
                if (boundTypeArgument.getDeclaredVariance().mergeDeclaredWithActual(boundTypeArgument.getActualVariance()) == VarianceInfo.INVARIANT) {
                    this.resolveDependentTypeArguments(handle, boundTypeArgument);
                }
                LightweightBoundTypeArgument boundWithoutRecursion = this.removeRecursiveTypeArguments(handle, boundTypeArgument);
                this.ensureTypeParameterHintsMapExists().put(handle, Collections.singletonList(boundWithoutRecursion));
            }
        } else if (!this.isResolved(handle)) {
            if (boundTypeArgument.getTypeReference() instanceof UnboundTypeReference && boundTypeArgument.getSource() != BoundTypeArgumentSource.CONSTRAINT) {
                UnboundTypeReference other = (UnboundTypeReference)boundTypeArgument.getTypeReference();
                Object otherHandle = other.getHandle();
                if (this.ensureTypeParameterHintsMapExists().containsKey(handle)) {
                    List<LightweightBoundTypeArgument> existingValues = this.ensureTypeParameterHintsMapExists().get(handle);
                    for (LightweightBoundTypeArgument existingValue : existingValues) {
                        if (!(existingValue.getTypeReference() instanceof UnboundTypeReference) || ((UnboundTypeReference)existingValue.getTypeReference()).getHandle() != otherHandle || existingValue.getActualVariance() != boundTypeArgument.getActualVariance() || existingValue.getDeclaredVariance() != boundTypeArgument.getDeclaredVariance() || existingValue.getSource() != boundTypeArgument.getSource()) continue;
                        return;
                    }
                }
                UnboundTypeReference currentUnbound = this.getUnboundTypeReference(handle);
                Maps2.putIntoListMap(otherHandle, this.copyBoundTypeArgument(currentUnbound, boundTypeArgument), this.ensureTypeParameterHintsMapExists());
            }
            Maps2.putIntoListMap(handle, boundTypeArgument, this.ensureTypeParameterHintsMapExists());
        } else {
            throw new IllegalStateException("Cannot add hints if the reference was already resolved");
        }
    }

    protected LightweightBoundTypeArgument copyBoundTypeArgument(LightweightTypeReference typeReference, LightweightBoundTypeArgument boundTypeArgument) {
        return new LightweightBoundTypeArgument(typeReference, boundTypeArgument.getSource(), boundTypeArgument.getOrigin(), boundTypeArgument.getDeclaredVariance(), boundTypeArgument.getActualVariance());
    }

    protected LightweightBoundTypeArgument removeRecursiveTypeArguments(final Object handle, LightweightBoundTypeArgument boundTypeArgument) {
        final HashSet handles = Sets.newHashSet((Object[])new Object[]{handle});
        LightweightTypeReference boundArgumentWithoutRecursion = new CustomTypeParameterSubstitutor(Collections.emptyMap(), boundTypeArgument.getTypeReference().getOwner()){

            protected LightweightTypeReference doVisitUnboundTypeReference(UnboundTypeReference reference, ConstraintVisitingInfo visiting) {
                if (!handle.equals(reference.getHandle())) {
                    return reference;
                }
                JvmTypeParameter typeParameter = reference.getTypeParameter();
                if (!visiting.tryVisit(typeParameter)) {
                    LightweightTypeReference mappedReference = this.getDeclaredUpperBound(typeParameter, visiting);
                    this.getTypeParameterMapping().put(typeParameter, new LightweightMergedBoundTypeArgument(mappedReference, VarianceInfo.INVARIANT));
                    if (mappedReference != null) {
                        return mappedReference;
                    }
                    return this.getObjectReference((EObject)typeParameter);
                }
                try {
                    LightweightMergedBoundTypeArgument boundTypeArgument = this.getTypeParameterMapping().get(typeParameter);
                    if (boundTypeArgument != null && boundTypeArgument.getTypeReference() != reference) {
                        LightweightTypeReference result;
                        LightweightTypeReference lightweightTypeReference = result = boundTypeArgument.getTypeReference().accept(this, visiting);
                        return lightweightTypeReference;
                    }
                    LightweightTypeReference mappedReference = this.getDeclaredUpperBound(visiting.getCurrentDeclarator(), visiting.getCurrentIndex(), visiting);
                    this.getTypeParameterMapping().put(typeParameter, new LightweightMergedBoundTypeArgument(mappedReference, VarianceInfo.INVARIANT));
                    LightweightTypeReference lightweightTypeReference = mappedReference;
                    return lightweightTypeReference;
                }
                finally {
                    visiting.didVisit(typeParameter);
                }
            }

            protected LightweightTypeReference doVisitWildcardTypeReference(WildcardTypeReference reference, ConstraintVisitingInfo visiting) {
                if (reference.isResolved() && reference.isOwnedBy(this.getOwner())) {
                    return reference;
                }
                LightweightTypeReference lowerBound = reference.getLowerBound();
                if (lowerBound instanceof UnboundTypeReference && !handles.add(((UnboundTypeReference)lowerBound).getHandle())) {
                    WildcardTypeReference result = new WildcardTypeReference(this.getOwner());
                    for (LightweightTypeReference upperBound : reference.getUpperBounds()) {
                        result.addUpperBound(this.visitTypeArgument(upperBound, visiting));
                    }
                    return result;
                }
                return super.doVisitWildcardTypeReference(reference, visiting);
            }

            @Nullable
            protected LightweightTypeReference getUnmappedSubstitute(ParameterizedTypeReference reference, JvmTypeParameter type, ConstraintVisitingInfo visiting) {
                return reference;
            }
        }.substitute(boundTypeArgument.getTypeReference());
        LightweightBoundTypeArgument boundWithoutRecursion = this.copyBoundTypeArgument(boundArgumentWithoutRecursion, boundTypeArgument);
        return boundWithoutRecursion;
    }

    protected void resolveDependentTypeArguments(Object handle, LightweightBoundTypeArgument boundTypeArgument) {
        List<LightweightBoundTypeArgument> existingTypeArguments = this.ensureTypeParameterHintsMapExists().get(handle);
        if (existingTypeArguments != null) {
            int i = 0;
            while (i < existingTypeArguments.size()) {
                UnboundTypeReference existingReference;
                LightweightBoundTypeArgument existingTypeArgument = existingTypeArguments.get(i);
                if (existingTypeArgument.getSource() == BoundTypeArgumentSource.INFERRED) {
                    if (existingTypeArgument.getTypeReference() instanceof UnboundTypeReference) {
                        existingReference = (UnboundTypeReference)existingTypeArgument.getTypeReference();
                        if (existingTypeArgument.getDeclaredVariance() == existingTypeArgument.getActualVariance()) {
                            this.acceptHint(existingReference.getHandle(), boundTypeArgument);
                        }
                    } else if (existingTypeArgument.getTypeReference() != null && existingTypeArgument.getTypeReference() != boundTypeArgument.getTypeReference() && !existingTypeArgument.getTypeReference().isResolved()) {
                        ExpectationTypeParameterHintCollector collector = new ExpectationTypeParameterHintCollector(this.getReferenceOwner());
                        collector.processPairedReferences(boundTypeArgument.getTypeReference(), existingTypeArgument.getTypeReference());
                    }
                } else if (existingTypeArgument.getSource() == BoundTypeArgumentSource.CONSTRAINT && existingTypeArgument.getTypeReference() instanceof UnboundTypeReference && !(existingReference = (UnboundTypeReference)existingTypeArgument.getTypeReference()).internalIsResolved()) {
                    existingReference.acceptHint(boundTypeArgument.getTypeReference(), BoundTypeArgumentSource.INFERRED, boundTypeArgument, VarianceInfo.OUT, VarianceInfo.OUT);
                }
                ++i;
            }
        }
    }

    public boolean isResolved(Object handle) {
        return this.resolvedTypeParameters != null && this.resolvedTypeParameters.contains(handle);
    }

    protected boolean isPropagatedType(XExpression expression) {
        return this.propagatedTypes != null && this.propagatedTypes.contains(expression);
    }

    protected void setPropagatedType(XExpression expression) {
        if (this.propagatedTypes == null) {
            this.propagatedTypes = Sets.newHashSet((Object[])new XExpression[]{expression});
        } else {
            this.propagatedTypes.add(expression);
        }
    }

    protected Set<XExpression> basicGetPropagatedTypes() {
        return this.propagatedTypes != null ? this.propagatedTypes : Collections.emptySet();
    }

    @Nullable
    protected List<JvmTypeParameter> basicGetDeclardTypeParameters() {
        return this.declaredTypeParameters;
    }

    public List<JvmTypeParameter> getDeclaredTypeParameters() {
        return this.declaredTypeParameters != null ? this.declaredTypeParameters : Collections.emptyList();
    }

    public void addDeclaredTypeParameters(List<JvmTypeParameter> typeParameters) {
        if (this.declaredTypeParameters == null) {
            this.declaredTypeParameters = Lists.newArrayList(typeParameters);
        } else {
            this.declaredTypeParameters.addAll(typeParameters);
        }
    }

    protected List<LightweightTypeReference> getExpectedExceptions() {
        return Collections.emptyList();
    }

    public List<LightweightBoundTypeArgument> getAllHints(Object handle) {
        List<LightweightBoundTypeArgument> actualHints = this.getHints(handle);
        int i = 0;
        while (i < actualHints.size()) {
            LightweightBoundTypeArgument hint = actualHints.get(i);
            if (hint.getTypeReference() instanceof UnboundTypeReference) break;
            ++i;
        }
        if (i >= actualHints.size()) {
            return actualHints;
        }
        ArrayList transitivity = Lists.newArrayList();
        HashSet seenHandles = Sets.newHashSet((Object[])new Object[]{handle});
        transitivity.addAll(actualHints.subList(0, i));
        List<LightweightBoundTypeArgument> allRemaining = actualHints.subList(i, actualHints.size());
        this.addNonRecursiveHints(allRemaining, seenHandles, transitivity);
        return transitivity;
    }

    protected List<LightweightBoundTypeArgument> getHints(Object handle) {
        List<LightweightBoundTypeArgument> result = this.basicGetTypeParameterHints().get(handle);
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    protected void addNonRecursiveHints(List<LightweightBoundTypeArgument> hints, Set<Object> seenHandles, List<LightweightBoundTypeArgument> result) {
        for (LightweightBoundTypeArgument hint : hints) {
            LightweightTypeReference reference = hint.getTypeReference();
            if (reference instanceof UnboundTypeReference) {
                this.addNonRecursiveHints(hint, (UnboundTypeReference)reference, seenHandles, result);
                continue;
            }
            if (result.contains(hint)) continue;
            result.add(hint);
        }
    }

    protected void addNonRecursiveHints(LightweightBoundTypeArgument original, List<LightweightBoundTypeArgument> hints, Set<Object> seenHandles, List<LightweightBoundTypeArgument> result) {
        for (LightweightBoundTypeArgument hint : hints) {
            LightweightTypeReference reference = hint.getTypeReference();
            if (reference instanceof UnboundTypeReference) {
                this.addNonRecursiveHints(original, (UnboundTypeReference)reference, seenHandles, result);
                continue;
            }
            if (original.getDeclaredVariance() == VarianceInfo.IN && hint.getTypeReference() instanceof WildcardTypeReference) {
                LightweightTypeReference upperBound = hint.getTypeReference().getUpperBoundSubstitute();
                if (upperBound instanceof UnboundTypeReference) {
                    this.addNonRecursiveHints(original, (UnboundTypeReference)upperBound, seenHandles, result);
                    continue;
                }
                LightweightBoundTypeArgument delegateHint = new LightweightBoundTypeArgument(upperBound, original.getSource(), hint.getOrigin(), hint.getDeclaredVariance(), original.getActualVariance());
                result.add(delegateHint);
                continue;
            }
            if (result.contains(hint)) continue;
            result.add(hint);
        }
    }

    protected void addNonRecursiveHints(LightweightBoundTypeArgument original, UnboundTypeReference reference, Set<Object> seenHandles, List<LightweightBoundTypeArgument> result) {
        Object otherHandle = reference.getHandle();
        if (seenHandles.add(otherHandle)) {
            this.addNonRecursiveHints(original, this.getHints(otherHandle), seenHandles, result);
        }
    }

    protected StackedResolvedTypes pushTypes() {
        return new StackedResolvedTypes(this);
    }

    protected ExpressionAwareStackedResolvedTypes pushTypes(XExpression context) {
        ExpressionAwareStackedResolvedTypes result = new ExpressionAwareStackedResolvedTypes(this, context);
        return result;
    }

    protected StackedResolvedTypes pushReassigningTypes() {
        return new ReassigningStackedResolvedTypes(this);
    }

    protected abstract void markToBeInferred(XExpression var1);

    private static class MergeData {
        List<LightweightTypeReference> references = Lists.newArrayList();
        boolean voidSeen = false;
        ITypeExpectation expectation = null;
        boolean allNoImplicitReturn = true;
        EnumSet<ConformanceHint> mergedHints = EnumSet.of(ConformanceHint.MERGED);

        private MergeData() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Owner
    implements ITypeReferenceOwner {
        protected Owner() {
        }

        @Override
        public CommonTypeComputationServices getServices() {
            return ResolvedTypes.this.getServices();
        }

        @Override
        public ResourceSet getContextResourceSet() {
            return ResolvedTypes.this.getContextResourceSet();
        }

        @Override
        public void acceptHint(Object handle, LightweightBoundTypeArgument boundTypeArgument) {
            ResolvedTypes.this.acceptHint(handle, boundTypeArgument);
        }

        @Override
        public List<LightweightBoundTypeArgument> getAllHints(Object handle) {
            return ResolvedTypes.this.getAllHints(handle);
        }

        @Override
        public boolean isResolved(Object handle) {
            return ResolvedTypes.this.isResolved(handle);
        }

        @Override
        public List<JvmTypeParameter> getDeclaredTypeParameters() {
            return ResolvedTypes.this.getDeclaredTypeParameters();
        }

        public String toString() {
            return String.format("Owner: %s", ResolvedTypes.this);
        }
    }
}

